/*
 * Decompiled with CFR 0.152.
 */
package ise.library.ascii;

import java.io.BufferedReader;
import java.io.StringReader;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MessageBox {
    private static String LS = System.getProperty("line.separator");
    private static int MAX_WIDTH = 60;

    public static void setMaxWidth(int width) {
        MAX_WIDTH = width;
    }

    public static int getMaxWidth() {
        return MAX_WIDTH;
    }

    public static String box(CharSequence text) {
        return MessageBox.box(null, text);
    }

    public static String box(CharSequence title, CharSequence text) {
        if (title == null && text == null) {
            return "";
        }
        if (title != null && text == null) {
            text = title;
            title = null;
        }
        List title_lines = MessageBox.getLines(title);
        List text_lines = MessageBox.getLines(text);
        int width = Math.max(MessageBox.getWidth(title_lines), MessageBox.getWidth(text_lines));
        StringBuffer sb = new StringBuffer();
        sb.append(LS);
        if (title_lines != null) {
            sb.append(MessageBox.boxTitle(title_lines, width));
        }
        sb.append(MessageBox.boxText(text_lines, width));
        return sb.toString();
    }

    private static int getWidth(List lines) {
        if (lines == null) {
            return 0;
        }
        int width = 0;
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            width = Math.max(width, ((String)it.next()).length());
        }
        return width;
    }

    private static List wrapLine(String line) {
        String subline;
        int start;
        ArrayList<String> list = new ArrayList<String>();
        if (line.length() <= MAX_WIDTH) {
            list.add(line);
            return list;
        }
        BreakIterator words = BreakIterator.getWordInstance();
        words.setText(line);
        StringBuffer sb = new StringBuffer();
        int first = start = words.first();
        int end = start;
        end = words.next();
        while (end != -1) {
            sb.append(line.substring(start, end));
            if (sb.length() > MAX_WIDTH) break;
            start = end;
            end = words.next();
        }
        if ((subline = line.substring(first, end)).startsWith(" ") && !subline.startsWith("  ")) {
            subline = subline.substring(1);
        }
        list.add(subline);
        if (line.substring(end).length() > 0) {
            list.addAll(MessageBox.wrapLine(line.substring(end + 1)));
        }
        return list;
    }

    private static List getLines(CharSequence text) {
        if (text == null) {
            return null;
        }
        ArrayList lines = new ArrayList();
        BufferedReader br = new BufferedReader(new StringReader(((Object)text).toString()));
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                line = line.replaceAll("[\t]", "   ");
                lines.addAll(MessageBox.wrapLine(line));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return lines;
    }

    private static String boxTitle(List lines, int width) {
        return MessageBox.boxText(lines, width, false);
    }

    private static String boxText(List lines, int width) {
        return MessageBox.boxText(lines, width, true);
    }

    private static String boxText(List lines, int width, boolean withBottom) {
        String hline = MessageBox.getHR(width + 2);
        StringBuffer sb = new StringBuffer();
        sb.append(hline);
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            String line = (String)it.next();
            sb.append("| ");
            sb.append(line);
            for (int i = line.length(); i < width; ++i) {
                sb.append(" ");
            }
            sb.append(" |").append(LS);
        }
        if (withBottom) {
            sb.append(hline);
        }
        return sb.toString();
    }

    private static String getHR(int width) {
        StringBuffer sb = new StringBuffer();
        sb.append("+");
        for (int i = 0; i < width; ++i) {
            sb.append("-");
        }
        sb.append("+");
        sb.append(LS);
        return sb.toString();
    }

    public static void main(String[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("1) jdbc.oracle.whatever:@hoser").append(LS);
        sb.append("\tcom.oracle.jdbc.Driver").append(LS);
        sb.append("x) Cancel");
        sb.append("Character boundary analysis allows users to interact with characters as they expect to, for example, when moving the cursor around through a text string. Character boundary analysis provides correct navigation of through character strings, regardless of how the character is stored. For example, an accented character might be stored as a base character and a diacritical mark. What users consider to be a character can differ between languages.");
        System.out.println(MessageBox.box("Select a database:", sb.toString()));
        sb = new StringBuffer();
        sb.append("-> Error: Something unusual has occured to cause the driver to fail. Please report this exception: Exception: java.sql.SQLException: FATAL:  user 'Bulldog' does not exist\n");
        sb.append("\n");
        sb.append("Stack Trace:\n");
        sb.append("\n");
        sb.append("java.sql.SQLException: FATAL:  user 'bulldog' does not exist\n");
        sb.append("at org.postgresql.Connection.openConnection(Connection.java:241)\n");
        sb.append("at org.postgresql.Driver.connect(Driver.java:122)\n");
        sb.append("at org.apache.commons.dbcp.DriverConnectionFactory.createConnection(ctionFactory.java:37)\n");
        sb.append("at org.apache.commons.dbcp.PoolableConnectionFactory.makeObject(PoolableConnectionFactory.java 90)\n");
        sb.append("at org.apache.commons.pool.impl.GenericObjectPool.borrowObject(GenericObjectPool.java 771)\n");
        sb.append("at org.apache.commons.dbcp.PoolingDataSource.getConnection(PoolingDataSource.java 5)\n");
        sb.append("at ise.dbconsole.DbConsoleDAO.getConnection(DbConsoleDAO.java:829)\n");
        sb.append("at ise.dbconsole.DbConsoleDAO.getDbInfo(DbConsoleDAO.java:152)\n");
        sb.append("at ise.dbconsole.command.DbInfoCommand.execute(DbInfoCommand.java:49\n");
        sb.append("at ise.dbconsole.command.DbInfoCommand.execute(DbInfoCommand.java:41\n");
        sb.append("at ise.dbconsole.command.SetupDAOCommand2.createDAO(SetupDAOCommand2.java:163)\n");
        sb.append("at ise.dbconsole.command.SetupDAOCommand2.setupDAO(SetupDAOCommand2.javaa:145)\n");
        sb.append("at ise.dbconsole.command.SetupDAOCommand2.execute(SetupDAOCommand2.java:69)\n");
        sb.append("at ise.dbconsole.command.SetupDAOCommand2.execute(SetupDAOCommand2.java:56)\n");
        sb.append("at ise.dbconsole.DbConsole.executeCommand(DbConsole.java:521)\n");
        sb.append("at ise.dbconsole.DbConsole$1.run(DbConsole.java:158)\n");
        sb.append("End of Stack Trace\n");
        System.out.println(MessageBox.box("Here's an exception:", sb.toString()));
    }
}

