/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks.util.math;

import ise.antelope.tasks.util.math.Math;
import ise.antelope.tasks.util.math.Num;
import java.util.Enumeration;
import java.util.Vector;

public class Op {
    private String datatype = null;
    Vector nums = new Vector();
    Vector ops = new Vector();
    String operation = null;
    private boolean _strict = false;

    public Op() {
    }

    public Op(String op) {
        this.setOp(op);
    }

    public Op(String op, String type) {
        this.setOp(op);
        this.setDatatype(type);
    }

    public void setOp(String op) {
        this.operation = op.equals("+") ? "add" : (op.equals("-") ? "subtract" : (op.equals("*") || op.equals("x") ? "multiply" : (op.equals("/") || op.equals("\ufffd") ? "divide" : (op.equals("%") || op.equals("\\") ? "mod" : op))));
    }

    public void addConfiguredNum(Num num) {
        this.nums.addElement(num);
    }

    public void setDatatype(String p) {
        if (!(p.equals("int") || p.equals("long") || p.equals("float") || p.equals("double") || p.equals("bigint") || p.equals("bigdecimal"))) {
            throw new IllegalArgumentException("Invalid datatype: " + p + ". Must be one of int, long, float, double, bigint, or bigdouble.");
        }
        this.datatype = p;
    }

    public void addConfiguredOp(Op op) {
        if (this.datatype != null) {
            op.setDatatype(this.datatype);
        }
        this.addConfiguredNum(op.calculate());
    }

    public void setStrict(boolean b) {
        this._strict = b;
    }

    public Num calculate() {
        if (this.operation == null) {
            throw new RuntimeException("Operation not specified.");
        }
        String[] operands = new String[this.nums.size()];
        Enumeration en = this.nums.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            Num num = (Num)en.nextElement();
            if (this.datatype != null) {
                num.setDatatype(this.datatype);
            }
            operands[i++] = num.toString();
        }
        Math math = new Math(this._strict);
        Number number = null;
        number = math.calculate(this.operation, this.datatype, operands);
        if (number == null) {
            throw new ArithmeticException("math error");
        }
        Num num = new Num();
        num.setValue(number.toString());
        num.setDatatype(this.datatype);
        return num;
    }
}

