/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util;

import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.impl.RepParams;
import java.io.File;
import java.util.StringTokenizer;

public class DbRepPreUpgrade_4_1 {
    private File envHome;
    private String groupName;
    private String nodeName;
    private String nodeHostPort;
    private String helperHosts;
    private static final String usageString = "usage: java -cp je.jar com.sleepycat.je.rep.util.DbRepPreUpgrade_4_1\n -h <dir>                   # environment home directory\n -groupName <group name>    # replication group name\n -nodeName <node name>      # replicated node name\n -nodeHostPort <host:port>  # host name or IP address and port\n                              number to use for this node\n -helperHosts <host:port>   # identifier for one or more members\n                              of the replication group which can\n                              be contacted for group information,\n                              in this format:\n                              hostname[:port][,hostname[:port]]\n";

    public static void main(String[] args) {
        DbRepPreUpgrade_4_1 upgrader = new DbRepPreUpgrade_4_1();
        upgrader.parseArgs(args);
        try {
            upgrader.preUpgrade();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(usageString);
        System.exit(-1);
    }

    private void parseArgs(String[] args) {
        int argc = 0;
        int nArgs = args.length;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = args[argc++].trim()).equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(args[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-groupName")) {
                if (argc < nArgs) {
                    this.groupName = args[argc++];
                    continue;
                }
                this.printUsage("-groupName requires an argument");
                continue;
            }
            if (thisArg.equals("-nodeName")) {
                if (argc < nArgs) {
                    this.nodeName = args[argc++];
                    continue;
                }
                this.printUsage("-nodeName requires an argument");
                continue;
            }
            if (thisArg.equals("-nodeHostPort")) {
                if (argc < nArgs) {
                    this.nodeHostPort = args[argc++];
                    try {
                        RepParams.NODE_HOST_PORT.validateValue(this.nodeHostPort);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        this.printUsage("-nodeHostPort is illegal");
                    }
                    continue;
                }
                this.printUsage("-nodeHostPort requires an argument");
                continue;
            }
            if (thisArg.equals("-helperHosts")) {
                if (argc < nArgs) {
                    this.helperHosts = args[argc++];
                    StringTokenizer st = new StringTokenizer(this.helperHosts, ",");
                    while (st.hasMoreElements()) {
                        try {
                            RepParams.NODE_HOST_PORT.validateValue(st.nextToken());
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                            this.printUsage("-helperHosts has an invalid host:port pair in the argumen");
                        }
                    }
                    continue;
                }
                this.printUsage("-helperHosts requires an argument");
                continue;
            }
            this.printUsage("Invalid argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
        if (this.groupName == null) {
            this.printUsage("-groupName is a required argument");
        }
        if (this.nodeName == null) {
            this.printUsage("-nodeName is a required argument");
        }
        if (this.nodeHostPort == null) {
            this.printUsage("-nodeHostPort is a required argument");
        }
        if (this.helperHosts == null) {
            this.printUsage("-helperHosts is a required argument");
        }
    }

    private DbRepPreUpgrade_4_1() {
    }

    public DbRepPreUpgrade_4_1(File envHome, String groupName, String nodeName, String nodeHostPort, String helperHosts) {
        this.envHome = envHome;
        this.groupName = groupName;
        this.nodeName = nodeName;
        this.nodeHostPort = nodeHostPort;
        this.helperHosts = helperHosts;
    }

    public void preUpgrade() {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        ReplicationConfig repConfig = new ReplicationConfig(this.groupName, this.nodeName, this.nodeHostPort);
        repConfig.setHelperHosts(this.helperHosts);
        repConfig.setConfigParam(RepParams.DONT_JOIN_REP_GROUP.getName(), "true");
        ReplicatedEnvironment repEnv = new ReplicatedEnvironment(this.envHome, repConfig, envConfig);
        repEnv.sync();
        repEnv.close();
    }
}

