###########################################################################
#
# win32 makefile -- getgw
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999-2008  The New Zealand Digital Library Project
#
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

COMMON_DIR = ..\..

COMMON_PACKAGES_DIR = $(COMMON_DIR)\packages


GSDL_VC4 = 0
LOCAL_LIBRARY = 0
DEBUG = 0
DLL = 0
DLLDEBUG = 0

!IF $(DEBUG)
CXXFLAGS = -DEBUG -Z7 /errorReport:prompt
LDFLAGS = -DEBUG -Z7 /errorReport:prompt
!ELSE
CXXFLAGS =
LDFLAGS =
!ENDIF

!IF $(GSDL_VC4)
CXXFLAGS = $(CXXFLAGS) -GX
!ELSE
CXXFLAGS = $(CXXFLAGS) -EHsc
!ENDIF

!IF $(DLL)
CXXFLAGS = $(CXXFLAGS) -MD
!ELSE
!IF ($(DLLDEBUG))
CXXFLAGS = $(CXXFLAGS) -MDd
!ENDIF
!ENDIF

CC = cl
DEFS = -D__WIN32__ -DHAVE_CONFIG_H -DPARADOCNUM -D_LITTLE_ENDIAN -DSHORT_SUFFIX -D_CRT_SECURE_NO_DEPRECATE
INCLUDES = -I"$(COMMON_DIR)" -I"$(COMMON_DIR)\src\lib" -I"$(COMMON_DIR)\packages\windows\crypt\crypt"
LIBS = "$(COMMON_DIR)\src\lib\gsdllib.lib" "$(COMMON_DIR)\packages\windows\crypt\crypt\crypt.lib"


!IF $(GSDL_VC4)
DEFS = $(DEFS) -DGSDL_NAMESPACE_BROKEN -DGSDL_USE_IOS_H -D__STL_NO_NEW_IOSTREAMS
INCLUDES = $(INCLUDES) -I"$(COMMON_PACKAGES_DIR)\windows\stlport\stlport"
!ENDIF

!IF $(LOCAL_LIBRARY)
DEFS = $(DEFS) -DGSDL_LOCAL_LIBRARY
!ENDIF


COMPILE = $(CC) -nologo -c $(CXXFLAGS) $(DEFS) $(INCLUDES)
LINK = $(CC) -nologo $(LDFLAGS)

.SUFFIXES:
.SUFFIXES: .cpp .obj
.cpp.obj:
	$(COMPILE) $< 


SOURCES = getpw.cpp
OBJECTS = getpw.obj
EXEC    = getpw.exe

all: $(EXEC)

install:
	copy $(EXEC) "$(GSDLHOME)\bin\windows"

clean:
	del *.obj
	del $(EXEC)

getpw.exe: $(OBJECTS)
	$(LINK) $(OBJECTS) $(LIBS) 




