/**************************************************************************
 *
 * IndexData.h -- Information needed for querying
 * Copyright (C) 1999 Rodger McNab
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef INDEXDATA_H
#define INDEXDATA_H

#include <stdio.h>
#include "invf.h"
#include "FIvfLevelInfo.h"
#include "FragLevelConvert.h"
#include "Weights.h"
#include "stemmer.h" 

class IndexData {
public:
  // general information
  char basePath[FILENAME_MAX];
  char filename[FILENAME_MAX];
  FIvfLevel levels;
  
  // blocked dictionary
  FILE *dictFile;
  block_dict_header bdh;
  block_idx biWords;
  block_idx biTags;

  /* [JFG - Mar 06: Accent folding patch] */
  // stem indexes
  FILE *stemFile[STEM_MAX]; 
  stem_idx_header sih[STEM_MAX];
  block_idx sii[STEM_MAX];
 
  // inverted file
  FILE *invfFile;
  invf_file_header ifh;

  // weights
  FILE *approxWeightsFile;
  FILE *exactWeightsFile;

  // level specific information
  UCArray curLevel; // last level that was loaded
  mg_u_long curLevelNum;
  FragLevelConvert levelConverter;
  ApproxWeightsData weightData;
  
  IndexData ();
  ~IndexData ();

  // LoadData will only load the data if it has not been loaded before
  bool LoadData (const char *_basePath, const char *_filename);
  bool UnloadData ();

  bool LoadLevel (const UCArray &level);
  bool UnloadLevel ();
};


#endif
