/**********************************************************************
 *
 * CacheMan.h
 * Copyright (C) 2003  UNESCO
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef __CACHEMAN_H__
#define __CACHEMAN_H__


#include "File.h"

class CacheManager
{
private:
	
	CFileBase*	       theFile_;
	unsigned		   maxblocks_;  // Max # blocks in buff_er
	unsigned		   nused_;	    // Number being used.
	unsigned		   blocksize_;  // Size of a block
	FileSystem::FAU_t* diskAddrs_;  // Its disk address
	unsigned*		   useCounts_;  // Use count for the block
	char*			   buff_;	    // The set of blocks.
	
public:
	
	CacheManager();
	CacheManager(unsigned blocksz, unsigned mxblks);

	~CacheManager();
	
	void        Create(unsigned blocksz, unsigned mxblks = 10);
	void        Erase();
	
	void        Connect(CFileBase* file);
	void        Disconnect();
	bool  		Flush();	        // Perform any pending writes.
	void		Invalidate();	    // Invalidate the entire cache
	bool  		Read (FileSystem::FAU_t locn, void* dat);
	bool  		Write(FileSystem::FAU_t locn, void* dat);
	
private:
	
	CacheManager(const CacheManager&);          // Private to insure no copies
	void		operator=(const CacheManager&); // Ditto
	size_t		AgeAndFindSlot(FileSystem::FAU_t);
	bool  		Flush(unsigned);
	size_t		GetFreeSlot();
	size_t		LRU() const; // Find least recently used block
};

#endif
