package org.greenstone.gatherer.feedback;

import java.io.*;
import java.awt.image.*;
import javax.swing.*;
import java.awt.*;
import java.util.*;
import javax.swing.event.MouseInputAdapter;
import java.awt.event.*;
import javax.swing.border.*;
import java.util.Locale;
import java.util.ResourceBundle;
import java.text.MessageFormat;
import javax.swing.tree.*;

/**
 * This class can give preview of all the history of actions user did or give preview of all the
 * xml files that are ready to be send and it also can give preview of all the screen shot of
 * all window taken when user did the actions.
 * If user select Details button then they will view all xml files that are going to be send.
 * If user select View History then they will see the history record that we took so far.
 * @author Veronica Liesaputra
 */
public class ReportDetails extends WindowAdapter 
{
    /**
     * This is the tree that will be used to hold the feedback form,the history stored inside the vector 
     * at the moment, and hold the comment user did when they recreating the event.
     * This tree's data partly will be supplied from whats inside vector. 
     */
    private JTree tree;
    /**
     * This is the root node for tree.
     */
    private DefaultMutableTreeNode rootNode;
    /**
     * This hold the parent node of the current node that is currently just being added to tree.
     */
    private DefaultMutableTreeNode parentNode;
    /**
     * This hold the current node that is currently just being added to tree.
     */
    private DefaultMutableTreeNode currNode;
    /**
     * This is the tree model for tree.
     */
    private DefaultTreeModel treeModel;

    /**
     * This is the tree that will be used to hold the commands (actions) done by the user inside the vector
     * at the moment.This tree builds from partial data of tree and which data entered to this tree
     * is signed by the value of comm_bool and comm_start. 
     */
    private JTree tree2;
    /**
     * This is the root node for tree2.
     */
    private DefaultMutableTreeNode rootNode2;
    /**
     * This is the parent node of the current node that is currently just being added to tree2.
     */
    private DefaultMutableTreeNode parentNode2;
    /**
     * This is the current node that is currently just being added to tree2.
     */
    private DefaultMutableTreeNode currNode2;
    /**
     * This is the tree model for tree2.
     */
    private DefaultTreeModel treeModel2;

    /**
     * This is the tree that will be used to hold the history of all the actions
     * done by the user before they choose to do the Reporting Feedback sequence.
     */
    private JTree tree3;
    /**
     * This is the root node for tree3.
     */
    private DefaultMutableTreeNode rootNode3;
    /**
     * This is the parent node for the current node that is currently just being added to tree3.
     */
    private DefaultMutableTreeNode parentNode3;
    /**
     * This is the current node that is currently just being added to tree3.
     */
    private DefaultMutableTreeNode currNode3;
    /**
     * This is the tree model for tree3.
     */
    private DefaultTreeModel treeModel3;

    /**
     * This is the tree that will be used to hold the commands (actions) done by the user 
     * before they choose to do the Reporting Feedback sequence.This tree builds from partial data of tree3 
     * and which data entered to this tree2 is signed by the value of comm_bool and comm_start. 
     */
    private JTree tree4;
    /**
     * This is the root node for tree4.
     */
    private DefaultMutableTreeNode rootNode4;
    /**
     * This is the parent node for the current node that is currently just being added to tree4.
     */
    private DefaultMutableTreeNode parentNode4;
    /**
     * This is the current node that is currently just being added to tree4.
     */
    private DefaultMutableTreeNode currNode4;
    /**
     * This is the tree model for tree4.
     */
    private DefaultTreeModel treeModel4;

    /**
     * This is the panel to display tree4.
     */
    private JPanel pane4;
    /**
     * This is the scroll pane for displaying tree3, so it is scrollable.
     */
    private JScrollPane scroll3;
    /**
     * This is the scroll pane for displaying tree4, so it is scrollable.
     */
    private JScrollPane scroll4;

    /**
     * This is the panel to display tree2.
     */
    private JPanel pane2;
    /**
     * This is the scroll pane for displaying tree2, so it is scrollable.
     */
    private JScrollPane scroll2;
    /**
     * This is the scroll pane for displaying tree, so it is scrollable.
     */
    private JScrollPane scroll;
   
    /**
     * This is all the information taken from the Feedback form and information that
     * was taken from the system.
     */
    private String[] err_details;
    
    /**
     * This is the vector that hold all information about the history of all
     * the actions user did.
     * If rec = true, it means it hold the history of all the actions and information
     * of all the windows were open when user did the actions during reporting feedback
     * sequence.
     * If rec = false, it means it hold the history of all the actions and information
     * of all the windows were open when user did the actions before and after
     * reporting feedback sequence.
     */
    private Vector vector;
    
    /**
     * This is a variable to know which tag xml data that wants to be added to the JTree. 
     */
    private int count;
    
    /**
     * This is a flag variable to sign whether or not the next data is to be added to
     * the command JTree. 
     */
    private boolean comm_bool = false;
    /**
     * This is a flag variable to sign whether or not the next history is to be added to
     * the command JTree.
     */
    private boolean comm_start = false;
    /**
     * This is a flag variable to sign whether or not at the moment we building a new tree
     * or build from the existing tree.
     */
    private boolean new_tree = false;
    
    /**
     * This is a flag variable to sign which type of preview that user wants at the moment.
     * If its true, then its means user will view all the 6 xml files that will be send.
     * If its false, then its means user only wants to view the history and command user just did
     * before and after the reporting feedback sequence.
     */
    private boolean rec = false;
   
    /**
     * This is array list of all the image icons that are inside all the command JTree.
     */
    private ArrayList movie;

    /**
     * This variable will hold the resource of the words that is stored in Messages.properties file.
     * The calling using messages.getString(someString) will caused someString to be translated
     * into some other string that is hold in that file.usually it will caused it to be translated
     * to the language that the user use or choose to have as stated in Locale.
     */
    private static ResourceBundle messages;

    private String[] img;
   
    /**
     * This constructor will be seeting up the data member to its appropriate value.
     * (Precondition : (msg != null) && (bool != null))
     * @param stack this is all vector to be supplied to tree.
     * @param err_array holding all the information taken when user doing the FeedbackInterface form.
     * @param imgFile holding all the information inside all the panels in the FeedbackInterface form.
     * @param msg hold the resource of the words that is stored in Messages.properties file.
     * @param bool hold the falg value of rec.
     */
    public ReportDetails(Vector stack,String[] err_array,String[] imgFile,ResourceBundle msg,boolean bool)
    {
	img = imgFile;
	vector = stack;
	err_details = err_array;
	messages = msg;
	rec = bool;
	movie = new ArrayList();
	makeNewWindow();
    }

    /**
     * This method will make a modal-dialog window that will display all the preview.
     */
    public void makeNewWindow()
    {
	JDialog frame;
	frame = new View (this);
	frame.setModal(true);
	frame.setVisible(true);
    }

    /**
     * This class is the dialog window that will give the preview.
     */
    class View extends JDialog implements ActionListener
    {
	/**
	 * This variable is holding the current window that display the preview.
	 */
	private JDialog frame;
	/**
	 * This variable holding the owner of this window.
	 */
	private ReportDetails framework = null;

	/**
	 * This constructor will make the dialog window for previewing and setting up the
	 * content pane of this window.
	 * @param controller is the owner of this window.
	 */
	public View (ReportDetails controller)
	{
	    super();
	    framework = controller;
	    frame = this;

	    setTitle(messages.getString("ViewReport"));  
	    setBackground(new Color(176,208,176));
	    setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
	    setDefaultLookAndFeelDecorated(true);
	 
	    JPanel cont;
	    cont = new JPanel();
	    cont.setLayout(new BoxLayout(cont,BoxLayout.PAGE_AXIS));
	    cont.setBackground(new Color(176,208,176));
	
	    JTabbedPane tab;
	    tab = new JTabbedPane();
	    tab.setBackground(new Color(176,208,176));

	    new_tree = false;

	    if (err_details != null)
		{
		    tab.addTab(messages.getString("ViewFeedbackForm"), 
			       createFeedback_UI(err_details,img));
		}
	    
	    if (rec == true)
		{
		    tab.addTab(messages.getString("ViewFeedbackHistoryState"),
			       createFeedbackHistory_UI(vector));
		    tab.addTab(messages.getString("ViewFeedbackCommandState"),pane2);
		    /*tab.addTab(messages.getString("ViewHistoryState"),
		      createHistory_UI());*/
		    createHistory_UI();
		    tab.addTab(messages.getString("ViewCommandState"),pane4);
		}
	    else
		{
		    /*tab.addTab(messages.getString("ViewHistoryState"),
		      createFeedbackHistory_UI(vector));*/
		    createFeedbackHistory_UI(vector);
		    tab.addTab(messages.getString("ViewCommandState"),pane2);
		}

	    cont.add(tab);

	    JLabel lbl;
	    lbl = new JLabel("   ");
	    lbl.setBackground(new Color(176,208,176));

	    cont.add(lbl);

	    JPanel pane3;
	    pane3 = new JPanel();
	    pane3.setBackground(new Color(176,208,176));
	    JButton button;
	    button = new JButton(messages.getString("Close"));
	    button.setActionCommand(messages.getString("Close"));
	    button.addActionListener(this);
	    button.setDefaultCapable(true);
	    button.setToolTipText(messages.getString("ClosePreview"));
	    button.setBackground(new Color(176,208,176));
	   
	    /*JButton button2;
	    button2 = new JButton(messages.getString("ViewMovie"));
	    button2.setActionCommand(messages.getString("ViewMovie"));
	    button2.addActionListener(new ActionListener()
		{
		    public void actionPerformed (ActionEvent e)
		    {
			JDialog.setDefaultLookAndFeelDecorated(true);
			JDialog frame;
			frame = new Movie(messages,movie);

			frame.setContentPane(((Movie)frame).create_UI());
			frame.pack();
			frame.setVisible(true);
		    }
		});
	    button2.setToolTipText(messages.getString("ViewMovieText"));
	    button2.setBackground(new Color(176,208,176));
	    pane3.add(button2);*/
	    pane3.add(button);
	    pane3.setBorder(new EmptyBorder(new Insets(0,10,10,10)));

	    cont.add(pane3);

	    cont.setBorder(new EmptyBorder(new Insets(5,5,5,5)));
	    getContentPane().add(cont);

	    tab.setAlignmentX(Component.LEFT_ALIGNMENT);
	    lbl.setAlignmentX(Component.LEFT_ALIGNMENT);
	    pane3.setAlignmentX(Component.LEFT_ALIGNMENT);
	    
	    addWindowListener(framework);
	    Toolkit kit;
	    kit = Toolkit.getDefaultToolkit();
	    Dimension screenSize;
	    screenSize = kit.getScreenSize();
	    int screenHeight;
	    screenHeight = screenSize.height;
	    int screenWidth;
	    screenWidth = screenSize.width;
	    Dimension size;
	    size = this.getSize();
	    setLocation((screenWidth -size.width)/ 4, 
			(screenHeight - size.height)/ 4);

	    pack();
	    setResizable(false);
	}
	
	/**
	 * This method will get the vector that is stored inside temp_feedbackhist.log
	 * if rec is true, and will get the vector that is stored inside temp_history.log
	 * if rec is false. If file is not exist then it will return null. 
	 * @return vector that is stored in the file.
	 */
	public Vector getPrev_log()
	{
	    Vector stack = null;
	    try
		{
		    File f;
		    if (rec == true)
			{
			    f = new File("temp_feedbackhist.log");
			}
		    else
			{
			    f = new File("temp_history.log");
			}

		    if (f.exists() == true)
		    {
			FileInputStream fis = new FileInputStream(f);
			ObjectInputStream ois = new ObjectInputStream(fis);
			stack = (Vector) ois.readObject();
			ois.close();
			return stack;
		    }
		    else
			stack = null; 
		}
	    catch (IOException exp) {exp.printStackTrace();}
	    catch (ClassNotFoundException exp2) 
		{
		    System.out.println("class exp");}
	    
	    return stack;
	}

	/**
	 * This method will update the graphics of this window and it will
	 * set variable finish in Conformation to true.
	 * @param g is the graphics for this window.
	 */
	public void paint (Graphics g)
	{
	    super.paint(g); 
	    FeedbackInterface.setFinish(true);
	}

	/**
	 * This method will close the preview window if user select close button.
	 * @param e action event user did.
	 */
	public void actionPerformed (ActionEvent e)
	{   
	    if(messages.getString("Close").equals(e.getActionCommand()))
		{ 
		    dispose();
		}
	}

	/**
	 * This method will add a record to history tree and the command tree.
	 * @param log is the record to be added.
	 */
	public void getHist(History log)
	{
	    comm_bool = true;
	    startContent(10);

	    startContent(7);
	    saveContent(log.getDate());
	    closeContent(7);
	    
	    startContent(2);
	    saveContent(log.getTitle());
	    closeContent(2);
	    
	    startContent(8);
	    saveContent(log.getCommand());
	    closeContent(8);
	  
	    String image;
	    image = log.getImage();

	    if (image != null)
		{
		    byte[] img;
		    img = Base64.decode(image);
		    
		    String width,height;
		    width = log.getWidth();
		    height = log.getHeight();
		    
		    int w,h;
		    w = Integer.parseInt(width);
		    h = Integer.parseInt(height);

		    ImageIcon icon,small_icon;
		    small_icon = new ImageIcon(img);
		    icon = new ImageIcon
			(small_icon.getImage().getScaledInstance(w,h,Image.SCALE_SMOOTH));

		    movie.add(0,icon);

		    startContent(6);
		    saveImage(log.getImageName(),width,height);
		    closeContent(6);
		}
	    comm_bool = false;
	    
	    ArrayList component;
	    component = log.getArray();
	    int j;
	    for (j = 0 ; j < component.size() ; j++)
		{
		    startContent(9);
		    CompGroup comp;
		    comp = (CompGroup) component.get(j);
		    
		    startContent(8);
		    saveContent(comp.getStatus());
		    closeContent(8);
		    
		    startContent(0);
		    UserComponent cmp;
		    cmp = comp.getComponent();
		    showReport(cmp);
		    closeContent(0);
		    
		    closeContent(9);
		}
	    
	    comm_bool = true;
	    closeContent(10);
	    comm_bool = false;
	}
    
	/**
	 * This method will make the tree that contains the history and the commands of all the actions and window 
	 * open when user did the action that stored in vector.
	 * @param vector the vector that contains the information need to be display in tree.
	 * @return       the panel that display tree and tree2.
	 */
	public JPanel createFeedbackHistory_UI(Vector vector)
	{
	    scroll = null;
	    int k;

	    tree = null;
	    rootNode = null;
	    currNode = null;
	    parentNode =  null; 
	    treeModel = null;

	    tree2 = null;
	    rootNode2 = null;
	    currNode2 = null;
	    parentNode2 =  null; 
	    treeModel2 = null;
	    
	    comm_bool = true;
	    comm_start = true;
	    new_tree = false;

	    startElement(messages.getString("HISTORY"));
 
	    for (k = 0 ; k < vector.size() ; k++)
		{
		    History log;
		    log = (History) vector.get(k);
		    getHist(log);
		}

	    Vector stack;
	    stack = getPrev_log();
	    if (stack != null)
		{
		    for (k = 0 ; k < stack.size() ; k++)
			{
			    History log;
			    log = (History) stack.get(k);
			    getHist(log);
			}
		    stack.removeAllElements();
		    System.gc();
		    stack = null;
		}

	    comm_bool = true;
	    endElement(messages.getString("HISTORY"));
	    comm_bool = false;
	    
	    comm_start = false;
	
	    pane2 = new JPanel();
	    pane2.add(scroll2);
	    pane2.setBackground(new Color(176,208,176));
	    pane2.setBorder(new EmptyBorder(new Insets(10,10,10,10)));

	    JPanel pane;
	    pane = new JPanel();
	    pane.add(scroll);
	    pane.setBackground(new Color(176,208,176));
	    pane.setBorder(new EmptyBorder(new Insets(10,10,10,10)));
	    
	    return pane;
	}

	/**
	 * This method will make the tree that contains the history and the commands of all the actions and window 
	 * open when user did the action before user choose the reporting feedback sequence.
	 * @return the panel contains the preview of this history and commands before user choose to start
	 *         the reporting feedback sequence.
	 */
	public JPanel createHistory_UI()
	{
	    scroll3 = null;
	    int k;

	    tree3 = null;
	    rootNode3 = null;
	    currNode3 = null;
	    parentNode3 =  null; 
	    treeModel3 = null;

	    tree4 = null;
	    rootNode4 = null;
	    currNode4 = null;
	    parentNode4 =  null; 
	    treeModel4 = null;
	    
	    comm_bool = true;
	    comm_start = true;
	    new_tree = true;

	    startElement(messages.getString("HISTORY"));
 
	    try
		{
		    File f = new File("history.log");
		    FileInputStream fis = new FileInputStream(f);
		    ObjectInputStream ois = new ObjectInputStream(fis);
		    
		    Vector stack;
		    stack = (Vector) ois.readObject();

		    if (stack != null)
			{
			    for (k = 0 ; k < stack.size() ; k++)
				{
				    History log;
				    log = (History) stack.get(k);
				    getHist(log);
				}
			    stack.removeAllElements();
			    System.gc();
			    stack = null;
			}
		    
		    stack = (Vector) ois.readObject();
		    
		    if (stack != null)
			{
			    for (k = 0 ; k < stack.size() ; k++)
				{
				    History log;
				    log = (History) stack.get(k);
				    getHist(log);
				}
			    stack.removeAllElements();
			    System.gc();
			    stack = null;
			}
		
		    ois.close();
		}
	    catch (IOException exp) {exp.printStackTrace();}
	    catch (ClassNotFoundException exp2) 
		{
		    System.out.println("class exp");}
	    
	    comm_bool = true;
	    endElement(messages.getString("HISTORY"));
	    comm_bool = false;
	    
	    comm_start = false;
	
	    pane4 = new JPanel();
	    pane4.add(scroll4);
	    pane4.setBackground(new Color(176,208,176));
	    pane4.setBorder(new EmptyBorder(new Insets(10,10,10,10)));

	    JPanel pane;
	    pane = new JPanel();
	    pane.add(scroll3);
	    pane.setBackground(new Color(176,208,176));
	    pane.setBorder(new EmptyBorder(new Insets(10,10,10,10)));
	    
	    return pane;
	}

	/**
	 * This method display all the information taken when user did the Feedback form.
	 * @param err_details is the information taken when user did the Feedback form.
	 * @param img         is the information from all the panels inside the Feedback form.
	 * @return            panel displaying the information.
	 */
	public JPanel createFeedback_UI(String[] err_details,String[] img)
	{
	    scroll = null;
	 
	    tree = null;
	    rootNode = null;
	    currNode = null;
	    parentNode =  null; 
	    treeModel = null;

	    tree2 = null;
	    rootNode2 = null;
	    currNode2 = null;
	    parentNode2 =  null; 
	    treeModel2 = null;

	    startElement(messages.getString("BUGS"));
	    
	    startElement(messages.getString("IDCode"));
	    characters(err_details[0].toCharArray(),0,err_details[0].length());
	    endElement(messages.getString("IDCode"));
	
	    startElement(messages.getString("LastViewedWindow"));
	    characters(err_details[1].toCharArray(),0,err_details[1].length());
	    endElement(messages.getString("LastViewedWindow"));
	    
	    startElement(messages.getString("Optionals"));
	   
	    startElement(messages.getString("Type"));
	    characters(err_details[3].toCharArray(),0,err_details[3].length());
	    endElement(messages.getString("Type"));
		
	    startElement(messages.getString("Urgency"));
	    characters(err_details[4].toCharArray(),0,err_details[4].length());
	    endElement(messages.getString("Urgency"));
	    
	    endElement(messages.getString("Optionals"));
	
	    startElement(messages.getString("User"));
	    
	    startElement(messages.getString("Name"));
	    characters(err_details[5].toCharArray(),0,err_details[5].length());
	    endElement(messages.getString("Name"));
	    
	    startElement(messages.getString("HomeDirectory"));
	    characters(err_details[6].toCharArray(),0,err_details[6].length());
	    endElement(messages.getString("HomeDirectory"));
	    
	    startElement(messages.getString("WorkingDirectory"));
	    characters(err_details[7].toCharArray(),0,err_details[7].length());
	    endElement(messages.getString("WorkingDirectory"));
	    
	    startElement(messages.getString("SMTP"));
	    characters(err_details[19].toCharArray(),0,err_details[19].length());
	    endElement(messages.getString("SMTP"));
	    
	    startElement(messages.getString("Email"));
	    characters(err_details[20].toCharArray(),0,err_details[20].length());
	    endElement(messages.getString("Email"));

	    endElement(messages.getString("User"));
	    
	    startElement(messages.getString("OpenFormTime"));
	    characters(err_details[8].toCharArray(),0,err_details[8].length());
	    endElement(messages.getString("OpenFormTime"));

	    startElement(messages.getString("SendFormTime"));
	    characters(err_details[9].toCharArray(),0,err_details[9].length());
	    endElement(messages.getString("SendFormTime"));
	    
	    startElement(messages.getString("OperatingSystem"));
	    characters(err_details[10].toCharArray(),0,err_details[10].length());
	    endElement(messages.getString("OperatingSystem"));

	    startElement(messages.getString("Java"));
	    
	    startElement(messages.getString("JavaInformation"));
	    characters(err_details[11].toCharArray(),0,err_details[11].length());
	    endElement(messages.getString("JavaInformation"));
	    
	    startElement(messages.getString("TotalMemory"));
	    characters(err_details[21].toCharArray(),0,err_details[21].length());
	    endElement(messages.getString("TotalMemory"));

	    startElement(messages.getString("MaxMemory"));
	    characters(err_details[22].toCharArray(),0,err_details[22].length());
	    endElement(messages.getString("MaxMemory"));

	    startElement(messages.getString("FreeMemory"));
	    characters(err_details[23].toCharArray(),0,err_details[23].length());
	    endElement(messages.getString("FreeMemory"));

	    startElement(messages.getString("DefaultLocale"));
	    characters(err_details[12].toCharArray(),0,err_details[12].length());
	    endElement(messages.getString("DefaultLocale"));
	

	    endElement(messages.getString("Java"));
	    
	    startElement(messages.getString("Browser"));
	    characters(err_details[13].toCharArray(),0,err_details[13].length());
	    endElement(messages.getString("Browser"));
	
	    startElement(messages.getString("LocalHostName"));
	    characters(err_details[14].toCharArray(),0,err_details[14].length());
	    endElement(messages.getString("LocalHostName"));
	
	    startElement(messages.getString("LocalHostAddress"));
	    characters(err_details[15].toCharArray(),0,err_details[15].length());
	    endElement(messages.getString("LocalHostAddress"));
	    
	    startElement(messages.getString("ScreenResolution"));
	    characters(err_details[16].toCharArray(),0,err_details[16].length());
	    endElement(messages.getString("ScreenResolution"));

	    if (img!=null)
		{
		    startElement("Sequences");
		    int i;
		    for ( i = 0 ; i < img.length ; i= i + 10)
			{
			    startElement("Sequence");
			    
			    startElement("Title");
			    characters(img[i].toCharArray(),0,img[i].length());
			    endElement("Title");
			    
			    startElement("Details");
			    characters(img[i+9].toCharArray(),0,img[i+9].length());
			    endElement("Details");
			    
			    startElement("ImageDescription");
			    
			    startElement("ScreenShot");
			    startElement("Image");
			    saveImage(img[i+2],img[i+7],img[i+8]);
			    endElement("Image");
			    endElement("ScreenShot");
			    
			    startElement("ErrorLineAndScreenShot");
			    startElement("Image");
			    saveImage(img[i+4],img[i+7],img[i+8]);
			    endElement("Image");
			    endElement("ErrorLineAndScreenShot");
			    
			    startElement("ErrorLineForScreenShot");
			    startElement("Image");
			    saveImage(img[i+6],img[i+7],img[i+8]); 
			    endElement("Image");
			    endElement("ErrorLineForScreenShot");
			  
			    endElement("ImageDescription");
			    
			    endElement("Sequence");
			}
		    endElement("Sequences");
		}

	    endElement(messages.getString("BUGS"));
	    
	    JPanel pane;
	    pane = new JPanel();
	    pane.add(scroll);
	    pane.setBackground(new Color(176,208,176));
	    pane.setBorder(new EmptyBorder(new Insets(10,10,10,10)));

	    return pane;
	}
	
	/**
	 * This will add the UserComponent to the tree.
	 * @param sx is the UserComponent to be added. 
	 */
	public void showReport (UserComponent sx)
	{
	    String type;
	    type = sx.getType();
	    String title;
	    title = sx.getTitle();
	    ArrayList content;
	    content = sx.getContent();
	    String selected;
	    selected = sx.getSelected();
	    String visible;
	    visible = sx.getVisible();
	    String image;
	    image = sx.getImage();
	    String img;
	    img = sx.getImageFileName();
	    String width;
	    width = sx.getWidth();
	    String height;
	    height = sx.getHeight();
	    String tooltip;
	    tooltip = sx.getToolTip();
	    
	    if (type != null)
		{
		    startContent(1);
		    saveContent(type);
		    closeContent(1);
		}
	    
	    if (title != null)
		{
		    startContent(2);
		    saveContent(title);
		    closeContent(2);
		}
	    
	    if (content != null)
		{
		    startContent(3);
		    int j;
		    for ( j = 0 ; j < content.size() ; j++)
			{
			    if (content.get(j) instanceof String)
				saveContent((String) content.get(j));
			    else if (content.get(j) instanceof UserComponent)
				{
				    startContent(0);
				    UserComponent cmp;
				    cmp = (UserComponent) content.get(j);
				    showReport(cmp);
				    closeContent(0);
				}
			}
		    closeContent(3);
		}
	    
	    if (selected != null)
		{
		    startContent(4);
		    saveContent(selected);
		    closeContent(4);
		}
	    
	    if (visible != null)
		{
		    startContent(5);
		    saveContent(visible);
		    closeContent(5);
		}
	
	    if (img != null)
		{
		    startContent(6);
		    saveImage(img,width,height);
		    closeContent(6);
		}
	    else
		{
		    if (image != null)
			{ 
			    startContent(11);
			    saveContent(image);
			    closeContent(11);
			} 
		}

	    if (tooltip != null)
		{
		    startContent(12);
		    saveContent(tooltip);
		    closeContent(12);
		}
	}
	
	/**
	 * This method will give what type of information this node hold according the number
	 * @param num the number that describe what type of information it hold.
	 */
	public void startContent (int num)
	{
	    switch(num)
		{
		case 0: startElement(messages.getString("COMPONENT"));
		    break;
		case 1: startElement(messages.getString("Type"));
		    break;
		case 2: startElement(messages.getString("Title"));
		    break;
		case 3: startElement(messages.getString("Content"));
		    break;
		case 4: startElement(messages.getString("Selected"));
		    break;
		case 5: startElement(messages.getString("Visible"));  
		    break;
		case 6: startElement(messages.getString("Image"));
		    break;
		case 7: startElement(messages.getString("Date"));
		    break;
		case 8: startElement(messages.getString("Command"));
		    break;
		case 9: startElement(messages.getString("COMPONENTS"));
		    break;
		case 10:startElement(messages.getString("LOG"));
		    break;
		case 11:startElement(messages.getString("Icon"));
		    break;
		case 12:startElement(messages.getString("ToolTipText"));
		    break;
		case 13:startElement(messages.getString("Comment"));
		    break;
		}
	}
	
	/**
	 * This will add the text content to the current node.
	 * @param text is the text content of the current node.
	 */
	public void saveContent (String text)
	{
	    if (text == null)
		text = "\t";
	    characters(text.toCharArray(),0,text.length());
	}
	
	/**
	 * This will say that what type of information that has been finished added
	 * accroding its number.
	 * @param num  the number that describe what type of information it hold.
	 */
	public void closeContent (int num)
	{
	    switch(num)
		{
		case 0: endElement(messages.getString("COMPONENT"));
		    break;
		case 1: endElement(messages.getString("Type"));
		    break;
		case 2: endElement(messages.getString("Title"));
		    break;
		case 3: endElement(messages.getString("Content"));
		    break;
		case 4: endElement(messages.getString("Selected"));
		    break;
		case 5: endElement(messages.getString("Visible"));
		    break;
		case 6: endElement(messages.getString("Image"));
		    break;
		case 7: endElement(messages.getString("Date"));
		    break;
		case 8: endElement(messages.getString("Command"));
		    break;
		case 9: endElement(messages.getString("COMPONENTS"));
		    break;
		case 10:endElement(messages.getString("LOG"));
		    break;
		case 11:endElement(messages.getString("Icon"));
		    break;
		case 12:endElement(messages.getString("ToolTipText"));
		    break;
		case 13:endElement(messages.getString("Comment"));
		    break;
		}
	}
	
	/**
	 * This method will add the this string to the appropriate place in the tree.
	 * @param type its the type to be added to the tree.
	 */
	public void startElement (String type)
	{
	   
	    if ((comm_bool == true)&&(comm_start == true))
		{
		    if (new_tree == true)
			{
			    if (type == messages.getString("HISTORY"))
				{
				    rootNode4 = new DefaultMutableTreeNode(messages.getString("HISTORYCOMMANDS"));
				    treeModel4 = new DefaultTreeModel(rootNode4);
				    
				    parentNode4 = rootNode4;
				    tree4 = new JTree(treeModel4);
				    tree4.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
				    tree4.setBackground(new Color(224,240,224));
				    tree4.setEditable(false);
				    tree4.setShowsRootHandles(true);
				}  
			    else
				{
				    currNode4 = new DefaultMutableTreeNode(type + " : ");
				    treeModel4.insertNodeInto(currNode4,parentNode4,parentNode4.getChildCount());
				    parentNode4 = currNode4;
				} 
			}
		    else
			{
			    if (type == messages.getString("HISTORY"))
				{
				    rootNode2 = new DefaultMutableTreeNode(messages.getString("HISTORYCOMMANDS"));
				    treeModel2 = new DefaultTreeModel(rootNode2);
				    
				    parentNode2 = rootNode2;
				    tree2 = new JTree(treeModel2);
				    tree2.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
				    tree2.setBackground(new Color(224,240,224));
				    tree2.setEditable(false);
				    tree2.setShowsRootHandles(true);
				}  
			    else
				{
				    currNode2 = new DefaultMutableTreeNode(type + " : ");
				    treeModel2.insertNodeInto(currNode2,parentNode2,parentNode2.getChildCount());
				    parentNode2 = currNode2;
				} 
			}
		}
		
	    if ((type == messages.getString("COMMENTS"))||(type == messages.getString("BUGS"))||
		(type == messages.getString("HISTORY")))
		{
		    if (new_tree == true)
			{
			    rootNode3 = new DefaultMutableTreeNode(type);
			    treeModel3 = new DefaultTreeModel(rootNode3);
			    
			    parentNode3 = rootNode3;
			    tree3 = new JTree(treeModel3);
			    tree3.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
			    
			    tree3.setBackground(new Color(224,240,224));
			    tree3.setEditable(false);
			    tree3.setShowsRootHandles(true);
			}
		    else
			{
			    rootNode = new DefaultMutableTreeNode(type);
			    treeModel = new DefaultTreeModel(rootNode);
			    
			    parentNode = rootNode;
			    tree = new JTree(treeModel);
			    tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
			    
			    tree.setBackground(new Color(224,240,224));
			    tree.setEditable(false);
			    tree.setShowsRootHandles(true);
			}
		}
	    else
		 {
		     if (new_tree == true)
			 {
			     currNode3 = new DefaultMutableTreeNode(type + " : ");
			     treeModel3.insertNodeInto(currNode3,parentNode3,parentNode3.getChildCount());
			     parentNode3 = currNode3;
			 }
		     else
			 {
			     currNode = new DefaultMutableTreeNode(type + " : ");
			     treeModel.insertNodeInto(currNode,parentNode,parentNode.getChildCount());
			     parentNode = currNode;
			 }
		 }
	}
	
	/**
	 * This method is to mark that we finished adding the type to the tree.
	 * @param type type that finished added to the tree.
	 */
	public void endElement (String type)
	{
	    if ((type == messages.getString("HISTORY"))||(type == messages.getString("BUGS"))||
		(type == messages.getString("COMMENTS")))
		{
		    if (new_tree == true)
			{
			    scroll3 = new JScrollPane(tree3);
			    scroll3.setPreferredSize(new Dimension(600,600));
			    if (comm_bool == true)
				{
				    scroll4 = new JScrollPane(tree4);
				    scroll4.setPreferredSize(new Dimension(600,600));
				}
			}
		    else
			{
			    scroll = new JScrollPane(tree);
			    scroll.setPreferredSize(new Dimension(600,600));
			    if (comm_bool == true)
				{
				    scroll2 = new JScrollPane(tree2);
				    scroll2.setPreferredSize(new Dimension(600,600));
				}
			}
		}
	    else
		{
		    if (new_tree == true)
			{
			    parentNode3 = (DefaultMutableTreeNode) parentNode3.getParent();
			    
			    if ((comm_bool == true)&&(comm_start == true))
				{
				    if (parentNode4 == null)  return;
				    parentNode4 = (DefaultMutableTreeNode) parentNode4.getParent();
				}  
			}
		    else
			{
			    parentNode = (DefaultMutableTreeNode) parentNode.getParent();
			    
			    if ((comm_bool == true)&&(comm_start == true))
				{
				    if (parentNode2 == null)  return;
				    parentNode2 = (DefaultMutableTreeNode) parentNode2.getParent();
				}  
			}
		}
	}
	
	/*public BufferedImage iconToImage(Icon icon, Component targetComponent) 
	{
	    int w = icon.getIconWidth();
	    int h = icon.getIconHeight();
	    GraphicsConfiguration gc = targetComponent.getGraphicsConfiguration();
	    BufferedImage image = gc.createCompatibleImage(w, h);
	    Graphics2D g = image.createGraphics();
	    icon.paintIcon(targetComponent,g,0,0);
	    g.dispose();
	    return image;
	}
	
	public BufferedImage savingImage (ImageIcon img)
	{
	    JFrame f = new JFrame();
	    f.setVisible(false);
	    BufferedImage image = iconToImage(img,f);
	    f.dispose();
	    return image;
	    }*/
	
	/**
	 * This will add the image filename,width and height to the tree.
	 * @param filename image's filename
	 * @param width    image's width
	 * @param height   image's height
	 */
	public void saveImage (String filename,String width,String height)
	{
	    startElement(messages.getString("Title"));
	    characters(filename.toCharArray(),0,filename.length());
	    endElement(messages.getString("Title"));
	
	    startElement(messages.getString("Size"));
	    
	    startElement(messages.getString("Width"));
	    characters(width.toCharArray(),0,width.length());
	    endElement(messages.getString("Width"));
	    
	    startElement(messages.getString("Height"));
	    characters(height.toCharArray(),0,height.length());
	    endElement(messages.getString("Height"));

	    endElement(messages.getString("Size"));

	    /*JFrame f = new JFrame();
	    f.setVisible(false);
	    BufferedImage image = savingImage(img);
	    BufferedImage bi = new BufferedImage(400, 400, BufferedImage.TYPE_INT_RGB);
	    Graphics2D big = bi.createGraphics();
	    big.drawImage(image.getScaledInstance(400,400,Image.SCALE_SMOOTH),0,0,f);
	    f.dispose();
	    
	
	    JLabel label = new JLabel(new ImageIcon(bi));
	    label.setPreferredSize(new Dimension(400,400));
	    currNode = new DefaultMutableTreeNode(label);
	    treeModel.insertNodeInto(currNode,parentNode,parentNode.getChildCount());*/
	}
	
	/**
	 * This method will add the characters to the current node's type.
	 * @param ch is the char[] that is need to be added to the current node's type.
	 * @param start is where we should start taking from ch.
	 * @param len is the length of charcacters we should take from ch
	 */
	public void characters (char[] ch, int start, int len)
	{
	    String text;
	    text = new String(ch,start,len);
	    String text1;
	    text1 = text.trim();
	    if (text1.length() > 0)
		{
		    if ((comm_bool == true)&&(comm_start == true))
			{
			    if (new_tree == true)
				{
				    String txt2;
				    txt2 = (String) currNode4.getUserObject();
				    currNode4.setUserObject(txt2 + text1);
				}
			    else 
				{
				    String txt2;
				    txt2 = (String) currNode2.getUserObject();
				    currNode2.setUserObject(txt2 + text1);
				}
			}

		    if (new_tree == true)
			{
			    String txt;
			    txt = (String) currNode3.getUserObject();
			    currNode3.setUserObject(txt + text1);
			}
		    else
			{
			    String txt;
			    txt = (String) currNode.getUserObject();
			    currNode.setUserObject(txt + text1);
			}
		}
	}
    }
 
}






