package org.greenstone.gatherer.file;

import java.io.File;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;


public class FileSystem
{
    static public WorkspaceTreeNode getLocalFilespaceNode(FileSystemModel model)
    {
	// Get all the available roots mounted on the filesystem
	File[] roots = File.listRoots();
	if (roots == null) {
	    return null;
	}

	// If there is just one root use it as the tree root (Unix)
	if (roots.length == 1) {
	    return new WorkspaceTreeNode(roots[0], Dictionary.get("Tree.Root"));
	}

	// Otherwise build a dummy node which has the roots as children (Windows)
	else {
	    return new WorkspaceTreeNode(null, Dictionary.get("Tree.Root"));
	}
    }


    static public WorkspaceTreeNode getHomeFolderNode()
    {
	// Get the name of the OS we're running on
	String os_name = System.getProperty("os.name");
	if (os_name == null) {
	    return null;
	}

	// Make sure we're running on a multiuser OS where the idea of a "user home" is valid
	DebugStream.println("Property os.name: " + os_name);
	String os_name_lc = os_name.toLowerCase();
	if (os_name_lc.equals("windows 95") || os_name_lc.equals("windows 98") || os_name_lc.equals("windows me")) {
	    return null;
	}

	// Get the user's home folder
 	String home_folder_str = System.getProperty("user.home");
	if (home_folder_str == null || home_folder_str.length() == 0) {
	    return null;
	}

	// Generate a special mapping to the user home folder
	File home_folder = new File(home_folder_str);
	return new WorkspaceTreeNode(home_folder, Dictionary.get("Tree.Home", home_folder.getName()));
    }


    static public WorkspaceTreeNode getDownloadedFilesNode()
    {
	// Return a mapping to the downloaded files folder
	return new WorkspaceTreeNode(new File(Gatherer.getGLIUserCacheDirectoryPath()), Dictionary.get("Tree.DownloadedFiles"));
    }
}
