/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: John Thompson, NZDL Project, University of Waikato
 *
 * Copyright (C) 2005 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer;


import java.io.*;
import javax.swing.*;
import org.greenstone.gatherer.util.Utility;

/**
 * Containing the main() method, this class is the entry point for the
 * stand-alone (non-Applet) GLI. The main point of this class is to set
 * some stand-alone specific properties and then create an instance of the
 * Gatherer class.
 * @author John Thompson, NZDL Project, University of Waikato
 */
public class GathererProg
{
    /** The entry point into the stand-alone GLI.
     * @param args A collection of arguments that may include: initial screen size, dictionary, path to the GSDL etc.
     */
    static public void main(final String[] args)
    {
	// A serious hack, but its good enough to stop crappy 'Could not
	// lock user prefs' error messages.  Thanks to Walter Schatz from
	// the java forums.
	System.setProperty("java.util.prefs.syncInterval","2000000"); 
	// => results in one message every 600 hours!

	// Ensure platform specific LAF
	try {
	    // UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	    UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
	}
	catch (Exception exception) {
	    exception.printStackTrace();
	}


	GetOpt go = new GetOpt(args);
			
	// Determine the GLI user directory path
	String gli_user_directory_path = null;
	if (go.webswing) {
	    //org.webswing.toolkit.api.WebswingUtil.getWebswingApi().sendActionEvent("javaToWebswingJSConsoleLog", "args are: " + java.util.Arrays.toString(args), null);
	    
	    if (go.gsdl3_src_path != null) {
		// above is a (albeit a crude) test at this early stage of running,
		// that makes sure we're running GS3

		// "user.dir" resolves to the user's current-working-directory
		// which is engineered through webswing.config to be the GLI home directory		
		
		gli_user_directory_path = System.getProperty("user.dir") + File.separator + "webswing-users" + File.separator;		

		File gli_user_directory = new File(gli_user_directory_path);
		
		if (!gli_user_directory.exists() && !gli_user_directory.mkdir()) {
		    System.err.println("Warning: Unable to make directory: " + gli_user_directory_path);
		}
	    }
	    else {
		System.err.println("Webswing for Greenstone2 not supported");
		System.exit(1);
	    }
	}
	else {
	    gli_user_directory_path = System.getProperty("user.home") + File.separator;

	
	    if (Utility.isWindows()) {
		gli_user_directory_path += "Application Data" + File.separator + "Greenstone" + File.separator + "GLI" + File.separator;
	    }
	    else {
		gli_user_directory_path += ".gli" + File.separator;
	    }
	}
	
	Gatherer.setGLIUserDirectoryPath(gli_user_directory_path);

	// We have a local GLI
	Gatherer.setGLIDirectoryPath(System.getProperty("user.dir") + File.separator);
	
	// Create an instance of the Gatherer class, which will parse the args and prepare the rest of the GLI
	final Gatherer gatherer = new Gatherer(go);
		
	// TESTING circumventing the old GUI event dispatch thread exceptions in GLI. Follows
	// https://docs.oracle.com/javase/6/docs/api/javax/swing/package-summary.html#threading
	// referred from Event Dispatch Thread page at https://joel-costigliola.github.io/assertj/assertj-swing-edt.html
	
	// Schedule a job for the event-dispatching thread:
        // creating and showing this application's GUI.


	// Display all Java properties,
	// https://stackoverflow.com/questions/228477/how-do-i-programmatically-determine-operating-system-in-java
        //System.getProperties().list(System.out);

	Gatherer.invokeInEDT_replacesProceedInCurrThread("GathererProg.main() - gatherer.openGUI", Gatherer.SYNC, new Runnable() {
            public void run() {
		//final Gatherer gatherer = new Gatherer(go);
		
		// This line used to be done immediately after setGLIDirectoryPath()
		// and new Gatherer() above, but is now inside an invokeLater() to do graphical stuff here.

		// Display the GUI immediately
		gatherer.openGUI();
            }
        });
	
    }
}
