/**
 *############################################################################
 * A component of the Greenstone Librarian Interface, part of the Greenstone
 * digital library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: Michael Dewsnip, NZDL Project, University of Waikato, NZ
 *
 * Copyright (C) 2006 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *############################################################################
 */
package org.greenstone.gatherer.gui;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.gui.TestingPreparation;

public class RenamePrompt
    extends JDialog 
    implements ActionListener, KeyListener
{
    private JButton cancel_button;
    private JButton ok_button;
    private JTextField name_textfield;
    private String name;

    static final private Dimension SIZE = new Dimension(350, 100);


    public RenamePrompt(FileNode collection_tree_node)
    {
	super(Gatherer.g_man, true);
        this.setComponentOrientation(Dictionary.getOrientation());
	setTitle(Dictionary.get("RenamePrompt.Title"));
	name = collection_tree_node.getFile().getName();
    }


    public void actionPerformed(ActionEvent event)
    {
	if (event.getSource() == ok_button) {
	    name = name_textfield.getText();
	}
	else if (event.getSource() == cancel_button) {
	    name = null;
	}
	dispose();
    }

    public void keyPressed(KeyEvent e) {
	if (e.getKeyCode() == KeyEvent.VK_ENTER) {
            // Enter: Click the button in focus
            Object source = e.getSource();
            if (source instanceof AbstractButton) {
                ((AbstractButton) source).doClick();
            } else if (source == name_textfield) {
		ok_button.doClick();
	    }
        }
    }

    // Do not accidentally override JDialog.getName() as it is used for GLI automated testing
    public String getNewName() { return this.name; }
    
    public void keyReleased(KeyEvent e) { }
    
    public void keyTyped(KeyEvent e) { }


    public String display()
    {
	setSize(SIZE);
	JPanel content_pane = (JPanel) getContentPane();
        content_pane.setComponentOrientation(Dictionary.getOrientation());
        
	JPanel info_pane = new JPanel();
        info_pane.setComponentOrientation(Dictionary.getOrientation());
        
	JLabel name_label = new JLabel(Dictionary.get("RenamePrompt.Name"));
        name_label.setComponentOrientation(Dictionary.getOrientation());
	name_textfield = new JTextField(name);
        name_textfield.setComponentOrientation(Dictionary.getOrientation());

	JPanel button_pane = new JPanel();
        button_pane.setComponentOrientation(Dictionary.getOrientation());
	ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
	cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Pure_Cancel_Tooltip"));
	
	// Connection
	cancel_button.addActionListener(this);
	ok_button.addActionListener(this);
	ok_button.addKeyListener(this);
	name_textfield.addKeyListener(this);

	// Layout
	info_pane.setLayout(new BorderLayout(5,0));
	info_pane.add(name_label, BorderLayout.LINE_START);
	info_pane.add(name_textfield, BorderLayout.CENTER);

	button_pane.setBorder(BorderFactory.createEmptyBorder(5,0,0,0));
	button_pane.setLayout(new GridLayout(1,2,0,5));
	button_pane.add(ok_button);
	button_pane.add(cancel_button);

	content_pane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
	content_pane.setLayout(new BorderLayout());
	content_pane.add(info_pane, BorderLayout.CENTER);
	content_pane.add(button_pane, BorderLayout.SOUTH);

	// Display
	Rectangle frame_bounds = Gatherer.g_man.getBounds();
	setLocation(frame_bounds.x + (frame_bounds.width - SIZE.width) / 2, frame_bounds.y + (frame_bounds.height - SIZE.height) / 2);

	TestingPreparation.setNamesRecursively(this); // set component names *before* displaying
	setVisible(true);
	return name;
    }
}
