/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Copyright (C) 2022 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.cdm;

import java.util.ArrayList;
import org.greenstone.gatherer.util.StaticStrings;
import org.w3c.dom.Element;

/** This class encapsulates a sort field - used by Lucene and SOLR
    It basically is an index, with a different field name */

public class SortField extends Index {

    static final String sortfield_element = StaticStrings.SORT_ELEMENT;
    protected String default_sortfield_element = StaticStrings.SORT_DEFAULT_ELEMENT; 

    public SortField() {
    }

    public SortField(Element element) {
	super(element);
    }
    public SortField(ArrayList sources) {
	super(sources);
    }

    protected String getElementName() {
	return sortfield_element;
    }

    protected String getDefaultElementName() {
      return default_sortfield_element;
    }

    /** used for determining type of associated collection meta 
     * should be overridden by subclasses */
    public String getType() {
	return SearchMeta.TYPE_SORT;
    }

    public DOMProxyListEntry create(Element element) {
	return new SortField(element);
    }

    public DOMProxyListEntry create(ArrayList sources) {
	return new SortField(sources);
    }
}
