<?xml version="1.0" encoding="UTF-8"?>

<!--
    Contains templates that are common to stylesheets
    that deal with document-related transformations.
-->

<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:java="http://xml.apache.org/xslt/java"
    xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil"
    xmlns:gslib="http://www.greenstone.org/skinning"
    xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat"
    extension-element-prefixes="java util"
    exclude-result-prefixes="java util gsf">

    <xsl:template name="sectionTitle">
        <gsf:metadata name="Title" highlight="true" />
    </xsl:template>

    <xsl:template name="sectionHeading">
        <xsl:call-template name="sectionTitle" />
    </xsl:template>

    <!-- Displays the text content of a node (content node or metadata node), marking up the annotations -->
    <xsl:template name="displayMarkedUpTextAndAnnotations">
        <xsl:variable name="annotation_class">
            <xsl:choose>
                <xsl:when test="/page/pageRequest/paramList/param[@name = 'hl']/@value = 'off' or /page/pageResponse/interfaceOptions/option[@name='highlightQueryTerms']/@value='false' or /page/pageResponse/format[@type='display']/gsf:option[@name='disableSearchTermHighlighting']/@value='true'">
                    noTermHighlight
                </xsl:when>
                <xsl:otherwise>termHighlight</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:for-each select="node()">
            <xsl:choose>
                <xsl:when test="not(name())">
                    <!--
                        TODO: Disabling output escaping can cause issues when the document content contains
                        invalid HTML, e.g. for PDF documents that have been converted.
                        In one case, the node title section contained a self-closing div, which is invalid.
                        This messes up the rest of the document structure.
                    -->
                    <xsl:value-of select="." disable-output-escaping="yes" />
                </xsl:when>
                <xsl:when test="name() = 'annotation'">
                    <span class="{$annotation_class}">
                        <xsl:value-of select="." />
                    </span>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

</xsl:stylesheet>
