<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:java="http://xml.apache.org/xslt/java" xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil" xmlns:gslib="http://www.greenstone.org/skinning" xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat" xmlns:lxslt="http://xml.apache.org/xslt" xmlns:result="http://www.example.com/results" xmlns:exsl="http://exslt.org/common" extension-element-prefixes="java util result exsl" exclude-result-prefixes="util java util gsf gslib">

    <xsl:import href="header.xsl" />
    <xsl:param name="lang" />
    <xsl:include href="formatmanager.xsl" />

    <!-- the output format for this layout is html -->
    <xsl:output method="html" omit-xml-declaration="yes" />

    <xsl:template match="/">
        <xsl:call-template name="mainTemplate" />
    </xsl:template>

    <!-- the main layout is defined here -->
    <xsl:template name="mainTemplate">

        <html lang="{$lang}">

            <head>
                <!-- ***** in header.xsl ***** -->
                <xsl:call-template name="create-html-header" />
                
            </head>
            
            <body>
              <xsl:call-template name="textDirectionAttribute" />
                <xsl:call-template name="actionClass" />
                <!-- Consider bringing this template call back, but wrapped up in an "if debug" ?? -->
                <!--<xsl:call-template name="displayErrorsIfAny"/>-->
                <a name="top">
                    <xsl:text> </xsl:text>
                </a>
			    
		<!-- ***** in header.xsl ***** -->
		<xsl:call-template name="top-area"/>
		
                <div id="container" class="ui-corner-all">

                    <!-- ***** in header.xsl ***** -->
                    <xsl:call-template name="create-banner" />

                    <xsl:if test="/page/pageRequest/paramList/param[(@name='formatedit') and (@value='on')]">
                        <xsl:call-template name="formatmanagerpre" />
                    </xsl:if>

                    <!-- 
                        IMPORTANT: when copying this file to base your own custom interface's main.xsl on this one,
                        or when writing a main.xsl for your custom interface from scratch,
                        it is absolutely crucial to ensure the div element containing the xsl:apply-templates for /page
                        is given the id="gs_content".
                        Without this, many parts of GS3 will fail as they make use of gs_content whenever they make
                        calls to the GS server that include 'excerptid=gs_content' in the URL params.
                        For instance, connecting a client-GLI to a remote GS3 server and attempting to view
                        collections will fail as the user groups for a user will return null without this.
                        ADDITIONAL NOTE: it has not been investigated whether adding addition html elements inside the
                        div with id="gs_content" is wise. I've not checked whether such elements will be parsed out
                        properly and just the expected portions retrieved successfully by callers that requested
                        excerptid=gs_content.
                    -->
                    <div id="gs_content" class="ui-widget-content">
                        <!--
                            Show the content of the page.
                            to customise this part, edit the xsl file for the page you want to edit
                        -->
                        <xsl:apply-templates select="/page" />

                    </div>

                    <xsl:call-template name="gs_footer" />
                </div>
            </body>
        </html>
    </xsl:template>

    <!-- default is to have nothing inthea rightSidebar -->
    <xsl:template name="floatRightSidebar">
        <div id="float-anchor" style="width: 30%; min-width:180px; float:right; margin: 0 0 10px 20px;">
            <xsl:call-template name="rightSidebar" />
        </div>
    </xsl:template>

    <!-- Default rule is to be empty => no rightSidebar to show -->
    <!-- Gets overridden in pages such as query.xsl and classifier.xsl to display baskets and facet info elements -->
    <xsl:template name="rightSidebar"></xsl:template>

    <!-- Template controlling the footer. -->
    <xsl:template name="gs_footer">
        <div id="gs_footer" class="ui-widget-header ui-corner-bottom">
            <a href="https://www.greenstone.org">
                <gslib:poweredByGS3TextBar />
            </a>
        </div>
    </xsl:template>

</xsl:stylesheet>
