(function ( $ ) {
    
    /*
    Plugin: ShowMore
    author: dtasic@gmail.com
    */
    
    $.fn.showMore = function (options) {
        
        "use strict";
        
        var currentelem = 1;
        
        this.each(function(){
            
            var currentid = '';
            var element = $(this);
            var auto = parseInt(element.innerHeight())/2;
            var fullheight = element.innerHeight();
            var maxWidth = element.css('width');
            var settings = $.extend({
                minheight: auto,
                buttontxtmore: "show more",
                buttontxtless: "show less",
                buttoncss: "showmore-button",
                animationspeed: auto       
            }, options );        
            
            element.attr('id') != undefined ? currentid = element.attr('id') : currentid = currentelem;
            element.wrap( "<div id='showmore-"+currentid+"' data-showmore"+(maxWidth == '0px' ? "" : " style='max-width:"+maxWidth+";'")+"></div>" );
            
            if (element.parent().not('[data-showmore]')) {
            
                if (fullheight > settings.minheight) {
                    
                    element.css('min-height', settings.minheight).css('max-height', settings.minheight).css('overflow', 'hidden');
                    var showMoreButton = $("<div />", {
                        id: "showmore-button-"+currentid,
                        "class": settings.buttoncss,
                        click: function() {

                            if (element.css('max-height') != 'none') {
				var url = window.location.href;

				var url_hash = window.location.hash;
				var currentid_re = new RegExp(currentid);
				if (!currentid_re.test(url_hash)) {
				    var new_url = url;
				    if (url_hash == "") {
					new_url += "#" + currentid;
				    }
				    else {
					new_url += "," + currentid;
				    }
				    history.replaceState(null,null,new_url);
				}
				
                                element.css('height', settings.minheight).css('max-height', '').animate({height:fullheight}, settings.animationspeed, function () { showMoreButton.html(settings.buttontxtless); });
                            }
			    else {

				var url = window.location.href;
				var url_hash = window.location.hash;

				var currentid_re = new RegExp(currentid);
				if (currentid_re.test(url_hash)) {
				    var new_url_hash = url_hash.replace(currentid,"");
				    // tidy-up
				    var new_url_hash = new_url_hash.replace(/,,/,",").replace(/^#,/,"#").replace(/,$/,"");
				    
				    var new_url = url.replace(/#.*$/,"");
				    if (new_url_hash != "#") {
					new_url += new_url_hash;
				    }
				    history.replaceState(null,null,new_url);
				}
				
                                element.animate({height:settings.minheight}, settings.animationspeed, function () { showMoreButton.html(settings.buttontxtmore); element.css('max-height', settings.minheight); });
                            }
                        },
                        html: settings.buttontxtmore
                    });

                    element.after(showMoreButton);

                }
                
                currentelem++;
                
            }
            
        });
        
        return this;
        
    };

}(jQuery));


$(document).ready(function() {

    var url_hash = window.location.hash.replace(/^#/,"");
    var showmore_ids = url_hash.split(",");

    for (var i=0; i<showmore_ids.length; i++) {
	var showmore_id = showmore_ids[i];
	var $showmore_button = $('#showmore-button-'+showmore_id);
    
	if ($showmore_button.length>0) {
	    $showmore_button.click();
	}
    }
});
