#!/bin/bash

# Greenstone interfaces sit on top of JQuery-UI theming
#   http://docs.jquery.com/UI/Theming/API

# This script is a Greenstone tweak that lets you take the Greenstone
# 'default' interface, and choose a different color palette

# Below the sed substitution performing the 'null' transformation
# It takes the RGB values that are the shades of green that provide
# the 'default' interface, and changes them to HSL values that specify
# *exactly* the same RGB value.  This is done so it is easier to make
# changes to the hue value being used, but keep the saturation/lightness
# the same as before.


#bgColorDefault=459e00     // HSL( 94, 100%, 31%)
#borderColorDefault=327e04 // HSL( 97,  94%, 25%)

# (currently duplicates dbColorDefault)
#fcActive=459e00           // HSL( 94, 100%, 31%)

#bgColorHeader=43a21a      // HSL(102,  72%, 37%)
#borderColorHeader=72b125  // HSL( 87,  65%, 42%)


cat jquery-ui-1.8.16.custom.css.in \
    | sed 's/#459e00/hsl( 94, 100%, 31%)/g' \
    | sed 's/#327e04/hsl( 97,  94%, 25%)/g' \
    | sed 's/#43a21a/hsl(102,  72%, 37%)/g' \
    | sed 's/#72b125/hsl( 87,  65%, 42%)/g' \
	  > jquery-ui-1.8.16.custom.css



