#!/bin/bash

package=pkg-config
#version=-0.25
version=-0.29

progname=$0

source ../cascade-make/lib/cascade-lib.bash GEXTGNOME ../.. $*

prefix=$GEXTGNOME_INSTALLED

export GLIB_CFLAGS="-I$GEXTGNOME_INSTALLED/include/glib-2.0 -I$GEXTGNOME_INSTALLED/lib/glib-2.0/include"
export GLIB_LIBS="-L$GEXTGNOME_INSTALLED/lib -lglib-2.0" 

osversion=`uname -r | sed 's/\..*$//'`;
if [ "x$GSDLOS" = "xdarwin" -a $osversion -ge 11 ] ; then
    export CFLAGS="$CFLAGS -framework Carbon -framework CoreFoundation -framework Security"
fi

opt_run_untar $force_untar $auto_untar $package $version
opt_run_configure $force_config $auto_config $package $version $prefix --disable-shared --enable-static

opt_run_make $compile $package $version
opt_run_make $install $package $version "install"
opt_run_make $clean $package $version "clean"
opt_run_make $distclean $package $version "distclean"

opt_run_tarclean $tarclean $package $version