#!/bin/bash

package=libiconv
version=-1.14

progname=$0

source ../cascade-make/lib/cascade-lib.bash GEXTGNOME ../.. $*

prefix=$GEXTGNOME_INSTALLED

if [ "x$crossOS" = "xandroid" ] ; then
  # Stops configure generating a local 'stdint.h' in 'srclib' folder
  # (when this file was generated, caused no end of issues with chaining
  #  standard header files, errors with time_t, pid_t etc)
  # Fix came from:
  #  http://stackoverflow.com/questions/9053702/building-libiconv-fails-with-the-android-standalone-toolchain

  extra_config_args="gl_cv_header_working_stdint_h=yes"
else
  extra_config_args=
fi


opt_run_untar $force_untar $auto_untar $package $version
opt_run_configure $force_config $auto_config $package $version $prefix \
  $extra_config_args

opt_run_make $compile $package $version
opt_run_make $install $package $version "install"
opt_run_make $clean $package $version "clean"
opt_run_make $distclean $package $version "distclean"

opt_run_tarclean $tarclean $package $version