/**********************************************************************
 *
 * infodbclass.h -- 
 * Copyright (C) 1999-2008  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef INFODBCLASS_H
#define INFODBCLASS_H


#include "text_t.h"


typedef map<text_t, text_tarray, lttext_t> text_tarraymap;


// infodbclass is used to store information about a object
class infodbclass {
protected:
  text_tarraymap info;
  text_t lang;

public:
  // type support for text_tarraymap
  typedef text_tarraymap::iterator iterator;
  typedef text_tarraymap::const_iterator const_iterator;
  typedef text_tarraymap::reference reference;
  typedef text_tarraymap::const_reference const_reference;
  typedef text_tarraymap::size_type size_type;
  typedef text_tarraymap::difference_type difference_type;
  typedef text_tarraymap::const_reverse_iterator const_reverse_iterator;
  typedef text_tarraymap::reverse_iterator reverse_iterator;
  
  // constructors
  infodbclass ();

  // basic container support
  iterator begin () {return info.begin();}
  const_iterator begin () const {return info.begin();}
  iterator end () {return info.end();}
  const_iterator end () const {return info.end();}

  void erase(iterator pos) {info.erase(pos);}
  void erase(iterator first, iterator last) {info.erase(first, last);}
  infodbclass &operator=(const infodbclass &x) {info=x.info;return *this;}

  bool empty () const {return info.empty();}
  size_type size() const {return info.size();}


  // added functionality
  void clear () {info.erase(info.begin(),info.end());}

  // set default language
  void set_language(const text_t& str_lang) { lang = str_lang; }
  const text_t &get_language() const { return lang; }

  // the following functions deal with keys that can only
  // have one value for compatibility
  
  // getinfo returns NULL if there isn't an entry with
  // 'key' already defined, getintinfo returns 0 if there wasn't an
  // entry with 'key' defined and operator[] returns "" if
  // 'key' wasn't already defined (and sets 'key'="").
  void setinfo (const text_t &key, const text_t &value);
  void setintinfo (const text_t &key, int value);
  void setcinfo (const text_t &key, unsigned short c);
  text_t *getinfo (const text_t &key);
  // get info overriding language set on this object
  text_t *getinfo (const text_t &key, const text_t& lang);
  int getintinfo (const text_t &key);
  // get info overriding language set on this object
  int getintinfo (const text_t &key, const text_t& lang);
  text_t &operator[] (const text_t &key);


  // the next set of functions allow you to set and access keys
  // that can have more than one value

  // getmultinfo returns NULL if there isn't an entry with
  // 'key' already defined
  void addinfo (const text_t &key, const text_t &value);
  void addintinfo (const text_t &key, int value);
  void addcinfo (const text_t &key, unsigned short c);
  text_tarray *getmultinfo (const text_t &key);
  // get info overriding language set on this object
  text_tarray *getmultinfo (const text_t &key, const text_t& lang);
};


#endif
