/**********************************************************************
 *
 * CRC32.h
 * Copyright (C) 2003  UNESCO
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

////////////////////////////////////////////////////////////////////////////////////
// CRC32.H
//
// The CRC32 functions (Cyclic Redundancy Check) are used to
// calculate a sophisticated checksum based on the algebra of
// polynomials. The Cyclic Redundancy Check, is a way to detect
// bit errors that occur during data storage or transmission.
// The CRC-32 algorithm operates on a block of data as a single
// large numerical value. The algorithm divides this large value
// by the CRC-32 polynomial or generator polynomial, leaving the
// remainder 32-bit, which is the checksum. 
#ifndef __CRC32_H__
#define __CRC32_H__

#include <fstream>

mg_u_long CalcCRC32(char *buf, unsigned int len); // **** was just 'unsigned len'
mg_u_long CalcCRC32(const char *buf, unsigned int len); // ****  was just 'unsigned len'
mg_u_long CalcCRC32(unsigned char c, mg_u_long CRC);
mg_u_long CalcCRC32(std::fstream &infile);

#ifdef __USE_CRC32_TABLE_FUNCTIONS__
#include <iostream>
int makeCRC32(std::ostream &stream);
#endif

#endif  // __CRC32_H__
