package org.greenstone.gatherer.remote;

import java.io.*;
import java.util.zip.*;


/**
 */
public class ZipCollectionShell
{
    static public void main(String[] args)
    {
	if ((args.length < 3) || (args.length > 4)) {
	    System.err.println("Usage: ZipCollectionShell <zip-file> <collect-directory-path> <collection-name> [gsdl3]");
	    return;
	}

	String zip_file_path = args[0];
	String collect_directory_path = args[1];
	String collection_name = args[2];
	String run_gsdl3 ="";
	if (args.length == 4){
	    run_gsdl3 = args[3];
	}
	if (!collect_directory_path.endsWith(File.separator)) {
	    collect_directory_path += File.separator;
	}

 	try {
	    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip_file_path));
	    ZipTools.ZipFilter null_zip_filter = new ZipTools.NullZipFilter();

	    // Add archives directory, with doc.xml files only
	    String archives_relative_path = collection_name + File.separator + "archives";
	    ZipTools.ZipFilter collection_archives_zip_filter = new ZipCollectionArchives.CollectionArchivesZipFilter();
	    ZipTools.addFileToZip(zos, collect_directory_path, archives_relative_path, collection_archives_zip_filter);

	    // Add /etc/collect.cfg file for 2 GS2
	    if (run_gsdl3.length()==0){
		String collect_cfg_relative_path = collection_name + File.separator + "etc" + File.separator + "collect.cfg";
		ZipTools.addFileToZip(zos, collect_directory_path, collect_cfg_relative_path, null_zip_filter);
	    }
	    // Add /etc/collectConfig.xml file for a GS3
	    if (run_gsdl3.equals("gsdl3")){
		String collectionConfig_xml_relative_path = collection_name + File.separator + "etc" + File.separator + "collectionConfig.xml";
		ZipTools.addFileToZip(zos, collect_directory_path, collectionConfig_xml_relative_path, null_zip_filter);
	    }
	    // Add images directory
	    String images_relative_path = collection_name + File.separator + "images";
	    ZipTools.addFileToZip(zos, collect_directory_path, images_relative_path, null_zip_filter);

	    // Add import directory, with zero-length files except for metadata.xml
	    String import_relative_path = collection_name + File.separator + "import";
	    ZipTools.ZipFilter collection_import_zip_filter = new CollectionImportZipFilter();
	    ZipTools.addFileToZip(zos, collect_directory_path, import_relative_path, collection_import_zip_filter);

	    // Add index/build.cfg file
	    String build_cfg_relative_path = collection_name + File.separator + "index" + File.separator + "build.cfg";
	    ZipTools.addFileToZip(zos, collect_directory_path, build_cfg_relative_path, null_zip_filter);

	    // Add macros/extra.dm file
	    String extra_dm_relative_path = collection_name + File.separator + "macros" + File.separator + "extra.dm";
	    ZipTools.addFileToZip(zos, collect_directory_path, extra_dm_relative_path, null_zip_filter);

	    // Add metadata directory
	    String metadata_relative_path = collection_name + File.separator + "metadata";
	    ZipTools.addFileToZip(zos, collect_directory_path, metadata_relative_path, null_zip_filter);

	    zos.close();
	}
	catch (Exception exception) {
	    exception.printStackTrace();
	}
    }


    static private class CollectionImportZipFilter
	extends ZipTools.NullZipFilter
    {
	public boolean shouldIncludeFileContent(String relative_file_path)
	{
	    // We only include file content for metadata.xml files
	    return (relative_file_path.equals("metadata.xml") || relative_file_path.endsWith(File.separator + "metadata.xml"));
	}
    }
}
