/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
* This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.cdm;

import org.greenstone.gatherer.util.StaticStrings;
import org.w3c.dom.Element;


public class SuperCollection
    implements DOMProxyListEntry {

    private Element element;
    private String name;

    public SuperCollection() {
	element = null;
	name = null;
    }

    public SuperCollection(Element element) {
	this.element = element;
	name = null;
    }

    public int compareTo(Object other) {
	return this.getName().compareTo(other.toString());
    }

    public DOMProxyListEntry create(Element element) {
	return new SuperCollection(element);
    } 

    public boolean equals(Object other) {
	return (compareTo(other) == 0);
    }

    public Element getElement() {
	return element;
    }

    public String getName() {
	if(name == null && element != null) {
	    name = element.getAttribute(StaticStrings.NAME_ATTRIBUTE);
	}
	return name;
    }

    public boolean isAssigned() {
	return (element != null && element.getAttribute(StaticStrings.ASSIGNED_ATTRIBUTE).equals(StaticStrings.TRUE_STR));
    }

    public void setAssigned(boolean assigned) {
	if(element != null) {
	    element.setAttribute(StaticStrings.ASSIGNED_ATTRIBUTE, (assigned ? StaticStrings.TRUE_STR : StaticStrings.FALSE_STR));
	}
    }

    public void setElement(Element element) {
	this.element = element;
	name = null;
    }

    public void setName(String name) {
	this.name = name;
	if(element != null) {
	    element.setAttribute(StaticStrings.NAME_ATTRIBUTE, name);
	}
    }

    public String toString() {
	return getName();
    }
}
