extdesc="the Solr9 Extension"

full_setup=`pwd`/${BASH_SOURCE}
# remove /gs3-setup.sh from end of path
fulldir=${full_setup%/*}
# remove /. from end of path (as full_setup ends up like ..ext/solr9/./gs3-setup.sh)
fulldir=${fulldir%/.}


if [ "x$GEXT_SOLR9" = "x" ] ; then
  export GEXT_SOLR9=`pwd`
  extdir=${GEXT_SOLR9##*/}

  if [ -d "$GEXT_SOLR9/bin/script" ] ; then
    export PATH=$GEXT_SOLR9/bin/script:$PATH
  fi

  if [ -d "$GEXT_SOLR9/lib" ] ; then
    if [ "$GSDLOS" = "linux" ] ; then
      export LD_LIBRARY_PATH=$GEXT_SOLR9/lib:$LD_LIBRARY_PATH
    elif [ "$GSDLOS" = "darwin" ] ; then
      export DYLD_LIBRARY_PATH=$GEXT_SOLR9/lib:$DYLD_LIBRARY_PATH
    fi
  fi

  if [ "x$GSDL3EXTS" = "x" ] ; then
    export GSDL3EXTS=$extdir
  else 
    export GSDL3EXTS=$GSDL3EXTS:$extdir
  fi

  solr_data_dir=$GSDL3DATAHOME/ext/solr9
  export SOLR_HOME=$solr_data_dir
  echo Setting SOLR_HOME=$SOLR_HOME

  SOLR_PORT=7983
  SOLR_HOST=127.0.0.1
  file=$GEXT_SOLR9/build.properties

while IFS== read propname propval; do
    if [ "x$propname" = "xsolr.port" ] ; then
        SOLR_PORT=$propval
    fi
    if [ "x$propname" = "xlocalhost.http" ] ; then
        SOLR_HOST=$propval
    fi
done < $file

  export SOLR_PORT
  export SOLR_HOST

  echo "+Your environment is now setup for $extdesc"
else
  echo "+Your environment is already setup for $extdesc"
fi

echo "  - Solr API accessed internally via: http://$SOLR_HOST:$SOLR_PORT"
