#!/bin/bash

if [ $# != 1 ] ; then
    echo "Usage: $0 ext-name" >&2
    exit 1
fi

ext=$1

if [ $ext = "mars-src" ] || [ $ext = "mars" ] ; then
    svn co https://svn.greenstone.org/gs3-extensions/mars-src/trunk mars
elif [ $ext = "structured-image" ] || [ $ext = "structured-audio" ] ; then
    svn co https://svn.greenstone.org/gs3-extensions/$ext/trunk $ext
elif [ $ext = "selfcontained-jdk" ] || [ $ext = "selfcontained-rust" ] ; then
    svn co https://svn.greenstone.org/gs3-extensions/$ext/trunk $ext
elif [ $ext = "selfcontained-rclone" ] ; then
    svn co https://svn.greenstone.org/gs3-extensions/$ext/trunk $ext
elif [ $ext = "selfcontained-gcloud" ] ; then
    svn co https://svn.greenstone.org/gs3-extensions/$ext/trunk $ext
elif [ $ext = "realistic-books" ] ; then
    svn co https://svn.greenstone.org/gs3-extensions/$ext/trunk $ext
elif [ $ext = "tabletop-dl" ] ; then
    svn co https://svn.greenstone.org/gs3-extensions/$ext/trunk $ext
elif [ $ext = "web-audio" ] ; then
    svn co https://svn.greenstone.org/gs3-extensions/$ext/trunk $ext
else
    svn co https://svn.greenstone.org/gs3-extensions/$ext/trunk/src $ext
fi

