#!/bin/bash

# The openssl command to run for converting letsencrypt certificates to a form
# Tomcat likes
# Added as a separate script in case you want to have this run automatically
# on renewal. In this case, add lines like the following to your /etc/sudoers.d/custom file
# COMMAND FOR EDITING: sudo visudo /etc/sudoers.d/custom
# LINES TO ADD: %sudo ALL=(root) NOPASSWD: <PATH_TO_GREENSTONE3>/convert-https-cert.sh
#             : %sudo ALL=(root) NOPASSWD: /usr/bin/rm /tmp/<DOMAIN>_fullchain_and_key.p12

# Replace <PATH_TO_GREESNTONE3> with the full path to your greenstone3 folder, <DOMAIN> with tomcat.server value from build.properties, and <KEYSTORE-PASSWORD> with keystore.pass value from build.properties

# Then run ant renew-existing-https-cert-linux-auto to set up the deploy hook for renewal
<PATH_TO_GREENSTONE3>/bin/linux/openssl/bin/openssl pkcs12 -export \
    -out /tmp/<DOMAIN>_fullchain_and_key.p12 \
    -in /etc/letsencrypt/live/<DOMAIN>/fullchain.pem \
    -inkey /etc/letsencrypt/live/<DOMAIN>/privkey.pem \
    -name greenstone3-tomcat -password pass:<KEYSTORE-PASSWORD>
