/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.rep.GroupShutdownException;
import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class DbSync {
    public static final String DBSYNC_ENV = "-env";
    public static final String DBSYNC_GROUP_NAME = "-groupName";
    public static final String DBSYNC_NODE_NAME = "-nodeName";
    public static final String DBSYNC_NODE_HOST = "-nodeHost";
    public static final String DBSYNC_HELPER_HOST = "-helperHost";
    public static final String DBSYNC_TIMEOUT = "-timeout";
    private static final String FORMAT = "%1$-15s";
    private String envHome;
    private String groupName;
    private String nodeName;
    private String nodeHost;
    private String helperHost;
    private long timeout;
    private static final String usageString = "usage: " + CmdUtil.getJavaCommand(DbSync.class) + "\n" + String.format("%1$-15s", "-env") + "# environment home directory for the node\n" + String.format("%1$-15s", "-groupName") + "# name of the replication group\n" + String.format("%1$-15s", "-nodeName") + "# name of the node in the group\n" + String.format("%1$-15s", "-nodeHost") + "# host name or IP address and port number for the node\n" + String.format("%1$-15s", "-helperHost") + "# helperHost for the node\n" + String.format("%1$-15s", "-timeout") + "# time for the node to catch up with master, in milliseconds\n";

    public static void main(String[] args) throws Exception {
        DbSync syncup = new DbSync();
        syncup.parseArgs(args);
        syncup.sync();
    }

    private void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(usageString);
        System.exit(-1);
    }

    private void parseArgs(String[] args) throws Exception {
        int argc = 0;
        int nArgs = args.length;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = args[argc++].trim()).equals(DBSYNC_ENV)) {
                if (argc < nArgs) {
                    this.envHome = args[argc++];
                    continue;
                }
                this.printUsage("-env requires an argument");
                continue;
            }
            if (thisArg.equals(DBSYNC_GROUP_NAME)) {
                if (argc < nArgs) {
                    this.groupName = args[argc++];
                    continue;
                }
                this.printUsage("-groupName requires an argument");
                continue;
            }
            if (thisArg.equals(DBSYNC_NODE_NAME)) {
                if (argc < nArgs) {
                    this.nodeName = args[argc++];
                    continue;
                }
                this.printUsage("-nodeName requires an argument");
                continue;
            }
            if (thisArg.equals(DBSYNC_NODE_HOST)) {
                if (argc < nArgs) {
                    this.nodeHost = args[argc++];
                    continue;
                }
                this.printUsage("-nodeHost requires an argument");
                continue;
            }
            if (thisArg.equals(DBSYNC_HELPER_HOST)) {
                if (argc < nArgs) {
                    this.helperHost = args[argc++];
                    continue;
                }
                this.printUsage("-helperHost requires an argument");
                continue;
            }
            if (!thisArg.equals(DBSYNC_TIMEOUT)) continue;
            if (argc < nArgs) {
                this.timeout = Long.parseLong(args[argc++]);
                continue;
            }
            this.printUsage("-timeout requires an argument");
        }
        if (this.envHome == null) {
            this.printUsage("-env is a required argument.");
        }
        if (this.groupName == null) {
            this.printUsage("-groupName is a required argument.");
        }
        if (this.nodeName == null) {
            this.printUsage("-nodeName is a required argument.");
        }
        if (this.nodeHost == null) {
            this.printUsage("-nodeHost is a required argument.");
        }
        if (this.helperHost == null) {
            this.printUsage("-helperHost is a required argument.");
        }
        if (this.timeout <= 0L) {
            this.printUsage("-timeout should be a positive long number.");
        }
        try {
            RepParams.NODE_HOST_PORT.validateValue(this.nodeHost);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            this.printUsage("Host and Port pair for this node is illegal.");
        }
    }

    private DbSync() {
    }

    public DbSync(String envHome, String groupName, String nodeName, String nodeHost, String helperHost, long timeout) {
        this.envHome = envHome;
        this.groupName = groupName;
        this.nodeName = nodeName;
        this.nodeHost = nodeHost;
        this.helperHost = helperHost;
        this.timeout = timeout;
    }

    public void sync() throws Exception {
        Durability durability = new Durability(Durability.SyncPolicy.WRITE_NO_SYNC, Durability.SyncPolicy.WRITE_NO_SYNC, Durability.ReplicaAckPolicy.ALL);
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(true);
        envConfig.setDurability(durability);
        ReplicationConfig repConfig = new ReplicationConfig();
        repConfig.setNodeName(this.nodeName);
        repConfig.setGroupName(this.groupName);
        repConfig.setNodeHostPort(this.nodeHost);
        repConfig.setHelperHosts(this.helperHost);
        StatusListener listener = new StatusListener();
        ReplicatedEnvironment repEnv = null;
        try {
            repEnv = new ReplicatedEnvironment(new File(this.envHome), repConfig, envConfig, null, QuorumPolicy.ALL);
            repEnv.setStateChangeListener(listener);
        }
        catch (Exception e) {
            System.err.println("Can't successfully initialize " + this.nodeName + " because of " + e);
            System.exit(-1);
        }
        listener.awaitActiveState();
        if (repEnv.getState().isMaster()) {
            Transaction txn = repEnv.beginTransaction(null, null);
            txn.abort();
            repEnv.shutdownGroup(this.timeout, TimeUnit.SECONDS);
        } else if (repEnv.getState().isReplica()) {
            for (long i = 0L; i < this.timeout; ++i) {
                try {
                    repEnv.getState();
                    Thread.sleep(1000L);
                    continue;
                }
                catch (GroupShutdownException e) {
                    break;
                }
            }
        }
        repEnv.close();
    }

    private class StatusListener
    implements StateChangeListener {
        CountDownLatch activeLatch = new CountDownLatch(1);

        private StatusListener() {
        }

        public void stateChange(StateChangeEvent stateChangeEvent) throws RuntimeException {
            switch (stateChangeEvent.getState()) {
                case MASTER: 
                case REPLICA: {
                    this.activeLatch.countDown();
                    break;
                }
                default: {
                    System.err.println(DbSync.this.nodeName + " is disconnected from group.");
                }
            }
        }

        public void awaitActiveState() throws InterruptedException {
            this.activeLatch.await();
        }
    }
}

