/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.MasterStateException;
import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.ReplicationGroup;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.elections.Learner;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.TimebasedProposalGenerator;
import com.sleepycat.je.rep.impl.RepGroupProtocol;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.utilint.LoggerUtils;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationGroupAdmin {
    private final String groupName;
    private final Set<InetSocketAddress> helperSockets;
    private final Protocol electionsProtocol;
    private final RepGroupProtocol groupProtocol;
    private final Logger logger;
    private final Formatter formatter;

    public ReplicationGroupAdmin(String groupName, Set<InetSocketAddress> helperSockets) {
        this.groupName = groupName;
        this.helperSockets = helperSockets;
        this.electionsProtocol = new Protocol(TimebasedProposalGenerator.getParser(), MasterValue.getParser(), groupName, NameIdPair.NOCHECK, null);
        this.groupProtocol = new RepGroupProtocol(groupName, NameIdPair.NOCHECK, null);
        this.logger = LoggerUtils.getLoggerFixedPrefix(this.getClass(), NameIdPair.NOCHECK.toString());
        this.formatter = new ReplicationFormatter(NameIdPair.NOCHECK);
    }

    public Set<InetSocketAddress> getHelperSockets() {
        return this.helperSockets;
    }

    public String getGroupName() {
        return this.groupName;
    }

    private InetSocketAddress getMasterSocket() throws UnknownMasterException, EnvironmentFailureException {
        MasterValue masterValue = Learner.findMaster(this.electionsProtocol, this.helperSockets, this.logger, null, this.formatter);
        return new InetSocketAddress(masterValue.getHostName(), masterValue.getPort());
    }

    public String getMasterNodeName() throws UnknownMasterException, EnvironmentFailureException {
        MasterValue masterValue = Learner.findMaster(this.electionsProtocol, this.helperSockets, this.logger, null, this.formatter);
        return masterValue.getNodeName();
    }

    public ReplicationNode ensureMonitor(RepNodeImpl monitor) throws UnknownMasterException, EnvironmentFailureException {
        if (monitor.getType() != NodeType.MONITOR) {
            throw EnvironmentFailureException.unexpectedState("Node type must be Monitor not: " + (Object)((Object)monitor.getType()));
        }
        MasterValue masterValue = Learner.findMaster(this.electionsProtocol, this.helperSockets, this.logger, null, this.formatter);
        InetSocketAddress masterAddress = new InetSocketAddress(masterValue.getHostName(), masterValue.getPort());
        RepGroupProtocol repGroupProtocol = this.groupProtocol;
        repGroupProtocol.getClass();
        RepGroupProtocol repGroupProtocol2 = this.groupProtocol;
        repGroupProtocol2.getClass();
        TextProtocol.MessageExchange me = repGroupProtocol.new TextProtocol.MessageExchange(masterAddress, "Group", repGroupProtocol2.new RepGroupProtocol.EnsureNode(monitor));
        me.run();
        TextProtocol.ResponseMessage resp = me.getResponseMessage();
        if (resp instanceof RepGroupProtocol.EnsureOK) {
            RepGroupProtocol.EnsureOK okResp = (RepGroupProtocol.EnsureOK)resp;
            monitor.getNameIdPair().update(okResp.getNameIdPair());
            return new RepNodeImpl(new NameIdPair(masterValue.getNodeName()), NodeType.ELECTABLE, masterValue.getHostName(), masterValue.getPort());
        }
        throw this.getException(resp);
    }

    public void removeMember(String nodeName) throws UnknownMasterException, MemberNotFoundException, MasterStateException, EnvironmentFailureException {
        ReplicationGroup group = this.getGroup();
        RepNodeImpl node = (RepNodeImpl)group.getMember(nodeName);
        if (node == null) {
            throw new MemberNotFoundException("Node:" + nodeName + "is not a member of the group:" + this.groupName);
        }
        if (node.isRemoved() && node.isQuorumAck()) {
            throw new MemberNotFoundException("Node:" + nodeName + "is not currently a member of " + "the group:" + this.groupName + " It had been removed.");
        }
        InetSocketAddress masterAddress = this.getMasterSocket();
        if (masterAddress.equals(node.getSocketAddress())) {
            throw new MasterStateException("Cannot remove an active master");
        }
        RepGroupProtocol repGroupProtocol = this.groupProtocol;
        repGroupProtocol.getClass();
        RepGroupProtocol repGroupProtocol2 = this.groupProtocol;
        repGroupProtocol2.getClass();
        TextProtocol.MessageExchange me = repGroupProtocol.new TextProtocol.MessageExchange(masterAddress, "Group", repGroupProtocol2.new RepGroupProtocol.RemoveMember(nodeName));
        me.run();
        TextProtocol.ResponseMessage resp = me.getResponseMessage();
        if (resp instanceof TextProtocol.OK) {
            return;
        }
        throw this.getException(resp);
    }

    public ReplicationGroup getGroup() throws UnknownMasterException, EnvironmentFailureException {
        InetSocketAddress masterSocket = this.getMasterSocket();
        RepGroupProtocol repGroupProtocol = this.groupProtocol;
        repGroupProtocol.getClass();
        TextProtocol.MessageExchange me = repGroupProtocol.new TextProtocol.MessageExchange(masterSocket, "Group", this.groupProtocol.new RepGroupProtocol.GroupRequest());
        me.run();
        TextProtocol.ResponseMessage resp = me.getResponseMessage();
        if (resp instanceof RepGroupProtocol.GroupResponse) {
            return new ReplicationGroup(((RepGroupProtocol.GroupResponse)resp).getGroup());
        }
        throw this.getException(resp);
    }

    private DatabaseException getException(TextProtocol.ResponseMessage resp) {
        if (resp == null) {
            return EnvironmentFailureException.unexpectedState("No response to request");
        }
        if (resp instanceof RepGroupProtocol.Fail) {
            RepGroupProtocol.Fail fail = (RepGroupProtocol.Fail)resp;
            switch (fail.getReason()) {
                case MEMBER_NOT_FOUND: {
                    return new MemberNotFoundException(fail.getMessage());
                }
                case IS_MASTER: {
                    return new MasterStateException(fail.getMessage());
                }
            }
            EnvironmentFailureException.unexpectedState(fail.getMessage());
        }
        if (resp instanceof TextProtocol.ProtocolError) {
            return EnvironmentFailureException.unexpectedState(((TextProtocol.ProtocolError)resp).getMessage());
        }
        return EnvironmentFailureException.unexpectedState("Response not recognized: " + resp);
    }
}

