/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.OffsetList;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.utilint.DbLsn;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedLSNTreeWalker {
    protected DatabaseImpl dbImpl;
    private final EnvironmentImpl envImpl;
    private final long rootLsn;
    private final boolean dups;
    private final boolean setDbState;
    private long[] currentLSNs;
    private int currentLSNIdx = 0;
    private OffsetList accumulatedLSNFileNumbers;
    private OffsetList accumulatedLSNFileOffsets;
    private final TreeNodeProcessor callback;
    protected boolean accumulateLNs = false;
    private boolean processDupTree = true;
    private boolean passNullLSNNodes = false;
    private final List<DatabaseException> savedExceptions;
    private final ExceptionPredicate excPredicate;
    private final DatabaseEntry lnKeyEntry = new DatabaseEntry();

    public SortedLSNTreeWalker(DatabaseImpl dbImpl, boolean setDbState, long rootLsn, TreeNodeProcessor callback, List<DatabaseException> savedExceptions, ExceptionPredicate excPredicate) throws DatabaseException {
        this.dbImpl = dbImpl;
        this.envImpl = dbImpl.getDbEnvironment();
        if (this.envImpl == null) {
            throw EnvironmentFailureException.unexpectedState("environmentImpl is null for target db " + dbImpl.getDebugName());
        }
        this.dups = dbImpl.getSortedDuplicates();
        this.setDbState = setDbState;
        this.rootLsn = rootLsn;
        this.callback = callback;
        this.savedExceptions = savedExceptions;
        this.excPredicate = excPredicate;
        this.currentLSNs = new long[0];
        this.currentLSNIdx = 0;
    }

    void setProcessDupTree(boolean processDupTree) {
        this.processDupTree = processDupTree;
    }

    void setPassNullLSNNodes(boolean passNullLSNNodes) {
        this.passNullLSNNodes = passNullLSNNodes;
    }

    void setAccumulateLNs(boolean accumulateLNs) {
        this.accumulateLNs = accumulateLNs;
    }

    public void walk() throws DatabaseException {
        this.walkInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void walkInternal() throws DatabaseException {
        IN root = null;
        if (this.rootLsn == -1L && !this.passNullLSNNodes) {
            return;
        }
        root = this.getResidentRootIN();
        if (root == null && this.rootLsn != -1L) {
            root = this.getRootIN(this.rootLsn);
        }
        if (root != null) {
            try {
                this.accumulateLSNs(root);
            }
            finally {
                this.releaseRootIN(root);
            }
        }
        if (this.setDbState) {
            this.dbImpl.finishedINListHarvest();
        }
        while (true) {
            this.maybeGetMoreINs();
            if (this.currentLSNs == null || this.currentLSNIdx >= this.currentLSNs.length) break;
            this.fetchAndProcessLSN(this.currentLSNs[this.currentLSNIdx++]);
        }
    }

    private void maybeGetMoreINs() {
        if (this.currentLSNs != null && this.currentLSNIdx >= this.currentLSNs.length) {
            if (this.accumulatedLSNFileNumbers == null || this.accumulatedLSNFileNumbers.size() == 0) {
                this.currentLSNs = null;
                this.currentLSNIdx = Integer.MAX_VALUE;
                return;
            }
            long[] tempFileNumbers = this.accumulatedLSNFileNumbers.toArray();
            long[] tempFileOffsets = this.accumulatedLSNFileOffsets.toArray();
            int nLSNs = tempFileNumbers.length;
            this.currentLSNIdx = 0;
            this.currentLSNs = new long[nLSNs];
            for (int i = 0; i < nLSNs; ++i) {
                this.currentLSNs[i] = DbLsn.makeLsn(tempFileNumbers[i], tempFileOffsets[i]);
            }
            Arrays.sort(this.currentLSNs);
            this.accumulatedLSNFileNumbers = null;
            this.accumulatedLSNFileOffsets = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accumulateLSNs(IN in) throws DatabaseException {
        boolean isDINRoot;
        boolean childIsLN;
        boolean accumulate = true;
        boolean bl = childIsLN = !this.dups && in instanceof BIN || in instanceof DBIN;
        if (childIsLN && !this.accumulateLNs) {
            accumulate = false;
        }
        boolean bl2 = isDINRoot = in instanceof DIN && in.isRoot();
        if (in != null && (this.processDupTree || !in.containsDuplicates())) {
            for (int i = 0; i < in.getNEntries(); ++i) {
                long lsn = in.getLsn(i);
                Node node = in.getTarget(i);
                if (in.isEntryPendingDeleted(i) || in.isEntryKnownDeleted(i)) {
                    LN ln;
                    if (!(node instanceof LN) || !(ln = (LN)node).isDirty()) continue;
                    this.callback.processDirtyDeletedLN(lsn, ln, in.getKey(i));
                    continue;
                }
                if (accumulate && node == null && lsn != -1L) {
                    if (this.accumulatedLSNFileNumbers == null) {
                        this.accumulatedLSNFileNumbers = new OffsetList();
                        this.accumulatedLSNFileOffsets = new OffsetList();
                    }
                    this.accumulatedLSNFileNumbers.add(DbLsn.getFileNumber(lsn), false);
                    this.accumulatedLSNFileOffsets.add(DbLsn.getFileOffset(lsn), false);
                    this.addToLsnINMap(lsn, in, i);
                    continue;
                }
                if (lsn == -1L && !this.passNullLSNNodes) continue;
                byte[] lnKey = (byte[])(node == null || node instanceof LN ? in.getKey(i) : null);
                this.callProcessLSNHandleExceptions(lsn, node == null ? LogEntryType.LOG_LN : node.getLogType(), node, lnKey);
                if (!(node instanceof IN)) continue;
                IN nodeAsIN = (IN)node;
                try {
                    nodeAsIN.latch(CacheMode.UNCHANGED);
                    this.accumulateLSNs(nodeAsIN);
                    continue;
                }
                finally {
                    nodeAsIN.releaseLatch();
                }
            }
        }
        if (isDINRoot) {
            DIN din = (DIN)in;
            ChildReference dupCountLNRef = din.getDupCountLNRef();
            long lsn = dupCountLNRef.getLsn();
            if (lsn == -1L) {
                DupCountLN dcl = din.getDupCountLN();
                this.callback.processDupCount(dcl.getDupCount());
            } else {
                this.addToLsnINMap(lsn, in, -1);
                Node node = this.fetchLSNHandleExceptions(lsn, this.lnKeyEntry);
                if (node != null) {
                    this.callProcessLSNHandleExceptions(lsn, LogEntryType.LOG_DUPCOUNTLN, node, dupCountLNRef.getKey());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAndProcessLSN(long lsn) throws DatabaseException {
        this.lnKeyEntry.setData(null);
        Node node = this.fetchLSNHandleExceptions(lsn, this.lnKeyEntry);
        if (node == null) {
            return;
        }
        boolean isIN = node instanceof IN;
        IN in = null;
        try {
            if (isIN) {
                in = (IN)node;
                in.latch(CacheMode.UNCHANGED);
            }
            if (node != null) {
                this.callProcessLSNHandleExceptions(lsn, node.getLogType(), node, this.lnKeyEntry.getData());
                if (isIN) {
                    this.accumulateLSNs(in);
                }
            }
        }
        finally {
            if (isIN) {
                in.releaseLatch();
            }
        }
    }

    private Node fetchLSNHandleExceptions(long lsn, DatabaseEntry lnKeyEntry) {
        DatabaseException dbe;
        block7: {
            dbe = null;
            try {
                return this.fetchLSN(lsn, lnKeyEntry);
            }
            catch (FileNotFoundException e) {
                if (this.excPredicate == null || !this.excPredicate.ignoreException(e)) {
                    dbe = new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
                }
            }
            catch (DatabaseException e) {
                if (this.excPredicate != null && this.excPredicate.ignoreException(e)) break block7;
                dbe = e;
            }
        }
        if (dbe != null) {
            if (this.savedExceptions != null) {
                this.savedExceptions.add(dbe);
            } else {
                throw dbe;
            }
        }
        return null;
    }

    private void callProcessLSNHandleExceptions(long childLSN, LogEntryType childType, Node theNode, byte[] lnKey) {
        DatabaseException dbe;
        block7: {
            dbe = null;
            try {
                this.callback.processLSN(childLSN, childType, theNode, lnKey);
            }
            catch (FileNotFoundException e) {
                if (this.excPredicate == null || !this.excPredicate.ignoreException(e)) {
                    dbe = new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
                }
            }
            catch (DatabaseException e) {
                if (this.excPredicate != null && this.excPredicate.ignoreException(e)) break block7;
                dbe = e;
            }
        }
        if (dbe != null) {
            if (this.savedExceptions != null) {
                this.savedExceptions.add(dbe);
            } else {
                throw dbe;
            }
        }
    }

    protected IN getRootIN(long rootLsn) throws DatabaseException {
        return (IN)this.envImpl.getLogManager().getEntryHandleFileNotFound(rootLsn);
    }

    protected IN getResidentRootIN() throws DatabaseException {
        return this.dbImpl.getTree().getResidentRootIN(false);
    }

    protected void releaseRootIN(IN ignore) {
    }

    protected void addToLsnINMap(Long lsn, IN in, int index) {
    }

    protected Node fetchLSN(long lsn, DatabaseEntry lnKeyEntry) throws FileNotFoundException, DatabaseException {
        LogEntry entry = this.envImpl.getLogManager().getLogEntry(lsn);
        if (entry instanceof LNLogEntry) {
            lnKeyEntry.setData(((LNLogEntry)entry).getKey());
        }
        return (Node)entry.getMainItem();
    }

    public List<DatabaseException> getSavedExceptions() {
        return this.savedExceptions;
    }

    public static interface ExceptionPredicate {
        public boolean ignoreException(Exception var1);
    }

    public static interface TreeNodeProcessor {
        public void processLSN(long var1, LogEntryType var3, Node var4, byte[] var5) throws FileNotFoundException, DatabaseException;

        public void processDirtyDeletedLN(long var1, LN var3, byte[] var4) throws DatabaseException;

        public void processDupCount(int var1);
    }
}

