/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.UintMap;

class InterpreterData
implements Serializable {
    static final long serialVersionUID = 4815333329084415557L;
    static final int INITIAL_MAX_ICODE_LENGTH = 1024;
    static final int INITIAL_STRINGTABLE_SIZE = 64;
    static final int INITIAL_NUMBERTABLE_SIZE = 64;
    String itsName;
    String itsSource;
    String itsSourceFile;
    boolean itsNeedsActivation;
    boolean itsFromEvalCode;
    boolean itsUseDynamicScope;
    boolean itsCheckThis;
    byte itsFunctionType;
    String[] itsStringTable;
    int itsStringTableIndex;
    double[] itsDoubleTable;
    int itsDoubleTableIndex;
    InterpretedFunction[] itsNestedFunctions;
    Object[] itsRegExpLiterals;
    byte[] itsICode;
    int itsICodeTop;
    int itsMaxLocals;
    int itsMaxArgs;
    int itsMaxStack;
    int itsMaxTryDepth;
    UintMap itsLineNumberTable;
    Object securityDomain;

    InterpreterData(int n, int n2, Object object, boolean bl, boolean bl2) {
        this.itsICodeTop = n == 0 ? 1024 : n * 2;
        this.itsICode = new byte[this.itsICodeTop];
        this.itsStringTable = new String[n2 == 0 ? 64 : n2 * 2];
        this.itsUseDynamicScope = bl;
        this.itsCheckThis = bl2;
        if (object == null) {
            Context.checkSecurityDomainRequired();
        }
        this.securityDomain = object;
    }

    public boolean placeBreakpoint(int n) {
        int n2 = this.getOffset(n);
        if (n2 != -1 && (this.itsICode[n2] == -109 || this.itsICode[n2] == -107)) {
            this.itsICode[n2] = -107;
            return true;
        }
        return false;
    }

    public boolean removeBreakpoint(int n) {
        int n2 = this.getOffset(n);
        if (n2 != -1 && this.itsICode[n2] == -107) {
            this.itsICode[n2] = -109;
            return true;
        }
        return false;
    }

    private int getOffset(int n) {
        int n2 = this.itsLineNumberTable.getInt(n, -1);
        if (0 <= n2 && n2 <= this.itsICode.length) {
            return n2;
        }
        return -1;
    }
}

