/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.examples.wc;

import javax.swing.JTextArea;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class UpdateEventHandler
extends Thread
implements ISVNEventHandler,
Runnable {
    JTextArea messageArea = new JTextArea();
    String localDirectory;
    String extensionName;

    public UpdateEventHandler(JTextArea messgaeTextArea, String dir, String extensionName) {
        this.messageArea = messgaeTextArea;
        this.messageArea.setEditable(false);
        this.messageArea.setLineWrap(true);
        this.messageArea.setWrapStyleWord(true);
        this.localDirectory = dir;
        this.extensionName = extensionName;
    }

    public UpdateEventHandler() {
    }

    public void handleEvent(SVNEvent event, double progress) {
        SVNEventAction action = event.getAction();
        String pathChangeType = " ";
        if (action == SVNEventAction.UPDATE_ADD) {
            pathChangeType = "A";
        } else if (action == SVNEventAction.UPDATE_DELETE) {
            pathChangeType = "D";
        } else if (action == SVNEventAction.UPDATE_UPDATE) {
            SVNStatusType contentsStatus = event.getContentsStatus();
            if (contentsStatus == SVNStatusType.CHANGED) {
                pathChangeType = "U";
            } else if (contentsStatus == SVNStatusType.CONFLICTED) {
                pathChangeType = "C";
            } else if (contentsStatus == SVNStatusType.MERGED) {
                pathChangeType = "G";
            }
        } else {
            if (action == SVNEventAction.UPDATE_EXTERNAL) {
                System.out.println("Fetching external item into '" + event.getFile().getAbsolutePath() + "'");
                System.out.println("External at revision " + event.getRevision());
                return;
            }
            if (action == SVNEventAction.UPDATE_COMPLETED) {
                this.messageArea.append("At revision " + event.getRevision() + "\n");
                this.messageArea.append("The extension (" + this.extensionName + ") has been downloaded to the local folder: " + this.localDirectory + "\n");
                this.messageArea.setSelectionEnd(this.messageArea.getDocument().getLength());
                return;
            }
            if (action == SVNEventAction.ADD) {
                System.out.println("A     " + event.getURL().getPath());
                return;
            }
            if (action == SVNEventAction.DELETE) {
                System.out.println("D     " + event.getURL().getPath());
                return;
            }
            if (action == SVNEventAction.LOCKED) {
                System.out.println("L     " + event.getURL().getPath());
                return;
            }
            if (action == SVNEventAction.LOCK_FAILED) {
                System.out.println("failed to lock    " + event.getURL().getPath());
                return;
            }
        }
        SVNStatusType propertiesStatus = event.getPropertiesStatus();
        String propertiesChangeType = " ";
        if (propertiesStatus == SVNStatusType.CHANGED) {
            propertiesChangeType = "U";
        } else if (propertiesStatus == SVNStatusType.CONFLICTED) {
            propertiesChangeType = "C";
        } else if (propertiesStatus == SVNStatusType.MERGED) {
            propertiesChangeType = "G";
        }
        String lockLabel = " ";
        SVNStatusType lockType = event.getLockStatus();
        if (lockType == SVNStatusType.LOCK_UNLOCKED) {
            lockLabel = "B";
        }
        String content = String.valueOf(pathChangeType) + propertiesChangeType + lockLabel + "       " + event.getURL().getPath() + "\n";
        this.messageArea.append(content);
        this.messageArea.setSelectionEnd(this.messageArea.getDocument().getLength());
    }

    public void checkCancelled() throws SVNCancelException {
    }
}

