/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.services.security.modules;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.common.service.security.AbstractWebswingUser;
import org.webswing.server.common.service.security.AuthenticatedWebswingUser;
import org.webswing.server.services.security.api.LoginResponseClosedException;
import org.webswing.server.services.security.api.WebswingAuthenticationException;
import org.webswing.server.services.security.api.WebswingSecurityModule;
import org.webswing.server.services.security.api.WebswingSecurityModuleConfig;

public abstract class AbstractSecurityModule<T extends WebswingSecurityModuleConfig>
implements WebswingSecurityModule {
    public static final String REDIRECT_URL = "redirectUrl";
    public static final String SUCCESS_URL = "successUrl";
    private static final Logger log = LoggerFactory.getLogger(AbstractSecurityModule.class);
    private static final String LOGIN_REQUEST_MSG = "LoginRequestMsg";
    private static final String USER_VAR_PREFIX = "user";
    private final T config;

    public AbstractSecurityModule(T config) {
        this.config = config;
        this.getConfig().getContext().setTemplateResolver(resourceName -> {
            URL url = this.findTemplate(resourceName);
            if (url != null) {
                try {
                    InputStream is = url.openStream();
                    return new InputStreamReader(is);
                }
                catch (IOException e) {
                    log.error("Failed to open Template from url:" + url);
                }
            }
            return null;
        });
    }

    public T getConfig() {
        return this.config;
    }

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
        this.getConfig().getContext().clearTemplateCache();
    }

    @Override
    public AuthenticatedWebswingUser doLogin(HttpServletRequest request, HttpServletResponse response, String securedPath) throws IOException {
        try {
            Map<String, Object> msg = this.getLoginRequest(request);
            if (msg != null) {
                this.config.getContext().setToSecuritySession(LOGIN_REQUEST_MSG, msg);
            }
            this.preVerify(request, response);
            AuthenticatedWebswingUser user = this.authenticate(request);
            if (user != null) {
                this.postVerify(user, request, response);
                user = this.decorateUser(user, request, response);
                this.onAuthenticationSuccess(user, request, response, securedPath);
                return user;
            }
            this.onAuthenticationFailed(request, response, null);
        }
        catch (WebswingAuthenticationException e) {
            this.onAuthenticationFailed(request, response, e);
        }
        catch (LoginResponseClosedException e) {
            return null;
        }
        return null;
    }

    @Override
    public void doLogout(HttpServletRequest req, HttpServletResponse res, AbstractWebswingUser user) throws ServletException, IOException {
        this.doLogout(req, res);
    }

    public void doLogout(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String logoutURL = this.getConfig().getContext().replaceVariables(this.getConfig().getLogoutUrl());
        String fullPath = this.getConfig().getContext().getSecuredPath();
        this.sendRedirect(req, res, StringUtils.isEmpty(logoutURL) ? fullPath : logoutURL);
    }

    public void logoutRedirect(HttpServletRequest request, HttpServletResponse response, String logoutUrl) throws IOException {
        if (logoutUrl != null) {
            this.sendRedirect(request, response, logoutUrl);
        } else {
            this.sendPartialHtml(request, response, "logoutPartial.html", null);
        }
    }

    @Override
    public void doServeAuthenticated(AbstractWebswingUser user, String path, HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.setStatus(200);
        res.setHeader("webswingUsername", user.getUserId());
        this.serveAuthenticated(user, path, req, res);
    }

    protected void serveAuthenticated(AbstractWebswingUser user, String path, HttpServletRequest req, HttpServletResponse res) {
    }

    protected AuthenticatedWebswingUser decorateUser(AuthenticatedWebswingUser user, HttpServletRequest request, HttpServletResponse response) {
        return user;
    }

    protected void postVerify(AuthenticatedWebswingUser user, HttpServletRequest request, HttpServletResponse response) throws LoginResponseClosedException, WebswingAuthenticationException {
    }

    protected void preVerify(HttpServletRequest request, HttpServletResponse response) throws LoginResponseClosedException, WebswingAuthenticationException {
    }

    protected abstract AuthenticatedWebswingUser authenticate(HttpServletRequest var1) throws WebswingAuthenticationException;

    protected void onAuthenticationSuccess(AuthenticatedWebswingUser user, HttpServletRequest request, HttpServletResponse response, String securedPath) throws IOException {
        response.setStatus(200);
        response.setHeader("webswingUsername", user.getUserId());
        this.getConfig().getContext().loginUser(user, response, securedPath);
        if (!this.isAjax(request)) {
            Map<String, Object> msg = this.getLoginRequest(request);
            if (msg != null && msg.containsKey(SUCCESS_URL)) {
                this.sendRedirect(request, response, (String)msg.get(SUCCESS_URL));
            } else {
                String defaultPath = this.config.getContext().getSecuredPath();
                this.sendRedirect(request, response, defaultPath);
            }
        }
    }

    protected void onAuthenticationFailed(HttpServletRequest request, HttpServletResponse response, WebswingAuthenticationException exception) throws IOException {
        response.setStatus(401);
        this.getConfig().getContext().saveLoginSession(response);
        if (this.isAjax(request)) {
            this.serveLoginPartial(request, response, exception);
        } else {
            this.serveLoginPage(request, response, exception);
        }
    }

    protected void serveLoginPage(HttpServletRequest request, HttpServletResponse response, WebswingAuthenticationException exception) throws IOException {
        this.serveLoginPartial(request, response, exception);
    }

    protected abstract void serveLoginPartial(HttpServletRequest var1, HttpServletResponse var2, WebswingAuthenticationException var3) throws IOException;

    protected boolean isAjax(HttpServletRequest request) {
        String requestedWithHeader = request.getHeader("X-Requested-With");
        return requestedWithHeader != null && requestedWithHeader.equals("XMLHttpRequest");
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        if (this.isAjax(request)) {
            HashMap<String, Object> message = new HashMap<String, Object>();
            message.put(REDIRECT_URL, url);
            try {
                this.getConfig().getContext().writeJson(response.getOutputStream(), message);
            }
            catch (Exception e) {
                throw new IOException("Failed to send login redirect message", e);
            }
        } else {
            this.getConfig().getContext().sendHttpRedirect(request, response, url);
        }
    }

    protected void sendHtml(HttpServletRequest request, HttpServletResponse response, String template, Object variables) throws IOException {
        Object[] extendedVars = new Object[]{variables, this.getDefaultVariables(request)};
        if (this.isAjax(request)) {
            HashMap<String, Object> message = new HashMap<String, Object>();
            try {
                StringWriter w = new StringWriter();
                this.getConfig().getContext().processTemplate(w, template, extendedVars);
                message.put("partialHtml", ((Object)w).toString());
                this.getConfig().getContext().writeJson(response.getOutputStream(), message);
            }
            catch (Exception e) {
                throw new IOException("Failed to send login template message", e);
            }
        } else {
            response.setContentType("text/html");
            OutputStreamWriter w = new OutputStreamWriter(response.getOutputStream());
            this.getConfig().getContext().processTemplate(w, template, extendedVars);
        }
    }

    protected void sendPartialHtml(HttpServletRequest request, HttpServletResponse response, String template, Object variables) throws IOException {
        Map<String, String> defaultVars = this.getDefaultVariables(request);
        Object[] extendedVars = new Object[]{variables, defaultVars};
        if (this.isAjax(request)) {
            this.sendHtml(request, response, template, variables);
        } else {
            response.setContentType("text/html;charset=UTF-8");
            OutputStreamWriter w = new OutputStreamWriter(response.getOutputStream());
            StringWriter tempw = new StringWriter();
            this.getConfig().getContext().processTemplate(tempw, template, extendedVars);
            defaultVars.put("partialHtml", new String(Base64.getEncoder().encode(((Object)tempw).toString().getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
            this.getConfig().getContext().processTemplate(w, "default.html", extendedVars);
        }
    }

    private Map<String, String> getDefaultVariables(HttpServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("requestBaseUrl", this.getBaseUrl(request));
        return result;
    }

    private String getBaseUrl(HttpServletRequest req) {
        String host;
        String proto = req.getHeader("X-Forwarded-Proto");
        if (proto == null) {
            String string = proto = req.getRequestURL().toString().startsWith("https") ? "https" : "http";
        }
        if ((host = req.getHeader("X-Forwarded-Host")) == null) {
            host = req.getServerName();
            int port = req.getServerPort();
            if (port != 80 && port != 443) {
                host = host + ":" + port;
            }
        }
        String result = proto + "://" + host + this.config.getContext().getSecuredPath();
        return result;
    }

    public Map<String, Object> getLoginRequest(HttpServletRequest request) {
        if (this.isAjax(request) && "application/json".equals(request.getContentType())) {
            try {
                if (request.getAttribute(LOGIN_REQUEST_MSG) == null) {
                    Map<String, Object> loginRequest = this.getConfig().getContext().readJson(request.getReader());
                    request.setAttribute(LOGIN_REQUEST_MSG, loginRequest);
                }
                return (Map)request.getAttribute(LOGIN_REQUEST_MSG);
            }
            catch (Exception e) {
                log.debug("Failed to read login request data.", e);
            }
        }
        return (Map)this.getConfig().getContext().getFromSecuritySession(LOGIN_REQUEST_MSG);
    }

    public void logSuccess(HttpServletRequest r, String user) {
        String path = this.getConfig().getContext().getSecuredPath();
        path = StringUtils.isEmpty(path) ? "/" : path;
        String module = this.getClass().getName();
        this.auditLog("SUCCESS", r, path, module, user, "");
    }

    public void logFailure(HttpServletRequest r, String user, String reason) {
        String path = this.getConfig().getContext().getSecuredPath();
        path = StringUtils.isEmpty(path) ? "/" : path;
        String module = this.getClass().getName();
        this.auditLog("FAILED", r, path, module, user, reason);
    }

    public URL findTemplate(String name) {
        URL url = this.getConfig().getContext().getWebResource(name);
        if (url == null) {
            url = this.getClass().getClassLoader().getResource(name);
        }
        return url;
    }

    public String replaceVar(String s) {
        return this.getConfig().getContext().replaceVariables(s);
    }

    public String replaceVar(String s, AbstractWebswingUser user) {
        if (user != null) {
            HashMap<String, String> userVars = new HashMap<String, String>();
            userVars.put(USER_VAR_PREFIX, user.getUserId());
            Map<String, Serializable> attrs = user.getUserAttributes();
            if (attrs != null) {
                for (Map.Entry<String, Serializable> e : attrs.entrySet()) {
                    try {
                        userVars.put("user." + e.getKey(), e.getValue().toString());
                    }
                    catch (Exception exception) {}
                }
            }
            return this.getConfig().getContext().replaceVariables(s, userVars);
        }
        return this.replaceVar(s);
    }

    public void auditLog(String status, HttpServletRequest r, String path, String module, String username, String reason) {
        String protocol = r.getScheme();
        String ipAddress = r.getHeader("X-FORWARDED-FOR");
        if (ipAddress == null) {
            ipAddress = r.getRemoteAddr();
        }
        this.getConfig().getContext().logUserLogin("SUCCESS".equals(status), ipAddress, protocol, path, module, username, reason);
    }
}

