/*
 * Decompiled with CFR 0.152.
 */
package org.webswing.server.common.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webswing.server.common.model.Config;
import org.webswing.server.common.model.meta.ConfigContext;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueBoolean;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueGenerator;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueNumber;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueObject;
import org.webswing.server.common.model.meta.ConfigFieldDefaultValueString;
import org.webswing.server.common.model.meta.MetaObject;
import org.webswing.server.common.model.meta.MetadataGenerator;

public class ConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(ConfigUtil.class);

    public static MetaObject getConfigMetadata(Object o, ClassLoader cl, ConfigContext ctx) throws Exception {
        MetadataGenerator<Object> generator = new MetadataGenerator<Object>();
        generator.setContext(ctx);
        return generator.getMetadata(o, cl);
    }

    public static <T> T instantiateConfig(Map<String, Object> c, final Class<T> clazz, final Object ... context) {
        if (c == null) {
            c = new HashMap<String, Object>();
        }
        final Map<String, Object> config = c;
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                BeanInfo info = Introspector.getBeanInfo(method.getDeclaringClass());
                PropertyDescriptor[] pds = info.getPropertyDescriptors();
                if (method.getName().equals("getValueAs") && method.getParameterTypes().length == 2 && args[0] instanceof String && args[1] instanceof Class) {
                    String s = (String)args[0];
                    Class c = (Class)args[1];
                    Object o = config.get(s);
                    Map subConfig = (Map)(o != null && o instanceof HashMap ? o : new HashMap());
                    return ConfigUtil.instantiateConfig(subConfig, c, context);
                }
                if (method.getName().equals("asMap") && method.getParameterTypes().length == 0) {
                    return config;
                }
                for (PropertyDescriptor pd : pds) {
                    ConfigFieldDefaultValueObject defaultObject;
                    if (!pd.getReadMethod().equals(method)) continue;
                    for (Object o : context) {
                        if (!method.getReturnType().isAssignableFrom(o.getClass())) continue;
                        return o;
                    }
                    Object value = config.get(pd.getName());
                    if (value != null) {
                        if (ClassUtils.isAssignable(value.getClass(), method.getReturnType(), true)) {
                            Class generic;
                            if (value instanceof Map && (generic = ConfigUtil.getGenericClass(method.getGenericReturnType(), 1)) != null && generic.isInterface()) {
                                Map valueMap = (Map)value;
                                HashMap resultMap = new HashMap();
                                for (Object key : valueMap.keySet()) {
                                    Object entryValue = valueMap.get(key);
                                    resultMap.put(key, ConfigUtil.instantiateConfig((Map)entryValue, generic, context));
                                }
                                return resultMap;
                            }
                            if (value instanceof List && (generic = ConfigUtil.getGenericClass(method.getGenericReturnType(), 0)) != null && generic.isInterface()) {
                                List valuelist = (List)value;
                                ArrayList resultList = new ArrayList();
                                for (Object item : valuelist) {
                                    resultList.add(ConfigUtil.instantiateConfig((Map)item, generic, context));
                                }
                                return resultList;
                            }
                            if (value instanceof Number) {
                                return ConfigUtil.convertNumberToTargetClass((Number)value, method.getReturnType());
                            }
                            return value;
                        }
                        if (ClassUtils.isAssignable(value.getClass(), Number.class, true) && ClassUtils.isAssignable(method.getReturnType(), Number.class, true)) {
                            return ConfigUtil.convertNumberToTargetClass((Number)value, method.getReturnType());
                        }
                        if (value instanceof Map && method.getReturnType().isInterface() && !Collection.class.isAssignableFrom(method.getReturnType())) {
                            return ConfigUtil.instantiateConfig((Map)value, method.getReturnType(), context);
                        }
                        if (value instanceof String && method.getReturnType().isEnum()) {
                            try {
                                return Enum.valueOf(method.getReturnType(), (String)value);
                            }
                            catch (Exception e) {
                                return null;
                            }
                        }
                        log.error("Invalid configuration. Type of " + clazz.getName() + "." + pd.getName() + " is not " + method.getReturnType());
                        return null;
                    }
                    Class<?> returnType = method.getReturnType();
                    Object generated = ConfigUtil.getDefaultGeneratedValue(method, clazz, proxy);
                    if (generated != null && ClassUtils.isAssignable(generated.getClass(), returnType)) {
                        return generated;
                    }
                    if (ClassUtils.isAssignable(returnType, String.class)) {
                        String defaultStringValue = ConfigUtil.getDefaultStringValue(method);
                        config.put(pd.getName(), defaultStringValue);
                        return defaultStringValue;
                    }
                    if (ClassUtils.isAssignable(returnType, Enum.class)) {
                        String enumName = ConfigUtil.getDefaultStringValue(method);
                        if (enumName != null) {
                            config.put(pd.getName(), enumName);
                            return Enum.valueOf(returnType, enumName);
                        }
                        return null;
                    }
                    if (ClassUtils.isAssignable(returnType, Number.class)) {
                        Double number = ConfigUtil.getDefaultNumberValue(method);
                        Number converted = ConfigUtil.convertNumberToTargetClass(number, returnType);
                        config.put(pd.getName(), converted);
                        return converted;
                    }
                    if (ClassUtils.isAssignable(returnType, Boolean.class)) {
                        Boolean bool = ConfigUtil.getDefaultBooleanValue(method);
                        config.put(pd.getName(), bool);
                        return bool;
                    }
                    if (ClassUtils.isAssignable(returnType, Config.class) && (defaultObject = ConfigUtil.isDefaultObjectValue(method)) != null) {
                        config.put(pd.getName(), new HashMap());
                        return ConfigUtil.instantiateConfig(null, returnType, context);
                    }
                    if (!ClassUtils.isAssignable(returnType, Object.class) || (defaultObject = ConfigUtil.isDefaultObjectValue(method)) == null) continue;
                    Object newInstance = null;
                    newInstance = Void.class.equals(defaultObject.value()) ? (Object)returnType.newInstance() : (Object)defaultObject.value().newInstance();
                    config.put(pd.getName(), newInstance);
                    return newInstance;
                }
                return null;
            }
        });
    }

    protected static <T> Object getDefaultGeneratedValue(Method method, Class<?> currentConfigType, Object currentConfig) {
        ConfigFieldDefaultValueGenerator defaultGeneratorAnnotation = ConfigUtil.findAnnotation(method, ConfigFieldDefaultValueGenerator.class);
        if (defaultGeneratorAnnotation != null) {
            String methodName = defaultGeneratorAnnotation.value();
            try {
                Method m = method.getDeclaringClass().getDeclaredMethod(methodName, currentConfigType);
                Object value = m.invoke(null, currentConfig);
                return value;
            }
            catch (Exception e) {
                log.error("Default Value Generator method '" + methodName + "' is not valid.", e);
            }
        }
        return null;
    }

    protected static ConfigFieldDefaultValueObject isDefaultObjectValue(Method method) {
        ConfigFieldDefaultValueObject defaultObjectAnnotation = ConfigUtil.findAnnotation(method, ConfigFieldDefaultValueObject.class);
        return defaultObjectAnnotation;
    }

    protected static Boolean getDefaultBooleanValue(Method method) {
        ConfigFieldDefaultValueBoolean bool = ConfigUtil.findAnnotation(method, ConfigFieldDefaultValueBoolean.class);
        if (bool != null) {
            return bool.value();
        }
        return null;
    }

    protected static Double getDefaultNumberValue(Method method) {
        ConfigFieldDefaultValueNumber defaultString = ConfigUtil.findAnnotation(method, ConfigFieldDefaultValueNumber.class);
        if (defaultString != null) {
            return defaultString.value();
        }
        return null;
    }

    protected static String getDefaultStringValue(Method method) {
        ConfigFieldDefaultValueString defaultString = ConfigUtil.findAnnotation(method, ConfigFieldDefaultValueString.class);
        if (defaultString != null) {
            return defaultString.value();
        }
        return null;
    }

    private static Class<?> getGenericClass(Type genericType, int index) {
        Type[] generics;
        if (genericType instanceof ParameterizedType && (generics = ((ParameterizedType)genericType).getActualTypeArguments()) != null && generics[index] instanceof Class) {
            return (Class)generics[index];
        }
        return null;
    }

    public static Number convertNumberToTargetClass(Number number, Class targetClass) throws IllegalArgumentException {
        if (number == null) {
            return null;
        }
        if (targetClass.isInstance(number)) {
            return number;
        }
        if (targetClass.equals(Short.class) || targetClass.equals(Short.TYPE)) {
            long value = number.longValue();
            if (value < -32768L || value > 32767L) {
                ConfigUtil.raiseOverflowException(number, targetClass);
            }
            return number.shortValue();
        }
        if (targetClass.equals(Integer.class) || targetClass.equals(Integer.TYPE)) {
            long value = number.longValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                ConfigUtil.raiseOverflowException(number, targetClass);
            }
            return number.intValue();
        }
        if (targetClass.equals(Long.class) || targetClass.equals(Long.TYPE)) {
            return number.longValue();
        }
        if (targetClass.equals(Float.class) || targetClass.equals(Float.TYPE)) {
            return Float.valueOf(number.floatValue());
        }
        if (targetClass.equals(Double.class) || targetClass.equals(Double.TYPE)) {
            return number.doubleValue();
        }
        if (targetClass.equals(BigInteger.class)) {
            return BigInteger.valueOf(number.longValue());
        }
        if (targetClass.equals(BigDecimal.class)) {
            return new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unknown target class [" + targetClass.getName() + "]");
    }

    private static void raiseOverflowException(Number number, Class targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }

    public static <T extends Annotation> T findAnnotation(Method readMethod, Class<T> ann) {
        T annotation = readMethod.getAnnotation(ann);
        if (annotation != null) {
            return annotation;
        }
        Set<Method> overrideHierarchy = MethodUtils.getOverrideHierarchy(readMethod, ClassUtils.Interfaces.INCLUDE);
        for (Method m : overrideHierarchy) {
            annotation = m.getAnnotation(ann);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }
}

