/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.LogLevelEvent;
import de.qfs.lib.log.LogLevelListener;
import de.qfs.lib.log.Logger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class LogLevels {
    private Node root = new Node("", null, new Integer(4));
    private Vector listeners = new Vector();
    private LogLevelListener[] _listeners = new LogLevelListener[0];
    private LogLevelThread logLevelThread = new LogLevelThread();

    public void setDefaultLogLevel(int n) {
        this.setDefaultLogLevelImpl(this, n);
    }

    public void setLogLevel(String string, int n) {
        if (string.length() == 0) {
            this.setDefaultLogLevelImpl(this, n);
        } else {
            this.setLogLevelImpl(this, string, n);
        }
    }

    public void removeLogLevel(String string) {
        if (string.length() == 0) {
            this.setDefaultLogLevelImpl(this, 4);
        } else {
            this.removeLogLevelImpl(this, string);
        }
    }

    public synchronized int getLogLevel(Logger logger) {
        String string = logger.getOwnerName();
        Node[] nodeArray = this.root.findNodeAndParent(string);
        if (nodeArray[0] == null) {
            nodeArray[0] = new Node(string, logger, null);
            nodeArray[1].addChild(nodeArray[0]);
            this.logLevelThread.classAdded(this, nodeArray[0].name);
        } else {
            nodeArray[0].logger = logger;
        }
        return nodeArray[0].level != null ? nodeArray[0].level.intValue() : nodeArray[1].level.intValue();
    }

    public synchronized void addLogLevelListener(LogLevelListener logLevelListener) {
        if (logLevelListener == null) {
            Thread.currentThread();
            Thread.dumpStack();
        }
        if (!this.listeners.contains(logLevelListener)) {
            this.listeners.addElement(logLevelListener);
            this._listeners = new LogLevelListener[this.listeners.size()];
            this.listeners.copyInto(this._listeners);
        }
    }

    public synchronized void removeLogLevelListener(LogLevelListener logLevelListener) {
        this.listeners.removeElement(logLevelListener);
        this._listeners = new LogLevelListener[this.listeners.size()];
        this.listeners.copyInto(this._listeners);
    }

    private void fireClassAdded(LogLevelEvent logLevelEvent) {
        LogLevelListener[] logLevelListenerArray = this._listeners;
        int n = 0;
        while (n < logLevelListenerArray.length) {
            if (!logLevelListenerArray[n].equals(logLevelEvent.getSource())) {
                logLevelListenerArray[n].classAdded(logLevelEvent);
            }
            ++n;
        }
    }

    private void fireLevelChanged(LogLevelEvent logLevelEvent) {
        LogLevelListener[] logLevelListenerArray = this._listeners;
        int n = 0;
        while (n < logLevelListenerArray.length) {
            if (!logLevelListenerArray[n].equals(logLevelEvent.getSource())) {
                logLevelListenerArray[n].levelChanged(logLevelEvent);
            }
            ++n;
        }
    }

    private void fireLevelRemoved(LogLevelEvent logLevelEvent) {
        LogLevelListener[] logLevelListenerArray = this._listeners;
        int n = 0;
        while (n < logLevelListenerArray.length) {
            if (!logLevelListenerArray[n].equals(logLevelEvent.getSource())) {
                logLevelListenerArray[n].levelRemoved(logLevelEvent);
            }
            ++n;
        }
    }

    public Object[] getLogLevels() {
        Vector vector = new Vector();
        this.root.fillList(vector);
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setLogLevel(LogLevelListener logLevelListener, String string, int n) {
        if (string.length() == 0) {
            this.setDefaultLogLevelImpl(logLevelListener, n);
        } else {
            this.setLogLevelImpl(logLevelListener, string, n);
        }
    }

    public void removeLogLevel(LogLevelListener logLevelListener, String string) {
        if (string.length() == 0) {
            this.setDefaultLogLevelImpl(logLevelListener, 4);
        } else {
            this.removeLogLevelImpl(logLevelListener, string);
        }
    }

    private synchronized void setDefaultLogLevelImpl(Object object, int n) {
        this.root.setLevelAndUpdate(n);
        this.logLevelThread.logLevelChanged(object, "", n);
    }

    private synchronized void setLogLevelImpl(Object object, String string, int n) {
        Node[] nodeArray = this.root.findNodeAndParent(string);
        if (nodeArray[0] == null) {
            nodeArray[0] = new Node(string, null, null);
            nodeArray[1].addChild(nodeArray[0]);
        }
        nodeArray[0].setLevelAndUpdate(n);
        this.logLevelThread.logLevelChanged(object, nodeArray[0].name, n);
    }

    private synchronized void removeLogLevelImpl(Object object, String string) {
        Node[] nodeArray = this.root.findNodeAndParent(string);
        if (nodeArray[0] == null) {
            return;
        }
        if (nodeArray[0].logger != null) {
            nodeArray[0].unsetLevelAndUpdate(nodeArray[1].level);
        } else {
            nodeArray[1].removeChild(nodeArray[0]);
        }
        this.logLevelThread.logLevelRemoved(object, nodeArray[0].name);
    }

    private class LogLevelThread
    extends Thread {
        private Hashtable added = new Hashtable();
        private Vector changed = new Vector();
        private Vector removed = new Vector();

        public LogLevelThread() {
            super("LogLevelThread");
            this.setPriority(4);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (true) {
                LogLevelEvent logLevelEvent = null;
                LogLevelEvent logLevelEvent2 = null;
                LogLevelEvent logLevelEvent3 = null;
                LogLevelThread logLevelThread = this;
                // MONITORENTER : logLevelThread
                while (this.added.isEmpty() && this.changed.isEmpty() && this.removed.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.removed.isEmpty()) {
                    logLevelEvent = (LogLevelEvent)this.removed.elementAt(0);
                    this.removed.removeElementAt(0);
                } else if (!this.changed.isEmpty()) {
                    logLevelEvent2 = (LogLevelEvent)this.changed.elementAt(0);
                    this.changed.removeElementAt(0);
                } else if (!this.added.isEmpty()) {
                    Object k = this.added.keys().nextElement();
                    Vector vector = (Vector)this.added.remove(k);
                    Object[] objectArray = new String[vector.size()];
                    vector.copyInto(objectArray);
                    logLevelEvent3 = new LogLevelEvent(k, (String[])objectArray);
                }
                // MONITOREXIT : logLevelThread
                if (logLevelEvent != null) {
                    LogLevels.this.fireLevelRemoved(logLevelEvent);
                    logLevelEvent = null;
                    continue;
                }
                if (logLevelEvent2 != null) {
                    LogLevels.this.fireLevelChanged(logLevelEvent2);
                    logLevelEvent2 = null;
                    continue;
                }
                if (logLevelEvent3 == null) continue;
                LogLevels.this.fireClassAdded(logLevelEvent3);
                logLevelEvent3 = null;
            }
        }

        public synchronized void classAdded(Object object, String string) {
            Vector<String> vector = (Vector<String>)this.added.get(object);
            if (vector == null) {
                vector = new Vector<String>();
                this.added.put(object, vector);
            }
            vector.addElement(string);
            this.notifyAll();
        }

        public synchronized void logLevelChanged(Object object, String string, int n) {
            this.changed.addElement(new LogLevelEvent(object, string, n));
            this.notifyAll();
        }

        public synchronized void logLevelRemoved(Object object, String string) {
            this.removed.addElement(new LogLevelEvent(object, string));
            this.notifyAll();
        }
    }

    private class Node {
        public String name;
        public Logger logger;
        public Integer level;
        public Hashtable classes;
        public Vector packages;

        public Node(String string, Logger logger, Integer n) {
            this.name = string;
            this.logger = logger;
            this.level = n;
        }

        public Node[] findNodeAndParent(String string) {
            Object object;
            if (this.classes != null && (object = (Node)this.classes.get(string)) != null) {
                return new Node[]{object, this};
            }
            if (this.packages != null) {
                object = this.packages.elements();
                while (object.hasMoreElements()) {
                    Node node = (Node)object.nextElement();
                    if (string.equals(node.name)) {
                        return new Node[]{node, this};
                    }
                    if (!string.startsWith(node.name)) continue;
                    return node.findNodeAndParent(string);
                }
            }
            return new Node[]{null, this};
        }

        public void addChild(Node node) {
            if (node.name.endsWith(".")) {
                Object object;
                if (this.classes != null) {
                    Object object2;
                    Vector<Object> vector = new Vector<Object>();
                    object = this.classes.keys();
                    while (object.hasMoreElements()) {
                        object2 = (String)object.nextElement();
                        if (!((String)object2).startsWith(node.name)) continue;
                        if (node.classes == null) {
                            node.classes = new Hashtable();
                        }
                        node.classes.put(object2, this.classes.get(object2));
                        vector.addElement(object2);
                    }
                    object2 = vector.elements();
                    while (object2.hasMoreElements()) {
                        this.classes.remove(object2.nextElement());
                    }
                }
                if (this.packages != null) {
                    int n = 0;
                    while (n < this.packages.size()) {
                        object = (Node)this.packages.elementAt(n);
                        if (((Node)object).name.startsWith(node.name)) {
                            if (node.packages == null) {
                                node.packages = new Vector();
                            }
                            this.packages.removeElementAt(n--);
                            node.packages.addElement(object);
                        }
                        ++n;
                    }
                }
                if (this.packages == null) {
                    this.packages = new Vector();
                }
                this.packages.addElement(node);
            } else {
                if (this.classes == null) {
                    this.classes = new Hashtable();
                }
                this.classes.put(node.name, node);
            }
        }

        public synchronized void removeChild(Node node) {
            if (node.name.endsWith(".")) {
                if (this.packages != null) {
                    Enumeration<Object> enumeration;
                    this.packages.removeElement(node);
                    if (node.classes != null) {
                        if (this.classes == null) {
                            this.classes = new Hashtable();
                        }
                        enumeration = node.classes.elements();
                        while (enumeration.hasMoreElements()) {
                            Node node2 = (Node)enumeration.nextElement();
                            if (node2.logger != null && node2.level == null) {
                                node2.logger.level = this.level;
                            }
                            this.classes.put(node2.name, node2);
                        }
                    }
                    if (node.packages != null) {
                        enumeration = node.packages.elements();
                        while (enumeration.hasMoreElements()) {
                            this.packages.addElement(enumeration.nextElement());
                        }
                    }
                }
            } else if (this.classes != null) {
                this.classes.remove(node.name);
            }
        }

        public void setLevelAndUpdate(int n) {
            this.level = new Integer(n);
            if (this.logger != null) {
                this.logger.level = n;
            } else if (this.classes != null) {
                Enumeration enumeration = this.classes.elements();
                while (enumeration.hasMoreElements()) {
                    Node node = (Node)enumeration.nextElement();
                    if (node.level != null || node.logger == null) continue;
                    node.logger.level = n;
                }
            }
        }

        public void unsetLevelAndUpdate(int n) {
            if (this.level != null) {
                this.level = null;
                if (this.logger != null) {
                    this.logger.level = n;
                }
            }
        }

        public void fillList(Vector vector) {
            Enumeration<Object> enumeration;
            vector.addElement(this.name);
            vector.addElement(this.level);
            if (this.packages != null) {
                enumeration = this.packages.elements();
                while (enumeration.hasMoreElements()) {
                    ((Node)enumeration.nextElement()).fillList(vector);
                }
            }
            if (this.classes != null) {
                enumeration = this.classes.elements();
                while (enumeration.hasMoreElements()) {
                    ((Node)enumeration.nextElement()).fillList(vector);
                }
            }
        }
    }
}

