/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks.util.math;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class Math {
    private boolean strict = false;
    public static Class BIGDECIMAL_TYPE;
    public static Class BIGINT_TYPE;

    public Math() {
    }

    public Math(boolean strict) {
        this.strict = strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static BigDecimal add(BigDecimal a, BigDecimal b) {
        return a.add(b);
    }

    public static BigInteger add(BigInteger a, BigInteger b) {
        return a.add(b);
    }

    public static BigInteger and(BigInteger a, BigInteger b) {
        return a.and(b);
    }

    public static int and(int a, int b) {
        return a & b;
    }

    public static BigInteger or(BigInteger a, BigInteger b) {
        return a.or(b);
    }

    public static int or(int a, int b) {
        return a | b;
    }

    public static BigInteger not(BigInteger a) {
        return a.not();
    }

    public static int not(int a) {
        return ~a;
    }

    public static BigInteger xor(BigInteger a, BigInteger b) {
        return a.xor(b);
    }

    public static int xor(int a, int b) {
        return a ^ b;
    }

    public static double add(double a, double b) {
        return a + b;
    }

    public static float add(float a, float b) {
        return a + b;
    }

    public static long add(long a, long b) {
        return a + b;
    }

    public static int add(int a, int b) {
        return a + b;
    }

    public static BigInteger add(BigInteger[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        BigInteger b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b = b.add(a[i]);
        }
        return b;
    }

    public static double add(double[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        double b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b += a[i];
        }
        return b;
    }

    public static float add(float[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        float b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b += a[i];
        }
        return b;
    }

    public static long add(long[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        long b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b += a[i];
        }
        return b;
    }

    public static int add(int[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        int b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b += a[i];
        }
        return b;
    }

    public static BigDecimal subtract(BigDecimal a, BigDecimal b) {
        return a.subtract(b);
    }

    public static BigInteger subtract(BigInteger a, BigInteger b) {
        return a.subtract(b);
    }

    public static double subtract(double a, double b) {
        return a - b;
    }

    public static float subtract(float a, float b) {
        return a - b;
    }

    public static long subtract(long a, long b) {
        return a - b;
    }

    public static int subtract(int a, int b) {
        return a - b;
    }

    public static BigDecimal subtract(BigDecimal[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        BigDecimal b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b = b.subtract(a[i]);
        }
        return b;
    }

    public static BigInteger subtract(BigInteger[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        BigInteger b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b = b.subtract(a[i]);
        }
        return b;
    }

    public static double subtract(double[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        double b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b -= a[i];
        }
        return b;
    }

    public static float subtract(float[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        float b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b -= a[i];
        }
        return b;
    }

    public static long subtract(long[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        long b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b -= a[i];
        }
        return b;
    }

    public static int subtract(int[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        int b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b -= a[i];
        }
        return b;
    }

    public static BigDecimal multiply(BigDecimal a, BigDecimal b) {
        return a.multiply(b);
    }

    public static BigInteger multiply(BigInteger a, BigInteger b) {
        return a.multiply(b);
    }

    public static double multiply(double a, double b) {
        return a * b;
    }

    public static float multiply(float a, float b) {
        return a * b;
    }

    public static long multiply(long a, long b) {
        return a * b;
    }

    public static int multiply(int a, int b) {
        return a * b;
    }

    public static BigDecimal multiply(BigDecimal[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        BigDecimal b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b = b.multiply(a[i]);
        }
        return b;
    }

    public static BigInteger multiply(BigInteger[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        BigInteger b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b = b.multiply(a[i]);
        }
        return b;
    }

    public static double multiply(double[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        double b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b *= a[i];
        }
        return b;
    }

    public static float multiply(float[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        float b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b *= a[i];
        }
        return b;
    }

    public static long multiply(long[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        long b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b *= a[i];
        }
        return b;
    }

    public static int multiply(int[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        int b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b *= a[i];
        }
        return b;
    }

    public static BigDecimal divide(BigDecimal a, BigDecimal b) {
        try {
            return a.divide(b, 6);
        }
        catch (Throwable e) {
            return a.divide(b, 6);
        }
    }

    public static BigInteger divide(BigInteger a, BigInteger b) {
        return a.divide(b);
    }

    public static double divide(double a, double b) {
        if (b == 0.0) {
            throw new ArithmeticException("/ by zero");
        }
        return a / b;
    }

    public static float divide(float a, float b) {
        if (b == 0.0f) {
            throw new ArithmeticException("/ by zero");
        }
        return a / b;
    }

    public static long divide(long a, long b) {
        if (b == 0L) {
            throw new ArithmeticException("/ by zero");
        }
        return a / b;
    }

    public static int divide(int a, int b) {
        if (b == 0) {
            throw new ArithmeticException("/ by zero");
        }
        return a / b;
    }

    public static BigDecimal divide(BigDecimal[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        BigDecimal b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b = b.divide(a[i], 6);
        }
        return b;
    }

    public static BigInteger divide(BigInteger[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        BigInteger b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b = b.divide(a[i]);
        }
        return b;
    }

    public static double divide(double[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        double b = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (a[i] == 0.0) {
                throw new ArithmeticException("/ by zero");
            }
            b /= a[i];
        }
        return b;
    }

    public static float divide(float[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        float b = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (a[i] == 0.0f) {
                throw new ArithmeticException("/ by zero");
            }
            b /= a[i];
        }
        return b;
    }

    public static long divide(long[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        long b = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (a[i] == 0L) {
                throw new ArithmeticException("/ by zero");
            }
            b /= a[i];
        }
        return b;
    }

    public static int divide(int[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        int b = a[0];
        for (int i = 1; i < a.length; ++i) {
            if (a[i] == 0) {
                throw new ArithmeticException("/ by zero");
            }
            b /= a[i];
        }
        return b;
    }

    public static BigInteger mod(BigInteger a, BigInteger b) {
        return a.mod(b);
    }

    public static double mod(double a, double b) {
        return a % b;
    }

    public static float mod(float a, float b) {
        return a % b;
    }

    public static long mod(long a, long b) {
        return a % b;
    }

    public static int mod(int a, int b) {
        return a % b;
    }

    public static BigInteger mod(BigInteger[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        BigInteger b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b = b.mod(a[i]);
        }
        return b;
    }

    public static double mod(double[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        double b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b %= a[i];
        }
        return b;
    }

    public static float mod(float[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        float b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b %= a[i];
        }
        return b;
    }

    public static long mod(long[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        long b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b %= a[i];
        }
        return b;
    }

    public static int mod(int[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        if (a.length == 1) {
            return a[0];
        }
        int b = a[0];
        for (int i = 1; i < a.length; ++i) {
            b %= a[i];
        }
        return b;
    }

    public static boolean greaterThan(int x, int y) {
        return x > y;
    }

    public static boolean greaterThan(long x, long y) {
        return x > y;
    }

    public static boolean greaterThan(double x, double y) {
        return x > y;
    }

    public static boolean greaterThan(BigInteger x, BigInteger y) {
        return x.compareTo(y) > 0;
    }

    public static boolean greaterThan(BigDecimal x, BigDecimal y) {
        return x.compareTo(y) > 0;
    }

    public static boolean lessThan(int x, int y) {
        return x < y;
    }

    public static boolean lessThan(long x, long y) {
        return x < y;
    }

    public static boolean lessThan(double x, double y) {
        return x < y;
    }

    public static boolean lessThan(BigInteger x, BigInteger y) {
        return x.compareTo(y) < 0;
    }

    public static boolean lessThan(BigDecimal x, BigDecimal y) {
        return x.compareTo(y) < 0;
    }

    public static boolean equal(int x, int y) {
        return x == y;
    }

    public static boolean equal(long x, long y) {
        return x == y;
    }

    public static boolean equal(double x, double y) {
        return x == y;
    }

    public static boolean equal(BigInteger x, BigInteger y) {
        return x.compareTo(y) == 0;
    }

    public static boolean equal(BigDecimal x, BigDecimal y) {
        return x.compareTo(y) == 0;
    }

    public static boolean notEqual(int x, int y) {
        return x != y;
    }

    public static boolean notEqual(long x, long y) {
        return x != y;
    }

    public static boolean notEqual(double x, double y) {
        return x != y;
    }

    public static boolean notEqual(BigInteger x, BigInteger y) {
        return x.compareTo(y) != 0;
    }

    public static boolean notEqual(BigDecimal x, BigDecimal y) {
        return x.compareTo(y) != 0;
    }

    public static BigInteger factorial(BigInteger x) {
        if (x.compareTo(new BigInteger("0")) < 0) {
            throw new IllegalArgumentException("number must be greater than 0");
        }
        BigInteger y = x;
        x = x.subtract(new BigInteger("1"));
        while (x.toString().compareTo("1") > 0) {
            y = y.multiply(x);
            x = x.subtract(new BigInteger("1"));
        }
        return y;
    }

    public static int factorial(double x) {
        return Math.factorial((int)x);
    }

    public static int factorial(float x) {
        return Math.factorial((int)x);
    }

    public static int factorial(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("number must be greater than 0");
        }
        int y = x--;
        while (x > 1) {
            y *= x;
            --x;
        }
        return y;
    }

    public static BigDecimal min(BigDecimal a, BigDecimal b) {
        return a.min(b);
    }

    public static BigInteger min(BigInteger a, BigInteger b) {
        return a.min(b);
    }

    public static BigDecimal max(BigDecimal a, BigDecimal b) {
        return a.max(b);
    }

    public static BigInteger max(BigInteger a, BigInteger b) {
        return a.max(b);
    }

    public static BigInteger pow(BigInteger y, BigInteger x) {
        int exp = x.intValue();
        if (exp < 1) {
            throw new IllegalArgumentException("Exponent must be greater than 0");
        }
        return y.pow(x.intValue());
    }

    public static BigDecimal pow(BigDecimal y, BigDecimal x) {
        if (x.compareTo(new BigDecimal("1")) <= 0) {
            throw new ArithmeticException("Powers of BigDecimals must be integers greater than 1");
        }
        String exp = x.toString();
        if (exp.indexOf(".") > 0) {
            exp = exp.substring(0, exp.indexOf("."));
        }
        BigInteger e = new BigInteger(exp);
        BigDecimal z = new BigDecimal(y.toString());
        while (e.compareTo(BigInteger.ONE) > 0) {
            y = y.multiply(z);
            e = e.subtract(BigInteger.ONE);
        }
        return y;
    }

    public Number calculate(String op, String[] operands) {
        return this.calculate(op, "double", operands);
    }

    public Number calculate(String op, String type, String[] operands) {
        try {
            Method m;
            Candidate candidate;
            String name;
            int i;
            if (operands.length >= 2 && (op.equals("add") || op.equals("subtract") || op.equals("multiply") || op.equals("divide") || op.equals("mod"))) {
                return this.calculateArray(op, type, operands);
            }
            if (operands.length > 2) {
                throw new IllegalArgumentException("too many operands");
            }
            Class<Object> c = this.strict ? Class.forName("java.lang.StrictMath") : Class.forName("java.lang.Math");
            if (op.equals("random")) {
                Method m2 = c.getDeclaredMethod(op, new Class[0]);
                Object result = m2.invoke(c, null);
                return (Number)result;
            }
            Vector<Candidate> candidates = new Vector<Candidate>();
            Method[] methods = c.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                name = methods[i].getName();
                if (!name.equals(op)) continue;
                candidates.addElement(new Candidate(c, methods[i]));
            }
            c = this.getClass();
            methods = c.getDeclaredMethods();
            for (i = 0; i < methods.length; ++i) {
                name = methods[i].getName();
                if (!name.equals(op)) continue;
                candidates.addElement(new Candidate(c, methods[i]));
            }
            if (candidates.size() == 0) {
                throw new RuntimeException("Unknown operation: " + op);
            }
            Class wantTypeClass = this.getDataType(type);
            int paramCount = -1;
            try {
                Method method;
                for (int i2 = 0; i2 <= candidates.size() && (paramCount = (method = (candidate = (Candidate)candidates.elementAt(i2)).getCandidateMethod()).getParameterTypes().length) != operands.length; ++i2) {
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Wrong number of arguments, have " + operands.length + ", but can't find corresponding method.");
            }
            Class typeClass = null;
            if (candidates.size() == 1) {
                candidate = (Candidate)candidates.elementAt(0);
                c = candidate.getCandidateClass();
                m = candidate.getCandidateMethod();
                typeClass = m.getParameterTypes()[0];
            } else {
                Enumeration en = candidates.elements();
                while (en.hasMoreElements()) {
                    Candidate candidate2 = (Candidate)en.nextElement();
                    c = candidate2.getCandidateClass();
                    m = candidate2.getCandidateMethod();
                    if (!m.getParameterTypes()[0].equals(wantTypeClass)) continue;
                    typeClass = wantTypeClass;
                    break;
                }
                if (typeClass == null) {
                    throw new RuntimeException("Can't find a method with parameters of type " + type);
                }
            }
            Class[] paramTypes = new Class[paramCount];
            for (int i3 = 0; i3 < paramCount; ++i3) {
                paramTypes[i3] = typeClass;
            }
            m = c.getDeclaredMethod(op, paramTypes);
            Object[] params = this.getParams(typeClass, operands);
            try {
                Object result = m.invoke((Object)c, params);
                if (result instanceof Boolean) {
                    result = new Integer((Boolean)result != false ? 1 : 0);
                }
                return (Number)result;
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getCause();
                if (t != null && t instanceof ArithmeticException) {
                    throw (ArithmeticException)t;
                }
                throw ite;
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Number calculateArray(String op, String type, String[] operands) {
        try {
            Class<?> c = this.getClass();
            Vector<Method> candidates = new Vector<Method>();
            Method[] methods = c.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                String name = methods[i].getName();
                if (!name.equals(op) || methods[i].getParameterTypes().length != 1 || !methods[i].getParameterTypes()[0].isArray()) continue;
                candidates.addElement(methods[i]);
            }
            if (candidates.size() == 0) {
                throw new RuntimeException("Unknown operation: " + op);
            }
            Object wantTypeClass = this.getDataTypeArray(type, operands.length);
            Class typeClass = null;
            Enumeration en = candidates.elements();
            while (en.hasMoreElements()) {
                Method m = (Method)en.nextElement();
                if (!m.getParameterTypes()[0].equals(wantTypeClass.getClass())) continue;
                typeClass = this.getDataType(type);
                Object[] params = this.getParamsArray(typeClass, operands);
                try {
                    Object result = m.invoke(c, params);
                    return (Number)result;
                }
                catch (InvocationTargetException ite) {
                    Throwable t = ite.getCause();
                    if (t == null || !(t instanceof ArithmeticException)) throw ite;
                    throw (ArithmeticException)t;
                    return null;
                }
            }
        }
        catch (Exception e) {
            if (!(e instanceof ArithmeticException)) return null;
            throw (ArithmeticException)e;
        }
    }

    private Class getDataType(String type) {
        if (type == null) {
            return Double.TYPE;
        }
        if (type.equals("int")) {
            return Integer.TYPE;
        }
        if (type.equals("long")) {
            return Long.TYPE;
        }
        if (type.equals("float")) {
            return Float.TYPE;
        }
        if (type.equals("bigint")) {
            try {
                return Class.forName("java.math.BigInteger");
            }
            catch (Exception e) {
            }
        } else if (type.equals("bigdecimal")) {
            try {
                return Class.forName("java.math.BigDecimal");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Double.TYPE;
    }

    private Object getDataTypeArray(String type, int length) {
        if (type == null) {
            return Array.newInstance(Double.TYPE, length);
        }
        if (type.equals("int")) {
            return Array.newInstance(Integer.TYPE, length);
        }
        if (type.equals("long")) {
            return Array.newInstance(Long.TYPE, length);
        }
        if (type.equals("float")) {
            return Array.newInstance(Float.TYPE, length);
        }
        if (type.equals("bigdecimal")) {
            return Array.newInstance(BIGDECIMAL_TYPE, length);
        }
        if (type.equals("bigint")) {
            return Array.newInstance(BIGINT_TYPE, length);
        }
        return Array.newInstance(Double.TYPE, length);
    }

    private Object[] getParams(Class typeClass, String[] operands) {
        int paramCount = operands.length;
        Object[] params = new Object[paramCount];
        if (typeClass == BIGDECIMAL_TYPE) {
            for (int i = 0; i < paramCount; ++i) {
                params[i] = new BigDecimal(operands[i]);
            }
        } else if (typeClass == BIGINT_TYPE) {
            for (int i = 0; i < paramCount; ++i) {
                params[i] = new BigInteger(operands[i]);
            }
        } else if (typeClass == Double.TYPE) {
            for (int i = 0; i < paramCount; ++i) {
                params[i] = new Double(operands[i]);
            }
        } else if (typeClass == Long.TYPE) {
            for (int i = 0; i < paramCount; ++i) {
                params[i] = new Long(operands[i]);
            }
        } else if (typeClass == Float.TYPE) {
            for (int i = 0; i < paramCount; ++i) {
                params[i] = new Float(operands[i]);
            }
        } else {
            for (int i = 0; i < paramCount; ++i) {
                params[i] = new Integer(operands[i]);
            }
        }
        if (paramCount > 2) {
            params = new Object[]{params};
        }
        return params;
    }

    private Object[] getParamsArray(Class typeClass, String[] operands) {
        int paramCount = operands.length;
        if (typeClass == BIGDECIMAL_TYPE) {
            BigDecimal[] array = (BigDecimal[])Array.newInstance(typeClass, operands.length);
            for (int i = 0; i < paramCount; ++i) {
                array[i] = new BigDecimal(operands[i]);
            }
            return new Object[]{array};
        }
        if (typeClass == BIGINT_TYPE) {
            BigInteger[] array = (BigInteger[])Array.newInstance(typeClass, operands.length);
            for (int i = 0; i < paramCount; ++i) {
                array[i] = new BigInteger(operands[i]);
            }
            return new Object[]{array};
        }
        if (typeClass == Double.TYPE) {
            double[] array = (double[])Array.newInstance(typeClass, operands.length);
            for (int i = 0; i < paramCount; ++i) {
                Array.setDouble(array, i, new Double(operands[i]));
            }
            return new Object[]{array};
        }
        if (typeClass == Long.TYPE) {
            long[] array = (long[])Array.newInstance(typeClass, operands.length);
            for (int i = 0; i < paramCount; ++i) {
                Array.setLong(array, i, new Long(operands[i]));
            }
            return new Object[]{array};
        }
        if (typeClass == Float.TYPE) {
            float[] array = (float[])Array.newInstance(typeClass, operands.length);
            for (int i = 0; i < paramCount; ++i) {
                Array.setFloat(array, i, new Float(operands[i]).floatValue());
            }
            return new Object[]{array};
        }
        Object array = Array.newInstance(typeClass, operands.length);
        for (int i = 0; i < paramCount; ++i) {
            if (operands[i].indexOf(".") > 0) {
                operands[i] = operands[i].substring(0, operands[i].indexOf("."));
            }
            Array.setInt(array, i, new Integer(operands[i]));
        }
        return new Object[]{array};
    }

    static {
        try {
            BIGDECIMAL_TYPE = Class.forName("java.math.BigDecimal");
        }
        catch (ClassNotFoundException e) {
            BIGDECIMAL_TYPE = null;
        }
        try {
            BIGINT_TYPE = Class.forName("java.math.BigInteger");
        }
        catch (Exception e) {
            BIGINT_TYPE = null;
        }
    }

    public class Candidate {
        private Class c;
        private Method m;

        public Candidate(Class c, Method m) {
            this.c = c;
            this.m = m;
        }

        public Class getCandidateClass() {
            return this.c;
        }

        public Method getCandidateMethod() {
            return this.m;
        }
    }
}

