/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.BooleanConditionTask;
import ise.antelope.tasks.typedefs.TimeUnit;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class Repeat
extends Task
implements TaskContainer {
    private Vector tasks = new Vector();
    private long repeatInterval = 10L;
    protected TimeUnit unit = TimeUnit.SECOND_UNIT;
    private String timeoutProperty = null;
    private String timeoutValue = "true";
    private boolean failOnError = false;
    private int repeatCount = 1;
    private BooleanConditionTask condition = null;

    public void addTask(Task task) throws BuildException {
        this.tasks.addElement(task);
    }

    public void addUntil(BooleanConditionTask c) throws BuildException {
        if (this.condition != null) {
            throw new BuildException("Can only add one condition.");
        }
        this.condition = c;
    }

    public void setInterval(int wait) {
        this.repeatInterval = wait;
    }

    public void setUnit(String unit) {
        if (unit == null) {
            return;
        }
        if (unit.equals("second")) {
            this.setRepeatunit(TimeUnit.SECOND_UNIT);
            return;
        }
        if (unit.equals("millisecond")) {
            this.setRepeatunit(TimeUnit.MILLISECOND_UNIT);
            return;
        }
        if (unit.equals("minute")) {
            this.setRepeatunit(TimeUnit.MINUTE_UNIT);
            return;
        }
        if (unit.equals("hour")) {
            this.setRepeatunit(TimeUnit.HOUR_UNIT);
            return;
        }
        if (unit.equals("day")) {
            this.setRepeatunit(TimeUnit.DAY_UNIT);
            return;
        }
        if (unit.equals("week")) {
            this.setRepeatunit(TimeUnit.WEEK_UNIT);
            return;
        }
    }

    public void setMilliseconds(int value) {
        this.setInterval(value);
        this.setRepeatunit(TimeUnit.MILLISECOND_UNIT);
    }

    public void setSeconds(int value) {
        this.setInterval(value);
        this.setRepeatunit(TimeUnit.SECOND_UNIT);
    }

    public void setMinutes(int value) {
        this.setInterval(value);
        this.setRepeatunit(TimeUnit.MINUTE_UNIT);
    }

    public void setHours(int value) {
        this.setInterval(value);
        this.setRepeatunit(TimeUnit.HOUR_UNIT);
    }

    public void setDays(int value) {
        this.setInterval(value);
        this.setRepeatunit(TimeUnit.DAY_UNIT);
    }

    public void setWeeks(int value) {
        this.setInterval(value);
        this.setRepeatunit(TimeUnit.WEEK_UNIT);
    }

    public void setRepeatunit(TimeUnit unit) {
        this.unit = unit;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setProperty(String p) {
        this.timeoutProperty = p;
    }

    public void setValue(String v) {
        this.timeoutValue = v;
    }

    public void setCount(int count) {
        this.repeatCount = count;
    }

    public void execute() throws BuildException {
        try {
            long repeat_interval = this.repeatInterval * this.unit.getMultiplier();
            if (repeat_interval <= 0L) {
                this.log("Interval is set to 0, will only execute tasks 1 time.");
                this.repeatCount = 1;
            }
            if (this.repeatCount >= 1) {
                for (int i = 0; i < this.repeatCount; ++i) {
                    this.repeatTasks();
                    if (this.condition == null || !this.condition.eval()) {
                        if (i + 1 >= this.repeatCount) continue;
                        Thread.currentThread();
                        Thread.sleep(repeat_interval);
                        continue;
                    }
                    break;
                }
            } else if (this.repeatCount == -1) {
                while (true) {
                    this.repeatTasks();
                    if (this.condition == null || !this.condition.eval()) {
                        Thread.currentThread();
                        Thread.sleep(repeat_interval);
                        continue;
                    }
                    break;
                }
            } else if (this.repeatCount != 0 && repeat_interval == 0L) {
                this.repeatTasks();
            }
            if (this.timeoutProperty != null) {
                if (this.timeoutValue == null) {
                    this.timeoutValue = "true";
                }
                this.getProject().setUserProperty(this.timeoutProperty, this.timeoutValue);
            }
        }
        catch (InterruptedException ie) {
            throw new BuildException(ie.getMessage());
        }
    }

    private void repeatTasks() throws BuildException {
        try {
            for (int i = 0; i < this.tasks.size(); ++i) {
                Task currentTask = (Task)this.tasks.get(i);
                try {
                    currentTask.perform();
                    continue;
                }
                catch (Exception ex) {
                    if (!this.failOnError) continue;
                    throw ex;
                }
            }
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw new BuildException(e.getMessage());
            }
            this.log(e.getMessage());
        }
    }
}

