/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen;

import java.util.List;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.XPath;
import org.jaxen.function.BooleanFunction;
import org.jaxen.function.NumberFunction;
import org.jaxen.function.StringFunction;
import org.saxpath.SAXPathException;
import org.saxpath.XPathReader;
import org.saxpath.helpers.XPathReaderFactory;

class JaXPath {
    private XPath xpath;

    public JaXPath(String xpathExpr) throws SAXPathException {
        XPathReader reader = XPathReaderFactory.createReader();
        JaxenHandler handler = new JaxenHandler();
        reader.setXPathHandler(handler);
        reader.parse(xpathExpr);
        this.xpath = handler.getXPath();
    }

    public String debug() {
        return this.xpath.toString();
    }

    protected boolean jaBooleanValueOf(Context context) throws JaxenException {
        List result = this.jaSelectNodes(context);
        if (result == null) {
            return false;
        }
        return BooleanFunction.evaluate(result, context.getNavigator());
    }

    protected Number jaNumberValueOf(Context context) throws JaxenException {
        Object result = this.jaSelectSingleNode(context);
        if (result == null) {
            return null;
        }
        return NumberFunction.evaluate(result, context.getNavigator());
    }

    protected List jaSelectNodes(Context context) throws JaxenException {
        return this.xpath.asList(context);
    }

    protected Object jaSelectSingleNode(Context context) throws JaxenException {
        List results = this.jaSelectNodes(context);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    protected String jaValueOf(Context context) throws JaxenException {
        Object result = this.jaSelectSingleNode(context);
        if (result == null) {
            return "";
        }
        return StringFunction.evaluate(result, context.getNavigator());
    }

    public String toString() {
        return this.xpath.getText();
    }
}

