/** This class is not currently used and therefore will not be compiled by makegli. */

package org.greenstone.gatherer.feedback;

import java.io.*;
import javax.imageio.*;
import java.awt.*;
import java.awt.image.*;
import com.sun.image.codec.jpeg.*;
import javax.swing.*;

/**
 * This method will separate 1 image file into 2 image  with the help of
 * another file and sace the difference into a jpeg files.
 * For example : We have 1 image file which is a screen shot and another image file
 *               is the screenshot with some line in it.
 *               This class will separate the screen shot and the line into 2 separates 
 *               images.And then it will save the line into a jpeg files.
 * 
 * @author Veronica Liesaputra
 */
public class Separating
{
    /**
     * This is the BufferedImage of image inside the reference image file.
     */
    private BufferedImage bi;
    /**
     * This is the BufferedImage of image that we want to separate into
     * 2 different image using the reference file.
     */
    private BufferedImage src_bi;

    /**
     * It will read whats inside the 2 given filenames and put it in the
     * right BufferedImage.
     * @param filename1 this is the file name of the reference image file.
     * @param filename2 this is the file name of the file we want to separate into 2.
     */
    public Separating(String filename1,String filename2)
    {
	try
	    {
		File f1 = new File(filename1);
		File f2 = new File(filename2);
		bi = ImageIO.read(f1);
		src_bi = ImageIO.read(f2);
	    }
	catch(IOException exp) {}
    }

    /**
     * This method will get the difference that exist between bi and src_bi and
     * will save the difference inside a jpeg file with the specified file name.
     * @param file1 is the name of the file where we want to save the image.
     */
    public void separate(String file1)
    {
	BufferedImage bi1;
	
	int width = bi.getWidth();
	int height = bi.getHeight();
	
	bi1 = new BufferedImage(width,height,BufferedImage.TYPE_INT_RGB);

	for (int y = 0 ; y < height ; y++) 
	    {
		for (int x = 0 ; x < width ; x++)
		    {
			int rgb = bi.getRGB(x,y);
			int src_rgb = src_bi.getRGB(x,y);
			
			if (src_rgb != rgb)
			    {
				bi1.setRGB(x,y,rgb);
			    }
		    }
	    }

	save(bi1,file1);
    }

    /**
     * This method will save a BufferedImage to a jpeg file with the specified filename.
     * @param b is the BufferedImage to be saved.
     * @param filename is the name of the jpeg file.
     */
    public void save(BufferedImage b,String filename)
    {
	try 
	    {
		File file = new File(filename);
		FileOutputStream out = new FileOutputStream(file);
	    
		JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
		JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(b);
		param.setQuality(1.0f, false);
		encoder.setJPEGEncodeParam(param);
		encoder.encode(b);
		
	    } catch (Exception ex) {}
    }
}





