/**********************************************************************
 *
 * httpreq.h
 * Copyright (C) 1996
 * 
 * A component of the fnord webserver written by bmorin@wpi.edu.
 *
 * Altered for use with the Greenstone digital library software by the
 * New Zealand Digital Library Project at the University of Waikato,
 * New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef HTTPREQ_H
#define HTTPREQ_H

// need this to avoid bizarre compiler problems under VC++ 6.0
#if !defined (GSDL_NAMESPACE_BROKEN) && !defined (GSDL_USE_IOS_H)
# include <iostream>
# include <fstream>
using namespace std;
#endif

#include "locate.h"
#include "text_t.h"

/*
Module Name: HTTP Request
Purpose: Parses HTTP requests and then calls the appropriate function
	to respond to the request
Public Functions:
	Request Thread
*/

// Public Data Structures

//Used for sending information to the request thread
struct RequestThreadMessageT {
  SOCKADDR_IN ClientSockAddr;
  SOCKET ClientSocket;
  int AddrLen;
};

#define MAX_OTHER_HEADERS 100

struct RequestHeaderT {
  text_t Var;
  text_t Val;

  RequestHeaderT() 
  : Var(), Val()
  {}
};

struct RequestFieldsT {
  //Simple request line info v0.9
  text_t MethodStr;
  text_t URIStr;
  //added v1.0
  text_t VersionStr;
  //General Header
  text_t DateStr;
  text_t MIMEVerStr;
  text_t PragmaStr;
  //Request Header
  text_t AuthorizationStr;
  text_t FromStr;
  text_t IfModSinceStr;
  text_t RefererStr;
  text_t UserAgentStr;
  //Entity Header (Only CGI stuff)
  text_t ContentEncodingStr;
  text_t ContentTypeStr;
  text_t ContentLengthStr;
  //v1.0 Optional (the more common ones)
  text_t AcceptStr;
  text_t AcceptLangStr;
  //v1.1 Exentions
  text_t ConnectionStr;
  //Pointer to buffer containing the content
  DWORD ContentLength;
  BYTE *Content;
  
  //Other Headers
  int NumOtherHeaders;
  RequestHeaderT OtherHeaders[MAX_OTHER_HEADERS];

  RequestFieldsT()
  : MethodStr(), URIStr(), VersionStr(), DateStr(), MIMEVerStr(),
    PragmaStr(), AuthorizationStr(), FromStr(), IfModSinceStr(),
    RefererStr(), UserAgentStr(), ContentEncodingStr(),
    ContentTypeStr(), ContentLengthStr(), AcceptStr(),
    AcceptLangStr(), ConnectionStr(),
	OtherHeaders()
  {
    ContentLength = 0;
	Content = NULL;
	NumOtherHeaders = 0;
  }

};

struct RequestInfoT {
  int ThreadNum;
  
  //Buffer for IO operations (so we're not constantly reallocating buffers)
  BYTE *IOBuffer;
  int IOBufferSize;
  
  //Socket the request is on and its address
  SOCKET ClientSocket;
  SOCKADDR_IN ClientSockAddr;
  int AddrLen;
  
  //Should we keep the connection alive?
  BOOL KeepAlive;
};


// Public Functions

/*
Function Name: RequestThread
Purpose: Was the HTTP request processing thread
         Now just a standard procedure called to process a request
Parameters:
	       Pointer to packed parameter structure
*/
void RequestThread(RequestThreadMessageT *Parameters);

/*
Function Name: Process 1.0 Request
Purpose: Sends a HTTP 1.0 (plus some) reply to a HTTP 1.x request
Parameters:
	ClientSocket - Socket the client is on
	ClientSockAddr - Address of client
	AddrLen - Length of client address
	RequestInfo - Structure storing the parsed headers
	KeepAlive - To be set to true if we are maintainig the connection
	IOBuffer - Pointer to buffer allocated for IO operations
	TheadNum - Number of calling thread for debugging
Notes: The function uses "Connection: Keep-Alive" as written in the HTTP/1.1
	draft and implemented by Netscape and MSIE
*/
void Process10Request(RequestInfoT &RequestInfo, RequestFieldsT &RequestFields);

#endif
