/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.collection;

import java.io.File;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.core.MessageRouter;
import org.greenstone.gsdl3.core.ModuleInterface;
import org.greenstone.gsdl3.service.ServiceRack;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceCluster
implements ModuleInterface {
    static Logger logger = Logger.getLogger((String)ServiceCluster.class.getName());
    protected static final String CONFIG_ENCODING = "utf-8";
    protected static final String DEFAULT_LANG = "en";
    protected String site_home = null;
    protected String site_http_address = null;
    protected String cluster_name = null;
    protected String col_type = "";
    protected MessageRouter router = null;
    protected HashMap service_map = new HashMap();
    protected HashMap service_name_map = new HashMap();
    protected XMLConverter converter = new XMLConverter();
    protected Document doc = null;
    protected Element service_list = null;
    protected Element metadata_list = null;
    protected Element display_item_list = null;
    protected Element description = null;
    protected Element plugin_item_list = null;

    public void setSiteHome(String home) {
        this.site_home = home;
    }

    public void setSiteAddress(String address) {
        this.site_http_address = address;
    }

    public void cleanUp() {
        for (ServiceRack s : this.service_map.values()) {
            s.cleanUp();
        }
    }

    public void setClusterName(String name) {
        this.cluster_name = name;
        this.description.setAttribute("name", name);
    }

    public void setMessageRouter(MessageRouter m) {
        this.router = m;
    }

    public ServiceCluster() {
        ServiceCluster serviceCluster = this;
        this.doc = serviceCluster.converter.newDOM();
        this.description = this.doc.createElement("serviceCluster");
        this.display_item_list = this.doc.createElement("displayItemList");
        this.metadata_list = this.doc.createElement("metadataList");
        this.plugin_item_list = this.doc.createElement("pluginList");
    }

    public boolean configure() {
        if (this.site_home == null || this.cluster_name == null) {
            logger.error((Object)"site_home and cluster_name must be set before configure called!");
            return false;
        }
        logger.info((Object)"configuring service cluster");
        File config_file = new File(GSFile.siteConfigFile(this.site_home));
        if (!config_file.exists()) {
            logger.error((Object)("couldn't configure cluster: " + this.cluster_name + ", " + config_file + " does not exist"));
            return false;
        }
        Document doc = this.converter.getDOM(config_file, CONFIG_ENCODING);
        if (doc == null) {
            logger.error((Object)("couldn't parse config file " + config_file.getPath()));
            return false;
        }
        Element cluster_list = (Element)GSXML.getChildByTagName(doc.getDocumentElement(), "serviceClusterList");
        Element sc = GSXML.getNamedElement(cluster_list, "serviceCluster", "name", this.cluster_name);
        return this.configure(sc);
    }

    public boolean configure(Element service_cluster_info) {
        Element service_rack_list;
        Element plugin_list;
        Element import_list;
        Element display_list;
        Element meta_list = (Element)GSXML.getChildByTagName(service_cluster_info, "metadataList");
        if (meta_list != null && !this.addMetadata(meta_list)) {
            logger.error((Object)" couldn't configure the metadata");
        }
        if ((display_list = (Element)GSXML.getChildByTagName(service_cluster_info, "displayItemList")) != null && !this.addDisplayItems(display_list)) {
            logger.error((Object)"couldn't configure the display items");
        }
        if ((import_list = (Element)GSXML.getChildByTagName(service_cluster_info, "import")) != null && (plugin_list = (Element)GSXML.getChildByTagName(service_cluster_info, "pluginList")) != null && !this.addPlugins(plugin_list)) {
            logger.error((Object)"couldn't configure the plugins");
        }
        if ((service_rack_list = (Element)GSXML.getChildByTagName(service_cluster_info, "serviceRackList")) == null) {
            logger.error((Object)"cluster has no service racks!!");
        } else if (!this.configureServiceRack(service_rack_list, null)) {
            logger.error((Object)"couldn't configure the  service racks!!");
            return false;
        }
        return true;
    }

    protected boolean addMetadata(Element metadata_list) {
        if (metadata_list == null) {
            return false;
        }
        NodeList metanodes = metadata_list.getElementsByTagName("metadata");
        if (metanodes.getLength() > 0) {
            for (int k = 0; k < metanodes.getLength(); ++k) {
                this.metadata_list.appendChild(this.doc.importNode(metanodes.item(k), true));
            }
        }
        return true;
    }

    protected boolean addDisplayItems(Element display_list) {
        if (display_list == null) {
            return false;
        }
        NodeList displaynodes = display_list.getElementsByTagName("displayItem");
        if (displaynodes.getLength() > 0) {
            for (int k = 0; k < displaynodes.getLength(); ++k) {
                String name;
                Element this_item;
                Element d = (Element)displaynodes.item(k);
                String lang = d.getAttribute("lang");
                if (lang == null || lang.equals("")) {
                    d.setAttribute("lang", DEFAULT_LANG);
                }
                if ((this_item = GSXML.getNamedElement(this.display_item_list, "displayItem", "name", name = d.getAttribute("name"))) == null) {
                    this_item = this.doc.createElement("displayItem");
                    this_item.setAttribute("name", name);
                    this.display_item_list.appendChild(this_item);
                }
                this_item.appendChild(this.doc.importNode(d, true));
            }
        }
        return true;
    }

    protected boolean addPlugins(Element plugin_list) {
        if (plugin_list == null) {
            return false;
        }
        NodeList pluginNodes = plugin_list.getElementsByTagName("plugin");
        if (pluginNodes.getLength() > 0) {
            for (int k = 0; k < pluginNodes.getLength(); ++k) {
                this.plugin_item_list.appendChild(this.doc.importNode(pluginNodes.item(k), true));
            }
        }
        return true;
    }

    protected boolean configureServiceRack(Element service_rack_list, Element extra_info) {
        this.service_map.clear();
        this.service_list = this.doc.createElement("serviceList");
        NodeList nodes = service_rack_list.getElementsByTagName("serviceRack");
        if (nodes.getLength() == 0) {
            logger.error((Object)("ServiceCluster configuration error: cluster " + this.cluster_name + " has no service modules!"));
            return false;
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element message = this.doc.createElement("message");
            Element request = GSXML.createBasicRequest(this.doc, "describe", "", "", "");
            message.appendChild(request);
            Element n = (Element)nodes.item(i);
            String servicetype = n.getAttribute("name");
            ServiceRack s = null;
            try {
                s = (ServiceRack)Class.forName("org.greenstone.gsdl3.service." + servicetype).newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (s == null) {
                try {
                    s = (ServiceRack)Class.forName(servicetype).newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (s == null) {
                logger.error((Object)("Couldn't get an instance of class " + servicetype + ", or org.greenstone.gsdl3.service." + servicetype));
                continue;
            }
            s.setSiteHome(this.site_home);
            s.setSiteAddress(this.site_http_address);
            s.setClusterName(this.cluster_name);
            s.setMessageRouter(this.router);
            if (!s.configure(n, extra_info)) continue;
            Node types = s.process(message);
            NodeList typenodes = ((Element)types).getElementsByTagName("service");
            for (int j = 0; j < typenodes.getLength(); ++j) {
                String service = ((Element)typenodes.item(j)).getAttribute("name");
                if (this.service_map.get(service) != null) {
                    char extra = '0';
                    String new_service = service + extra;
                    while (this.service_map.get(new_service) != null) {
                        extra = (char)(extra + '\u0001');
                        new_service = service + extra;
                    }
                    this.service_name_map.put(new_service, service);
                    service = new_service;
                    ((Element)typenodes.item(j)).setAttribute("name", service);
                }
                this.service_map.put(service, s);
                this.service_list.appendChild(this.doc.importNode(typenodes.item(j), true));
            }
        }
        return true;
    }

    public String process(String in) {
        Document doc = this.converter.getDOM(in);
        Node res = this.process(doc);
        return XMLConverter.getString(res);
    }

    public Node process(Node message_node) {
        Element message = XMLConverter.nodeToElement(message_node);
        NodeList requests = message.getElementsByTagName("request");
        Document mess_doc = message.getOwnerDocument();
        Element mainResult = this.doc.createElement("message");
        if (requests.getLength() == 0) {
            logger.error((Object)("no requests for cluster:" + this.cluster_name));
            return mainResult;
        }
        for (int i = 0; i < requests.getLength(); ++i) {
            Element request = (Element)requests.item(i);
            String to = request.getAttribute("to");
            String clustername = GSPath.getFirstLink(to);
            if (!clustername.equals(this.cluster_name)) {
                logger.error((Object)("cluster name wrong! was " + clustername + " should have been " + this.cluster_name));
                continue;
            }
            to = GSPath.removeFirstLink(to);
            request.setAttribute("to", to);
            if (to.equals("")) {
                Element response = this.processMessage(request);
                mainResult.appendChild(response);
                continue;
            }
            String service = GSPath.getFirstLink(to);
            if (!this.service_map.containsKey(service)) {
                logger.error((Object)("non-existant service, " + service + ", specified!"));
                continue;
            }
            String real_service = service;
            if (this.service_name_map.containsKey(service)) {
                real_service = (String)this.service_name_map.get(service);
                String old_to = to = request.getAttribute("to");
                to = GSPath.replaceFirstLink(to, real_service);
                request.setAttribute("to", to);
            }
            Element single_message = mess_doc.createElement("message");
            single_message.appendChild(request);
            Node response_message = ((ModuleInterface)this.service_map.get(service)).process(single_message);
            if (response_message == null) continue;
            Element response = (Element)GSXML.getChildByTagName(response_message, "response");
            String from = response.getAttribute("from");
            if (!real_service.equals(service)) {
                from = GSPath.replaceFirstLink(from, service);
                Element service_elem = (Element)GSXML.getChildByTagName(response, "service");
                if (service_elem != null) {
                    service_elem.setAttribute("name", service);
                }
            }
            from = GSPath.prependLink(from, this.cluster_name);
            response.setAttribute("from", from);
            mainResult.appendChild(this.doc.importNode(response, true));
        }
        return mainResult;
    }

    protected Element processMessage(Element request) {
        Element response = this.doc.createElement("response");
        response.setAttribute("from", this.cluster_name);
        String type = request.getAttribute("type");
        String lang = request.getAttribute("lang");
        response.setAttribute("type", type);
        if (type.equals("describe")) {
            Element description = (Element)this.description.cloneNode(false);
            description.setAttribute("type", this.col_type);
            response.appendChild(description);
            Element param_list = (Element)GSXML.getChildByTagName(request, "paramList");
            if (param_list == null) {
                this.addAllDisplayInfo(description, lang);
                description.appendChild(this.service_list);
                description.appendChild(this.metadata_list);
                description.appendChild(this.plugin_item_list);
                return response;
            }
            NodeList params = param_list.getElementsByTagName("param");
            for (int i = 0; i < params.getLength(); ++i) {
                Element param = (Element)params.item(i);
                if (!param.getAttribute("name").equals("subset")) continue;
                String info = param.getAttribute("value");
                if (info.equals("serviceList")) {
                    description.appendChild(this.service_list);
                    continue;
                }
                if (info.equals("metadataList")) {
                    description.appendChild(this.metadata_list);
                    continue;
                }
                if (info.equals("displayItemList")) {
                    this.addAllDisplayInfo(description, lang);
                    continue;
                }
                if (!info.equals("pluginList")) continue;
                description.appendChild(this.plugin_item_list);
            }
            return response;
        }
        if (type.equals("system")) {
            response = this.processSystemRequest(request);
        } else {
            logger.error((Object)("cant handle request of type " + type));
        }
        return response;
    }

    protected Element processSystemRequest(Element request) {
        Element response = this.doc.createElement("response");
        response.setAttribute("from", this.cluster_name);
        response.setAttribute("type", "system");
        NodeList commands = request.getElementsByTagName("system");
        String message = null;
        for (int i = 0; i < commands.getLength(); ++i) {
            Element s;
            Element elem = (Element)commands.item(i);
            String action = elem.getAttribute("type");
            if (action.equals("configure")) {
                Element s2;
                String subset = elem.getAttribute("subset");
                if (subset.equals("")) {
                    if (this.configure()) {
                        s2 = GSXML.createTextElement(this.doc, "status", this.cluster_name + " reconfigured");
                        response.appendChild(s2);
                        continue;
                    }
                    s2 = GSXML.createTextElement(this.doc, "status", this.cluster_name + " could not be reconfigured");
                    response.appendChild(s2);
                    continue;
                }
                if (this.configureSubset(subset)) {
                    s2 = GSXML.createTextElement(this.doc, "status", this.cluster_name + " " + subset + " reconfigured");
                    response.appendChild(s2);
                    continue;
                }
                s2 = GSXML.createTextElement(this.doc, "status", this.cluster_name + " " + subset + " could not be reconfigured");
                response.appendChild(s2);
                continue;
            }
            String module_name = elem.getAttribute("moduleName");
            String module_type = elem.getAttribute("moduleType");
            if (action.equals("activate")) {
                s = GSXML.createTextElement(this.doc, "status", "activate action not yet implemented - does it even make sense in this context??");
                response.appendChild(s);
                continue;
            }
            if (action.equals("deactivate")) {
                if (module_type.equals("service")) {
                    this.service_map.remove(module_name);
                    Element service_elem = GSXML.getNamedElement(this.service_list, "service", "name", module_name);
                    this.service_list.removeChild(service_elem);
                    message = module_type + ": " + module_name + " deactivated";
                } else {
                    message = "can't deactivate " + module_type + " type modules!";
                }
                s = GSXML.createTextElement(this.doc, "status", message);
                response.appendChild(s);
                continue;
            }
            logger.error((Object)("cant process system request, action " + action));
        }
        return response;
    }

    protected boolean configureSubset(String subset) {
        File configFile = new File(GSFile.siteConfigFile(this.site_home));
        if (!configFile.exists()) {
            logger.error((Object)("site config file: " + configFile.getPath() + " not found!"));
            return false;
        }
        Document site_config_doc = this.converter.getDOM(configFile);
        if (site_config_doc == null) {
            logger.error((Object)("could not read in site config file: " + configFile.getPath()));
            return false;
        }
        Element site_config_elem = site_config_doc.getDocumentElement();
        Element cluster_config_elem = GSXML.getNamedElement((Element)GSXML.getChildByTagName(site_config_elem, "serviceClusterList"), "serviceCluster", "name", this.cluster_name);
        if (cluster_config_elem == null) {
            logger.error((Object)("site config file: " + configFile.getPath() + " has no element for cluster " + this.cluster_name));
            return false;
        }
        if (subset.equals("serviceList")) {
            Element service_rack_list = (Element)GSXML.getChildByTagName(cluster_config_elem, "serviceRackList");
            return this.configureServiceRack(service_rack_list, null);
        }
        if (subset.equals("metadataList")) {
            this.metadata_list = this.doc.createElement("metadataList");
            Element metadata_list = (Element)GSXML.getChildByTagName(cluster_config_elem, "metadataList");
            return this.addMetadata(metadata_list);
        }
        if (subset.equals("pluginList")) {
            this.plugin_item_list = this.doc.createElement("pluginList");
            Element import_list = (Element)GSXML.getChildByTagName(cluster_config_elem, "import");
            if (import_list != null) {
                Element plugin_item_list = (Element)GSXML.getChildByTagName(cluster_config_elem, "pluginList");
                return this.addPlugins(plugin_item_list);
            }
            return false;
        }
        logger.error((Object)("cannot process system request, configure " + subset));
        return false;
    }

    protected boolean addAllDisplayInfo(Element description, String lang) {
        NodeList items = this.display_item_list.getChildNodes();
        for (int i = 0; i < items.getLength(); ++i) {
            Element m = (Element)items.item(i);
            Element new_m = GSXML.getNamedElement(m, "displayItem", "lang", lang);
            if (new_m == null && lang != DEFAULT_LANG) {
                new_m = GSXML.getNamedElement(m, "displayItem", "lang", DEFAULT_LANG);
            }
            if (new_m == null) {
                new_m = (Element)GSXML.getChildByTagName(m, "displayItem");
            }
            description.appendChild(new_m.cloneNode(true));
        }
        return true;
    }

    protected Element getDisplayTextElement(String key, String lang) {
        Element this_item = GSXML.getNamedElement(this.display_item_list, "displayItem", "name", key);
        if (this_item == null) {
            return null;
        }
        Element this_lang = GSXML.getNamedElement(this_item, "displayItem", "lang", lang);
        if (this_lang == null && lang != DEFAULT_LANG) {
            this_lang = GSXML.getNamedElement(this_item, "displayItem", "lang", DEFAULT_LANG);
        }
        if (this_lang == null) {
            return GSXML.getFirstElementChild(this_item);
        }
        return (Element)this_lang.cloneNode(true);
    }

    public HashMap getServiceMap() {
        return this.service_map;
    }
}

