/**********************************************************************
 *
 * httpsend.cpp
 * Copyright (C) 1996
 * 
 * A component of the fnord webserver written by bmorin@wpi.edu.
 *
 * Altered for use with the Greenstone digital library software by the
 * New Zealand Digital Library Project at the University of Waikato,
 * New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "text_t.h"

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#pragma hdrstop
#include "netio.h"
#include "httpreq.h"
#include "httpsend.h"

//Private Function Declarations
/*
Function Name: Check IMS Date
Purpose: Checks the string date of an "If Modified Since" header against
	a file date stamp.
Parameters:
	FileTime - Time stamp on file
	IMSStr - "If Modified Since" date string
Returns: TRUE if the file has been modified since the given date or
	the data can not be resolved (the string to date function will log
	any errors)
*/
BOOL CheckIMSDate(SYSTEMTIME &FileTime, char *IMSStr);

//Public Functions
/******************************************************************************/

void SendHTTPError(int ErrorNum, char *ErrorTitleStr, char *ErrorDescStr, 
		   RequestInfoT &RequestInfo, RequestFieldsT &RequestFields) {
  char Header[512];
  char Body[512];

  char ErrorNumStr[17];
  
  DWORD BodyLength;
  char BodyLengthStr[17];

  int HeaderLength;
  
  itoa(ErrorNum, ErrorNumStr, 10);
  
  // Didn't find it, build the message manually
  Body[0] = 0;
  strcat(Body, "<HTML><HEAD><TITLE>Server Error</TITLE></HEAD><BODY>\n");
  strcat(Body, "<H1>Error ");
  strcat(Body, ErrorNumStr);
  strcat(Body, ": ");
  strcat(Body, ErrorTitleStr);
  strcat(Body, "</H1>\n");
  strcat(Body, ErrorDescStr);
  strcat(Body, "\n</BODY></HTML>");
  BodyLength = (DWORD) strlen(Body);

  //Build Header
  Header[0] = 0;
  //Status Line
  strcat(Header, "HTTP/1.0 ");
  strcat(Header, ErrorNumStr);
  strcat(Header, " ");
  strcat(Header, ErrorDescStr);
  strcat(Header, "\r\n");
  //Server
  strcat(Header, "Server: GSDL\r\n");
  //Content Type (assume HTML)
  strcat(Header, "Content-Type: text/html\r\n");
  //Content Length
  itoa(BodyLength, BodyLengthStr, 10);
  strcat(Header, "Content-Length: ");
  strcat(Header, BodyLengthStr);
  strcat(Header, "\r\n");
  //Single CRLF to end header
  strcat(Header, "\r\n");
  
  HeaderLength = strlen(Header);
  
  //Send header
  SendData(RequestInfo.ClientSocket, (BYTE *) Header, strlen(Header), RequestInfo.ThreadNum);
  //Send generated data
  SendData(RequestInfo.ClientSocket, (BYTE *) Body, BodyLength, RequestInfo.ThreadNum);
}
