package org.greenstone.gatherer.cdm;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.TestingPreparation;

public class BuildTypeManager {

    /** The size of this new collection dialog box. */
    static private Dimension DIALOG_SIZE = new Dimension(600, 280);

    static final public String BUILD_TYPE_MG = "mg";
    static final public String BUILD_TYPE_MGPP = "mgpp";
    static final public String BUILD_TYPE_LUCENE = "lucene";
    static final public String BUILD_TYPE_SOLR = "solr";

    static final public String BUILD_TYPE_MG_STR = "MG";
    static final public String BUILD_TYPE_MGPP_STR = "MGPP";
    static final public String BUILD_TYPE_LUCENE_STR = "Lucene";
    static final public String BUILD_TYPE_SOLR_STR = "SOLR";

    static final public String[] BUILD_TYPES = {BUILD_TYPE_SOLR, BUILD_TYPE_LUCENE, BUILD_TYPE_MGPP, BUILD_TYPE_MG  };

    private EventListenerList listeners = null;
    /** the buildtype element in the config file - uses CollectionMeta */
    public CollectionMeta build_type_meta = null;
    private Control controls = null;

    protected BuildTypeManager manager = null;
    public BuildTypeManager() {
	build_type_meta = new CollectionMeta(CollectionDesignManager.collect_config.getBuildType());
	if (getBuildType().equals("")) {
	    build_type_meta.setValue(BUILD_TYPE_MG);
	    // must have an old collection, assume MG
	}
	listeners = new EventListenerList();
	manager = this;
    }

    public void addBuildTypeListener(BuildTypeListener listener) {
	listeners.add(BuildTypeListener.class, listener);
    }
    
    protected void notifyListeners(String new_build_type) {
	Object[] concerned = listeners.getListenerList();
	for(int i = 0; i < concerned.length ; i++) {
	    if(concerned[i] == BuildTypeListener.class) {
		((BuildTypeListener)concerned[i+1]).buildTypeChanged(new_build_type);
	    }
	}
	concerned = null;
    }
    
	
    public void promptForNewBuildType() {

	BuildTypePrompt btp = new BuildTypePrompt(build_type_meta.getValue(CollectionMeta.TEXT));	
    }

    public boolean isMGPP () {

	return getBuildType().equals(BUILD_TYPE_MGPP);
    }
    public boolean isMG () {

	return getBuildType().equals(BUILD_TYPE_MG);
    }
    public boolean isLucene () {

	return getBuildType().equals(BUILD_TYPE_LUCENE);
    }

    public boolean isSOLR () {
	return getBuildType().equals(BUILD_TYPE_SOLR);
    }
    public String getBuildType() {
	return build_type_meta.getValue(CollectionMeta.TEXT);
    }

    public Control getControls() {
	if (controls == null) {
	    controls = new BuildTypeControl();
	}
	return controls;
    }

    public interface BuildTypeListener
	extends EventListener {
	public void buildTypeChanged(String new_build_type);
    }

    private class BuildTypeControl 
	extends JPanel
	implements Control, BuildTypeListener {

	JLabel label = null;
	JButton change_button = null;
	
	public BuildTypeControl() {
	    super();
	    this.setComponentOrientation(Dictionary.getOrientation());
            
	    JPanel spacer_panel = new JPanel();
	    spacer_panel.setComponentOrientation(Dictionary.getOrientation());
            
	    JPanel main_panel = new JPanel();
            main_panel.setComponentOrientation(Dictionary.getOrientation());
	    /* may be CDM.BuildTypeManager.mg, CDM.BuildTYpeManager.mgpp, CDM.BuildTypeManager.lucene, CDM.BuildTypeManager.solr */
	    label = new JLabel(Dictionary.get("CDM.BuildTypeManager.Current_Type", getBuildTypeString(getBuildType())));
            label.setComponentOrientation(Dictionary.getOrientation());
	    
            change_button = new GLIButton(Dictionary.get("CDM.BuildTypeManager.Change"), Dictionary.get("CDM.BuildTypeManager.Change_Tooltip"));
	    	    
	    change_button.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent event) {
			promptForNewBuildType();
		    }
		});

	    main_panel.setLayout(new BorderLayout(10,10));
	    main_panel.add(label, BorderLayout.CENTER);
	    main_panel.add(change_button, BorderLayout.LINE_END);

	    setBorder(BorderFactory.createEmptyBorder(0,5,0,0));
	    setLayout(new BorderLayout());
	    add(spacer_panel, BorderLayout.CENTER);
	    add(main_panel, BorderLayout.LINE_END);

	    manager.addBuildTypeListener(this);
	    
	    TestingPreparation.setNamesRecursivelyForControl(this);
	}

	public void loseFocus() {}
	public void gainFocus() {}
	public void destroy() {}

	private String getBuildTypeString(String build_type) {
	    if (build_type.equals(BUILD_TYPE_MG)) {
		return BUILD_TYPE_MG_STR;
	    }
	    if (build_type.equals(BUILD_TYPE_MGPP)) {
		return BUILD_TYPE_MGPP_STR;
	    }
	    if (build_type.equals(BUILD_TYPE_LUCENE)) {
		return BUILD_TYPE_LUCENE_STR;
	    }
	    if (build_type.equals(BUILD_TYPE_SOLR)) {
		return BUILD_TYPE_SOLR_STR;
	    }
	    return "";
	}

		
	public void buildTypeChanged(String new_build_type) {
	    label.setText(Dictionary.get("CDM.BuildTypeManager.Current_Type", getBuildTypeString(new_build_type)));
	}
    }
    
    private class BuildTypePrompt 
	extends ModalDialog {
	
	private JDialog self;
	
	private JRadioButton mg_button = null;
	private JRadioButton mgpp_button = null;
	private JRadioButton lucene_button = null;
	private JRadioButton solr_button = null;

	private JTextArea description_textarea = null;
	
	JButton ok_button = null;
	JButton cancel_button = null;
	
	public BuildTypePrompt(String current_build_type) {
	    super(Gatherer.g_man, true);
	    this.self = this;
	    setSize(DIALOG_SIZE);
	    setTitle(Dictionary.get("CDM.BuildTypeManager.Title"));
            this.setComponentOrientation(Dictionary.getOrientation());

	    BuildTypeButtonListener btbl = new BuildTypeButtonListener();

	    mg_button = new JRadioButton(BUILD_TYPE_MG_STR);
            mg_button.setComponentOrientation(Dictionary.getOrientation());
	    mg_button.setActionCommand(BUILD_TYPE_MG);
	    mg_button.addActionListener(btbl);

	    mgpp_button = new JRadioButton(BUILD_TYPE_MGPP_STR);
            mgpp_button.setComponentOrientation(Dictionary.getOrientation());
	    mgpp_button.setActionCommand(BUILD_TYPE_MGPP);
	    mgpp_button.addActionListener(btbl);

	    lucene_button = new JRadioButton(BUILD_TYPE_LUCENE_STR);
            lucene_button.setComponentOrientation(Dictionary.getOrientation());
	    lucene_button.setActionCommand(BUILD_TYPE_LUCENE);
	    lucene_button.addActionListener(btbl);

	    if (Gatherer.GS3) {
		solr_button = new JRadioButton(BUILD_TYPE_SOLR_STR);
		solr_button.setComponentOrientation(Dictionary.getOrientation());
		solr_button.setActionCommand(BUILD_TYPE_SOLR);
		solr_button.addActionListener(btbl);
	    }
	    

	    ButtonGroup build_type_group = new ButtonGroup();
	    if (Gatherer.GS3) {
		build_type_group.add(solr_button);
	    }
	    build_type_group.add(lucene_button);
	    build_type_group.add(mgpp_button);
	    build_type_group.add(mg_button);

	    if (current_build_type != null) {
		if (current_build_type.equals(BUILD_TYPE_MGPP)) {
		    mgpp_button.setSelected(true);
		} else if (current_build_type.equals(BUILD_TYPE_MG)) {
		    mg_button.setSelected(true);
		} else if (current_build_type.equals(BUILD_TYPE_LUCENE)) {
		    lucene_button.setSelected(true);
		} else if (current_build_type.equals(BUILD_TYPE_SOLR)) {
		    solr_button.setSelected(true);
		} 
		
	    }
	    
	    JPanel radio_pane = new JPanel();
	    radio_pane.setLayout(new GridLayout(4,1));
	    if (Gatherer.GS3) {
		radio_pane.add(solr_button);
	    }
	    radio_pane.add(lucene_button);
	    radio_pane.add(mgpp_button);
	    radio_pane.add(mg_button);

            radio_pane.setComponentOrientation(Dictionary.getOrientation());
            
	    description_textarea = new JTextArea();
	    description_textarea.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
	    /* may be CDM.BuildTypeManager.mg_Description, CDM.BuildTYpeManager.mgpp_Description, CDM.BuildTypeManager.lucene_Description, CDM.BUildTypeMamanger.solr_Description*/
	    description_textarea.setText(Dictionary.get("CDM.BuildTypeManager."+current_build_type+"_Description"));
	    description_textarea.setCaretPosition(0);
	    description_textarea.setLineWrap(true);
	    description_textarea.setWrapStyleWord(true);
	    description_textarea.setComponentOrientation(Dictionary.getOrientation());
            
            cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
	    
	    cancel_button.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent event) {
			self.dispose();
		    }
		});
	    
	    ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
	    
	    ok_button.addActionListener(new ActionListener() {
		    public void actionPerformed(ActionEvent event) {
			String new_build_type = BUILD_TYPE_MGPP;
			if (mgpp_button.isSelected()) {
			    new_build_type = BUILD_TYPE_MGPP;
			} else if (mg_button.isSelected()) {
			    new_build_type = BUILD_TYPE_MG;
			} else if (lucene_button.isSelected()) {
			    new_build_type = BUILD_TYPE_LUCENE;
			} else if (solr_button.isSelected()) {
			    new_build_type = BUILD_TYPE_SOLR;
			}
			if (!build_type_meta.getValue(CollectionMeta.TEXT).equals(new_build_type)) {
			    manager.notifyListeners(new_build_type);
			    build_type_meta.setValue(new_build_type);
			}
			self.dispose();
		    }
		});
	    // tell the CDM that we have (possibly) changed
	    ok_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
	    JPanel button_pane = new JPanel();
	    button_pane.setLayout(new GridLayout(1,2));
	    button_pane.add(ok_button);
	    button_pane.add(cancel_button);
            button_pane.setComponentOrientation(Dictionary.getOrientation());
            
	    JPanel content_pane = (JPanel) getContentPane();
	    content_pane.setOpaque(true);
	    content_pane.setLayout(new BorderLayout());
	    content_pane.add(radio_pane, BorderLayout.NORTH);
	    content_pane.add(new JScrollPane(description_textarea), BorderLayout.CENTER);
	    content_pane.add(button_pane, BorderLayout.SOUTH);
            content_pane.setComponentOrientation(Dictionary.getOrientation());

	    TestingPreparation.setIndividualSubcomponentNames(this,
	    						      mg_button, mgpp_button,
	    						      lucene_button, solr_button);
	    
	    // Center and display.
	    Dimension screen_size = Configuration.screen_size;
	    this.setLocation((screen_size.width - DIALOG_SIZE.width) / 2, (screen_size.height - DIALOG_SIZE.height) / 2);
	    this.setVisible(true); // blocks until the dialog is killed
	       
	}

	public void loseFocus() {

	}
	public void gainFocus() {

	}
	public void destroy() {

	}
	
	private class BuildTypeButtonListener
	    implements ActionListener {

	    public void actionPerformed(ActionEvent event) {
		description_textarea.setText(Dictionary.get("CDM.BuildTypeManager."+event.getActionCommand()+"_Description"));
		description_textarea.setCaretPosition(0);
	    }
	}
    }
}
