/**********************************************************************
 *
 * IsisUtil.cpp
 * Copyright (C) 2003  UNESCO
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "stdafx.h"
#include "IsisUtil.h" 
#include <algorithm>


//---------------------------------------------------------------------------------
// bool RepFieldSep(TCHAR c)
//
// This function is a predicate that takes a TCHAR and returns a value that indicates
// if that TCHAR is a repeteable field separator.
//----------------------------------------------------------------------------------
bool RepFieldSep(char c)
{
	return (c == SYSRSEP);
}

//--------------------------------------------------------------------------------
// vector<string> SplitOccurences(const cstring& s)
//
// This function takes as input a string which contains a field and return a 
// vector<string> which will contain an entry for each field occurence.
//--------------------------------------------------------------------------------
std::vector<cstring> SplitOccurences(const cstring& s)
{
	typedef cstring::const_iterator iter;
	std::vector<cstring> ret;

	iter i = s.begin();
	//TRACE("\ni=%s",i);
	while (i != s.end())
	{
		// find end of occurence
		iter j = std::find_if(i,s.end(),RepFieldSep);

		// copy the characters in [i, j]
		ret.push_back(cstring(i, j));
		//TRACE("\ni=%s j=%s string(i,j)=%s", i, j, string(i,j).c_str());

		i = j;
		if (j != s.end())
		    i++;
	}
	return ret;
}


bool WSubFieldSep(WCHAR c)
{
	return (c == SUBFIELD_SEP);
}

//--------------------------------------------------------------------------------
// vector<cstring> SplitSubfields(const cstring& s, TCHAR sc)
//
// This function takes as input a string which contains a field and return a 
// vector<string> which will contain an entry for each subfield occurrence.
//--------------------------------------------------------------------------------
std::vector<cstring> SplitSubfields(const cstring& s, TCHAR sc/*=0*/)
{
	typedef cstring::const_iterator iter;
	std::vector<cstring> ret;

	iter i= s.begin();
	iter j;
	while (i < s.end())
	{
		// Look for subfield separator (^)
		iter k =  std::find_if(i ,s.end(),WSubFieldSep);
		if (k == s.end())
		{
			j = s.end(); // separator not found
		}
		else
		{
			// Special case when field is terminated by "^x" or "^"
			if (k==s.end()-1 || k==s.end()-2)
				break;
			i = k + 2;  // separator found, skip next char
			assert(i<s.end());
			j = std::find_if(i ,s.end() ,WSubFieldSep);
		}
		ret.push_back(cstring(i, j));
		i = j;
	}
	return ret;
}


//--------------------------------------------------------------------------------
// vector<string> SplitOccurences(const awstring& s)
//
// This function takes as input a string which contains a field and return a 
// vector<string> which will contain an entry for each field occurence.
//--------------------------------------------------------------------------------
//  std::vector<awstring> SplitOccurences(const awstring& s)
//  {
//  	typedef awstring::const_iterator iter;
//  	std::vector<awstring> ret;

//  	iter i = s.begin();
//  	//TRACE("\ni=%s",i);
//  	while (i != s.end())
//  	{
//  		// find end of occurence
//  		iter j = std::find_if(i,s.end(),RepFieldSep);

//  		// copy the characters in [i, j]
//  		ret.push_back(awstring(i, j));
//  		//TRACE("\ni=%s j=%s string(i,j)=%s", i, j, string(i,j).c_str());

//  		i = j;
//  		if (j != s.end())
//  		    i++;
//  	}
//  	return ret;
//  }


bool SubFieldSep(TCHAR c)
{
	return (c == SUBFIELD_SEP);
}

//--------------------------------------------------------------------------------
// vector<awstring> SplitSubfields(const awstring& s, TCHAR sc)
//
// This function takes as input a string which contains a field and return a 
// vector<string> which will contain an entry for each subfield occurrence.
//--------------------------------------------------------------------------------
//  std::vector<awstring> SplitSubfields(const awstring& s, TCHAR sc/*=0*/)
//  {
//  	typedef awstring::const_iterator iter;
//  	std::vector<awstring> ret;

//  	iter i = s.begin();
//  	//TRACE("\ni=%s",i);
//  	bool found=false;
//  	while (i != s.end())
//  	{
//  		// find index of subfield separator (^)
//  		iter j = std::find_if(i,s.end(),SubFieldSep);
//  		if (found && j<s.end()-1)
//  		{
//  		    // copy the characters in [i, j]
//  			ret.push_back(awstring(i+1, j));
//  		}
//  		if (sc==0 || s.at(j-s.begin()+1)==sc)
//  		    found = true;
//  		else
//  		    found = false;


//  		i = j+1;
//  		if (j != s.end())
//  		    i++;
//  	}
//  	return ret;
//  }
