/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.gui;

import de.qfs.lib.gui.TableModelSorterEvent;
import de.qfs.lib.gui.TableModelSorterListener;
import de.qfs.lib.log.Logger;
import java.awt.Component;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SortedTableHeaderCellRenderer
extends JLabel
implements TableCellRenderer,
TableModelSorterListener,
TableColumnModelListener {
    private static Logger logger = new Logger(class$de$qfs$lib$gui$SortedTableHeaderCellRenderer == null ? (class$de$qfs$lib$gui$SortedTableHeaderCellRenderer = SortedTableHeaderCellRenderer.class$("de.qfs.lib.gui.SortedTableHeaderCellRenderer")) : class$de$qfs$lib$gui$SortedTableHeaderCellRenderer);
    private static boolean initialized;
    private static Icon upArrow;
    private static Icon downArrow;
    private static Icon noArrow;
    private JTable table;
    private TableColumnModel columnModel;
    private int sortColumn = -1;
    private boolean ascending = true;
    static /* synthetic */ Class class$de$qfs$lib$gui$SortedTableHeaderCellRenderer;

    public SortedTableHeaderCellRenderer(JTable jTable) {
        if (SortedTableHeaderCellRenderer.logger.level >= 7) {
            logger.log(7, "SortedTableHeaderCellRenderer(JTable)", SortedTableHeaderCellRenderer.logger.level < 8 ? "" : "table: " + jTable);
        }
        SortedTableHeaderCellRenderer.initIcons();
        this.table = jTable;
        JTableHeader jTableHeader = jTable.getTableHeader();
        if (jTableHeader != null) {
            this.setForeground(jTableHeader.getForeground());
            this.setBackground(jTableHeader.getBackground());
            this.setFont(jTableHeader.getFont());
        } else {
            LookAndFeel.installColorsAndFont(this, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        }
        LookAndFeel.installBorder(this, "TableHeader.cellBorder");
        this.setOpaque(true);
        this.setIconTextGap(2);
        this.initColumns();
    }

    private static synchronized void initIcons() {
        if (!initialized) {
            if (SortedTableHeaderCellRenderer.logger.level >= 7) {
                logger.log(7, "initIcons()", "");
            }
            URL uRL = (class$de$qfs$lib$gui$SortedTableHeaderCellRenderer == null ? (class$de$qfs$lib$gui$SortedTableHeaderCellRenderer = SortedTableHeaderCellRenderer.class$("de.qfs.lib.gui.SortedTableHeaderCellRenderer")) : class$de$qfs$lib$gui$SortedTableHeaderCellRenderer).getResource("/de/qfs/lib/resources/icons/uparrow.gif");
            if (SortedTableHeaderCellRenderer.logger.level >= 9) {
                logger.log(9, "initIcons()", "URL for up arrow: " + uRL);
            }
            if (uRL != null && (upArrow = new ImageIcon(uRL)) == null) {
                logger.log(3, "initIcons()", "Couldn't load Icon for URL " + uRL);
            }
            uRL = (class$de$qfs$lib$gui$SortedTableHeaderCellRenderer == null ? (class$de$qfs$lib$gui$SortedTableHeaderCellRenderer = SortedTableHeaderCellRenderer.class$("de.qfs.lib.gui.SortedTableHeaderCellRenderer")) : class$de$qfs$lib$gui$SortedTableHeaderCellRenderer).getResource("/de/qfs/lib/resources/icons/downarrow.gif");
            if (SortedTableHeaderCellRenderer.logger.level >= 9) {
                logger.log(9, "initIcons()", "URL for down arrow: " + uRL);
            }
            if (uRL != null && (downArrow = new ImageIcon(uRL)) == null) {
                logger.log(3, "initIcons()", "Couldn't load Icon for URL " + uRL);
            }
            uRL = (class$de$qfs$lib$gui$SortedTableHeaderCellRenderer == null ? (class$de$qfs$lib$gui$SortedTableHeaderCellRenderer = SortedTableHeaderCellRenderer.class$("de.qfs.lib.gui.SortedTableHeaderCellRenderer")) : class$de$qfs$lib$gui$SortedTableHeaderCellRenderer).getResource("/de/qfs/lib/resources/icons/noarrow.gif");
            if (SortedTableHeaderCellRenderer.logger.level >= 9) {
                logger.log(9, "initIcons()", "URL for no arrow: " + uRL);
            }
            if (uRL != null && (noArrow = new ImageIcon(uRL)) == null) {
                logger.log(3, "initIcons()", "Couldn't load Icon for URL " + uRL);
            }
            initialized = true;
            if (SortedTableHeaderCellRenderer.logger.level >= 9) {
                logger.log(9, "initIcons()", "up: " + upArrow + ", down: " + downArrow);
            }
        }
    }

    public void reinit() {
        if (SortedTableHeaderCellRenderer.logger.level >= 7) {
            logger.log(7, "reinit()", "");
        }
        if (this.columnModel != null) {
            this.columnModel.removeColumnModelListener(this);
        }
        this.initColumns();
    }

    private void initColumns() {
        if (SortedTableHeaderCellRenderer.logger.level >= 7) {
            logger.log(7, "initColumns()", "");
        }
        this.columnModel = this.table.getColumnModel();
        Enumeration<TableColumn> enumeration = this.columnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(this);
        }
        this.columnModel.addColumnModelListener(this);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.setText(object.toString());
        int n3 = jTable.convertColumnIndexToModel(n2);
        if (n3 == this.sortColumn) {
            this.setIcon(this.ascending ? downArrow : upArrow);
        } else {
            this.setIcon(noArrow);
        }
        return this;
    }

    public void sortOrderChanged(TableModelSorterEvent tableModelSorterEvent) {
        if (SortedTableHeaderCellRenderer.logger.level >= 7) {
            logger.log(7, "sortOrderChanged(TableModelSorterEvent)", SortedTableHeaderCellRenderer.logger.level < 8 ? "" : "e: " + tableModelSorterEvent + ", column: " + tableModelSorterEvent.getColumn() + ", ascending: " + tableModelSorterEvent.isAscending());
        }
        this.sortColumn = tableModelSorterEvent.getColumn();
        this.ascending = tableModelSorterEvent.isAscending();
        this.table.getTableHeader().repaint();
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        ((TableColumnModel)tableColumnModelEvent.getSource()).getColumn(tableColumnModelEvent.getToIndex()).setHeaderRenderer(this);
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

