/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.comms.Communicator;
import org.greenstone.gsdl3.comms.SOAPCommunicator;
import org.greenstone.gsdl3.core.MessageRouter;
import org.greenstone.gsdl3.core.OAIReceptionist;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.OAIXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OAIServer
extends HttpServlet {
    protected OAIReceptionist recept = null;
    protected String default_lang = null;
    protected final String DEFAULT_LANG = "en";
    protected XMLConverter converter = null;
    protected Document doc = null;
    protected HashSet verb_set = null;
    protected HashSet param_set = null;
    protected String site = "";
    static Logger logger = Logger.getLogger((String)OAIServer.class.getName());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.default_lang = config.getInitParameter("default_lang");
        this.initVerbs();
        this.initParams();
        String site_name = config.getInitParameter("site_name");
        String remote_site_name = null;
        String remote_site_type = null;
        String remote_site_address = null;
        if (site_name == null) {
            remote_site_name = config.getInitParameter("remote_site_name");
            remote_site_type = config.getInitParameter("remote_site_type");
            remote_site_address = config.getInitParameter("remote_site_address");
            if (remote_site_name == null || remote_site_type == null || remote_site_address == null) {
                System.err.println("initialisation paramters not all set!");
                System.err.println("if site_name is not set, then you must have remote_site_name, remote_site_type and remote_site_address set");
                System.exit(1);
            }
        }
        if (this.default_lang == null) {
            this.default_lang = "en";
        }
        this.recept = new OAIReceptionist();
        if (site_name != null) {
            String mr_name = config.getInitParameter("messagerouter_class");
            MessageRouter message_router = null;
            if (mr_name == null) {
                message_router = new MessageRouter();
            } else {
                try {
                    message_router = (MessageRouter)Class.forName("org.greenstone.gsdl3.core." + mr_name).newInstance();
                }
                catch (Exception e) {
                    System.err.println("OAIServlet configure exception when trying to use a new MessageRouter " + mr_name + ": " + e.getMessage());
                    e.printStackTrace();
                    message_router = new MessageRouter();
                }
            }
            message_router.setSiteName(site_name);
            message_router.configure();
            this.recept.setSiteName(site_name);
            this.recept.setMessageRouter(message_router);
        } else {
            SOAPCommunicator communicator = null;
            Element site_elem = this.doc.createElement("site");
            site_elem.setAttribute("type", remote_site_type);
            site_elem.setAttribute("name", remote_site_name);
            site_elem.setAttribute("address", remote_site_address);
            if (remote_site_type.equals("soap")) {
                communicator = new SOAPCommunicator();
            } else {
                System.err.println("OAIServlet.init Error: invalid Communicator type: " + remote_site_type);
                System.exit(1);
            }
            if (!((Communicator)communicator).configure(site_elem)) {
                System.err.println("OAIServlet.init Error: Couldn't configure communicator");
                System.exit(1);
            }
            this.recept.setSiteName(remote_site_name);
            this.recept.setMessageRouter(communicator);
        }
        this.converter = new XMLConverter();
        OAIServer oAIServer = this;
        this.doc = oAIServer.converter.newDOM();
        Element oai_config = OAIXML.getOAIConfigXML();
        if (oai_config == null) {
            logger.error((Object)"Fail to parse oai config file OAIConfig.xml.");
            return;
        }
        this.recept.configure(oai_config);
    }

    private void initVerbs() {
        this.verb_set = new HashSet();
        this.verb_set.add("GetRecord");
        this.verb_set.add("ListRecords");
        this.verb_set.add("ListIdentifiers");
        this.verb_set.add("ListSets");
        this.verb_set.add("ListMetadataFormats");
        this.verb_set.add("Identify");
    }

    private void initParams() {
        this.param_set = new HashSet();
        this.param_set.add("metadataPrefix");
        this.param_set.add("from");
        this.param_set.add("until");
        this.param_set.add("set");
        this.param_set.add("resumptionToken");
        this.param_set.add("identifier");
    }

    private void logUsageInfo(HttpServletRequest request) {
        String usageInfo = "";
        usageInfo = request.getContextPath() + " " + request.getServletPath() + " " + "[" + request.getQueryString() + "]" + " " + "[" + usageInfo.trim() + "]" + " " + request.getRemoteAddr() + " " + request.getHeader("user-agent") + " ";
        logger.info((Object)usageInfo);
    }

    private boolean validate(String query, String verb) {
        if (query == null || !query.startsWith("verb=")) {
            return false;
        }
        return this.verb_set.contains(verb);
    }

    private String getVerb(String query) {
        if (query == null) {
            return "";
        }
        int verb_start_index = query.indexOf("=") + 1;
        int verb_end_index = query.indexOf("&");
        if (verb_end_index == -1) {
            return query.substring(verb_start_index);
        }
        return query.substring(verb_start_index, verb_end_index);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String query;
        PrintWriter out = response.getWriter();
        this.logUsageInfo(request);
        request.setCharacterEncoding("UTF-8");
        response.setContentType("text/xml;charset=UTF-8");
        String lang = request.getParameter("l");
        if (lang == null || lang.equals("")) {
            lang = this.default_lang;
        }
        String[] pairs = (query = request.getQueryString()) == null ? null : query.split("&");
        String verb = this.getVerb(query);
        Element xml_response = OAIXML.createBasicResponse(verb, pairs);
        Element verb_elem = null;
        if (!this.validate(query, verb)) {
            if (!this.verb_set.contains(verb)) {
                logger.error((Object)("badVerb: " + query));
                verb_elem = OAIXML.createErrorElement("badVerb", "Illegal OAI verb");
            } else {
                logger.error((Object)("badArgument: " + query));
                verb_elem = OAIXML.createErrorElement("badArgument", "");
            }
            xml_response.appendChild(verb_elem);
            out.println(XMLConverter.getPrettyString(xml_response));
            return;
        }
        Element xml_message = this.doc.createElement("message");
        Element xml_request = this.doc.createElement("request");
        xml_request.setAttribute("lang", lang);
        xml_request.setAttribute("to", verb);
        this.addParams(xml_request, pairs);
        xml_message.appendChild(xml_request);
        Node xml_result = this.recept.process(xml_message);
        if (xml_result == null) {
            logger.info((Object)"xml_result is null");
            verb_elem = OAIXML.createErrorElement("Internal error", "");
            xml_response.appendChild(verb_elem);
        } else {
            Node res = GSXML.getChildByTagName(xml_result, "response");
            if (res == null) {
                logger.info((Object)"response element in xml_result is null");
                verb_elem = OAIXML.createErrorElement("Internal error", "");
            } else {
                verb_elem = GSXML.getFirstElementChild(res);
            }
            if (OAIXML.oai_version.equals("2.0") || verb_elem.getTagName().equals("error")) {
                xml_response.appendChild(xml_response.getOwnerDocument().importNode(verb_elem, true));
            } else {
                GSXML.copyAllChildren(xml_response, verb_elem);
            }
        }
        out.println(XMLConverter.getPrettyString(xml_response));
    }

    public void addParams(Element request, String[] pairs) {
        if (pairs == null || pairs.length < 2) {
            return;
        }
        for (int i = 1; i < pairs.length; ++i) {
            int index = pairs[i].indexOf("=");
            if (index == -1) continue;
            Element param = this.doc.createElement("param");
            param.setAttribute("name", pairs[i].substring(0, index));
            param.setAttribute("value", OAIXML.oaiDecode(pairs[i].substring(index + 1)));
            request.appendChild(param);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

