/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util.x11;

import com.sun.jimi.core.util.x11.XColorNames;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class XpmParser {
    private DataInputStream f1;
    private int f2 = 0;
    private int f3 = 0;
    private int f4 = 0;
    private int f5 = 0;
    private int f6 = 0;
    private Hashtable f7;
    private Color[] f8;
    private byte[] f9 = null;
    private String f10;

    public boolean parse() {
        try {
            this.m1();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getWidth() {
        return this.f3;
    }

    public int getHeight() {
        return this.f4;
    }

    public byte[] getPixmap() {
        return this.f9;
    }

    public Color[] getColorTable() {
        return this.f8;
    }

    private void m1() throws Exception {
        this.m2();
        this.m3("static char");
        this.m4();
        this.f8 = new Color[this.f5];
        this.m5();
        this.m6();
    }

    private void m2() throws Exception {
        this.m7();
        if (this.f10 != null && this.f10.startsWith("/*") && this.f10.endsWith("*/")) {
            this.f10.substring(2).trim();
            this.m7();
        }
    }

    private void m3(String string) throws Exception {
        if (this.f10 == null) {
            throw new Exception("Invalid Xpm format, line: " + this.f2);
        }
        if (this.f10.startsWith(string)) {
            this.m7();
        }
    }

    private void m4() throws Exception {
        if (this.f10 != null && this.f10.startsWith("/*") && this.f10.endsWith("*/")) {
            this.m7();
        }
        if (this.f10 == null) {
            throw new Exception("Invalid Xpm format: unexpected EOF, line: " + this.f2);
        }
        int n = this.f10.indexOf(34);
        int n2 = this.f10.lastIndexOf(34);
        if (n < 0 || n2 < 0 || n2 <= n) {
            throw new Exception("Invalid Xpm format: hints line: " + this.f2);
        }
        String string = this.f10.substring(n + 1, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 4) {
            throw new Exception("Invalid Xpm format: hints line: " + this.f2);
        }
        try {
            this.f3 = Integer.parseInt(stringTokenizer.nextToken());
            this.f4 = Integer.parseInt(stringTokenizer.nextToken());
            this.f5 = Integer.parseInt(stringTokenizer.nextToken());
            this.f6 = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            throw new Exception("Invalid Xpm format: hints line: " + this.f2);
        }
        if (this.f6 > 3) {
            throw new Exception("Invalid Xpm format: Can only handle up to 3 chars per pixels");
        }
    }

    private void m5() throws Exception {
        int n = 0;
        while (n < this.f5) {
            this.m7();
            if (this.f10 != null && this.f10.startsWith("/*") && this.f10.endsWith("*/")) {
                this.m7();
            }
            if (this.f10 == null) {
                throw new Exception("Invalid Xpm format: unexpected EOF, line: " + this.f2);
            }
            int n2 = this.f10.indexOf(34);
            if (n2 < 0) {
                throw new Exception("Invalid Xpm format: color table, line: " + this.f2);
            }
            String string = this.f10.substring(n2 + 1);
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.f6) {
                n3 = (n3 << 8) + string.charAt(n4);
                ++n4;
            }
            string = this.f10.substring(n2 + 1 + this.f6);
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \"\t\n\r");
            int n5 = 0;
            while (stringTokenizer.hasMoreTokens() && n5 < 2) {
                String string2 = stringTokenizer.nextToken();
                switch (n5) {
                    case 0: {
                        if (!string2.equals("c")) break;
                        ++n5;
                        break;
                    }
                    case 1: {
                        this.f8[n] = this.m8(string2);
                        this.f7.put(new Integer(n3), new Integer(n));
                        ++n5;
                    }
                }
            }
            ++n;
        }
    }

    private void m6() throws Exception {
        this.m7();
        if (this.f10 != null && this.f10.startsWith("/*") && this.f10.endsWith("*/")) {
            this.m7();
        }
        if (this.f10 == null) {
            throw new Exception("Invalid Xpm format: EOF at line: " + this.f2);
        }
        int n = this.f3 * this.f4;
        this.f9 = new byte[n];
        int n2 = 0;
        while (this.f10 != null) {
            int n3 = this.f10.indexOf(34);
            int n4 = this.f10.lastIndexOf(34);
            if (n3 < 0 || n4 < 0 || n4 <= n3) {
                throw new Exception("Invalid Xpm format: line: " + this.f2);
            }
            String string = this.f10.substring(n3 + 1, n4);
            int n5 = 0;
            while (n5 < string.length()) {
                int n6 = 0;
                int n7 = 0;
                while (n7 < this.f6) {
                    n6 = (n6 << 8) + string.charAt(n5++);
                    ++n7;
                }
                this.f9[n2++] = (byte)((Integer)this.f7.get(new Integer(n6))).intValue();
            }
            if (n2 >= n) break;
            this.m7();
        }
    }

    private void m7() {
        this.f10 = null;
        try {
            this.f10 = this.f1.readLine();
        }
        catch (IOException iOException) {
            this.f10 = null;
        }
        if (this.f10 != null) {
            this.f10 = this.f10.trim();
        }
        ++this.f2;
    }

    private Color m8(String string) {
        Color color = null;
        if (string.charAt(0) == '#') {
            switch (string.length()) {
                case 4: {
                    break;
                }
                case 7: {
                    Integer n = Integer.valueOf(string.substring(1), 16);
                    color = new Color(n);
                    break;
                }
                case 13: {
                    Integer n = Integer.valueOf(string.substring(1, 3), 16);
                    Integer n2 = Integer.valueOf(string.substring(5, 7), 16);
                    Integer n3 = Integer.valueOf(string.substring(9, 11), 16);
                    color = new Color(n, n2, n3);
                }
            }
            if (color == null) {
                color = Color.black;
            }
        } else if (string.equalsIgnoreCase("none")) {
            color = null;
        } else {
            int n = XColorNames.getRgb(string);
            if (n != Integer.MIN_VALUE) {
                color = new Color(n);
            }
            if (color == null) {
                color = Color.black;
            }
        }
        return color;
    }

    public XpmParser(InputStream inputStream) {
        this.f1 = new DataInputStream(inputStream);
        this.f7 = new Hashtable();
    }
}

