/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RegExReplaceInfo;
import org.fife.ui.rtextarea.SearchContext;

public class SearchEngine {
    private SearchEngine() {
    }

    public static boolean find(JTextArea jTextArea, SearchContext searchContext) {
        String string = searchContext.getSearchFor();
        if (string == null || string.length() == 0) {
            return false;
        }
        Caret caret = jTextArea.getCaret();
        boolean bl = searchContext.getSearchForward();
        int n = bl ? Math.max(caret.getDot(), caret.getMark()) : Math.min(caret.getDot(), caret.getMark());
        String string2 = SearchEngine.getFindInText(jTextArea, n, bl);
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (!searchContext.isRegularExpression()) {
            int n2 = SearchEngine.getNextMatchPos(string, string2, bl, searchContext.getMatchCase(), searchContext.getWholeWord());
            string2 = null;
            if (n2 != -1) {
                caret.setSelectionVisible(true);
                n2 = bl ? n + n2 : n2;
                SearchEngine.selectAndPossiblyCenter(jTextArea, n2, n2 + string.length());
                return true;
            }
        } else {
            Point point = SearchEngine.getNextMatchPosRegEx(string, string2, bl, searchContext.getMatchCase(), searchContext.getWholeWord());
            string2 = null;
            if (point != null) {
                caret.setSelectionVisible(true);
                if (bl) {
                    point.translate(n, n);
                }
                SearchEngine.selectAndPossiblyCenter(jTextArea, point.x, point.y);
                return true;
            }
        }
        return false;
    }

    private static String getFindInText(JTextArea jTextArea, int n, boolean bl) {
        String string = null;
        if (bl) {
            try {
                string = jTextArea.getText(n, jTextArea.getDocument().getLength() - n);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            try {
                string = jTextArea.getText(0, n);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return string;
    }

    private static List getMatches(Matcher matcher, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (matcher.find()) {
            Point point = new Point(matcher.start(), matcher.end());
            if (string == null) {
                arrayList.add(point);
                continue;
            }
            arrayList.add(new RegExReplaceInfo(matcher.group(0), point.x, point.y, SearchEngine.getReplacementText(matcher, string)));
        }
        return arrayList;
    }

    public static final int getNextMatchPos(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (!bl2) {
            return SearchEngine.getNextMatchPosImpl(string.toLowerCase(), string2.toLowerCase(), bl, bl2, bl3);
        }
        return SearchEngine.getNextMatchPosImpl(string, string2, bl, bl2, bl3);
    }

    private static final int getNextMatchPosImpl(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (bl3) {
            int n = string.length();
            int n2 = bl ? 0 : string2.length();
            int n3 = bl ? 1 : -1;
            while ((n2 = bl ? string2.indexOf(string, n2) : string2.lastIndexOf(string, n2)) != -1) {
                if (SearchEngine.isWholeWord(string2, n2, n)) {
                    return n2;
                }
                n2 += n3;
            }
            return n2;
        }
        return bl ? string2.indexOf(string) : string2.lastIndexOf(string);
    }

    private static Point getNextMatchPosRegEx(String string, CharSequence charSequence, boolean bl, boolean bl2, boolean bl3) {
        return (Point)SearchEngine.getNextMatchPosRegExImpl(string, charSequence, bl, bl2, bl3, null);
    }

    private static Object getNextMatchPosRegExImpl(String string, CharSequence charSequence, boolean bl, boolean bl2, boolean bl3, String string2) {
        if (bl3) {
            string = "\\b" + string + "\\b";
        }
        int n = 8;
        Pattern pattern = Pattern.compile(string, n |= bl2 ? 0 : 66);
        Matcher matcher = pattern.matcher(charSequence);
        if (bl) {
            if (matcher.find()) {
                if (string2 == null) {
                    return new Point(matcher.start(), matcher.end());
                }
                return new RegExReplaceInfo(matcher.group(0), matcher.start(), matcher.end(), SearchEngine.getReplacementText(matcher, string2));
            }
        } else {
            List list = SearchEngine.getMatches(matcher, string2);
            if (!list.isEmpty()) {
                return list.get(list.size() - 1);
            }
        }
        return null;
    }

    private static RegExReplaceInfo getRegExReplaceInfo(String string, SearchContext searchContext) {
        String string2 = searchContext.getReplaceWith();
        if (string2 == null) {
            string2 = "";
        }
        String string3 = searchContext.getSearchFor();
        boolean bl = searchContext.getSearchForward();
        boolean bl2 = searchContext.getMatchCase();
        boolean bl3 = searchContext.getWholeWord();
        return (RegExReplaceInfo)SearchEngine.getNextMatchPosRegExImpl(string3, string, bl, bl2, bl3, string2);
    }

    public static String getReplacementText(Matcher matcher, CharSequence charSequence) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n < charSequence.length()) {
            char c = charSequence.charAt(n);
            if (c == '\\') {
                c = charSequence.charAt(++n);
                switch (c) {
                    case 'n': {
                        c = '\n';
                        break;
                    }
                    case 't': {
                        c = '\t';
                    }
                }
                stringBuffer.append(c);
                ++n;
                continue;
            }
            if (c == '$') {
                int n2;
                int n3;
                if ((n3 = charSequence.charAt(++n) - 48) < 0 || n3 > 9) {
                    throw new IndexOutOfBoundsException("No group " + charSequence.charAt(n));
                }
                ++n;
                boolean bl = false;
                while (!bl && n < charSequence.length() && (n2 = charSequence.charAt(n) - 48) >= 0 && n2 <= 9) {
                    int n4 = n3 * 10 + n2;
                    if (matcher.groupCount() < n4) {
                        bl = true;
                        continue;
                    }
                    n3 = n4;
                    ++n;
                }
                if (matcher.group(n3) == null) continue;
                stringBuffer.append(matcher.group(n3));
                continue;
            }
            stringBuffer.append(c);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static final boolean isWholeWord(CharSequence charSequence, int n, int n2) {
        boolean bl;
        boolean bl2;
        try {
            bl2 = !Character.isLetterOrDigit(charSequence.charAt(n - 1));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            bl2 = true;
        }
        try {
            bl = !Character.isLetterOrDigit(charSequence.charAt(n + n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            bl = true;
        }
        return bl2 && bl;
    }

    private static int makeMarkAndDotEqual(JTextArea jTextArea, boolean bl) {
        Caret caret = jTextArea.getCaret();
        int n = bl ? Math.min(caret.getDot(), caret.getMark()) : Math.max(caret.getDot(), caret.getMark());
        caret.setDot(n);
        return n;
    }

    private static boolean regexReplace(JTextArea jTextArea, SearchContext searchContext) throws PatternSyntaxException {
        Caret caret = jTextArea.getCaret();
        boolean bl = searchContext.getSearchForward();
        int n = SearchEngine.makeMarkAndDotEqual(jTextArea, bl);
        String string = SearchEngine.getFindInText(jTextArea, n, bl);
        if (string == null) {
            return false;
        }
        RegExReplaceInfo regExReplaceInfo = SearchEngine.getRegExReplaceInfo(string, searchContext);
        string = null;
        if (regExReplaceInfo != null) {
            caret.setSelectionVisible(true);
            int n2 = regExReplaceInfo.getStartIndex();
            int n3 = regExReplaceInfo.getEndIndex();
            if (bl) {
                n2 += n;
                n3 += n;
            }
            SearchEngine.selectAndPossiblyCenter(jTextArea, n2, n3);
            jTextArea.replaceSelection(regExReplaceInfo.getReplacement());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(RTextArea rTextArea, SearchContext searchContext) throws PatternSyntaxException {
        String string = searchContext.getSearchFor();
        if (string == null || string.length() == 0) {
            return false;
        }
        rTextArea.beginAtomicEdit();
        try {
            if (searchContext.isRegularExpression()) {
                boolean bl = SearchEngine.regexReplace(rTextArea, searchContext);
                return bl;
            }
            SearchEngine.makeMarkAndDotEqual(rTextArea, searchContext.getSearchForward());
            if (SearchEngine.find(rTextArea, searchContext)) {
                rTextArea.replaceSelection(searchContext.getReplaceWith());
                boolean bl = true;
                return bl;
            }
        }
        finally {
            rTextArea.endAtomicEdit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int replaceAll(RTextArea rTextArea, SearchContext searchContext) throws PatternSyntaxException {
        String string = searchContext.getSearchFor();
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = 0;
        rTextArea.beginAtomicEdit();
        try {
            int n2 = rTextArea.getCaretPosition();
            rTextArea.setCaretPosition(0);
            while (SearchEngine.replace(rTextArea, searchContext)) {
                ++n;
            }
            if (n == 0) {
                rTextArea.setCaretPosition(n2);
            }
        }
        finally {
            rTextArea.endAtomicEdit();
        }
        return n;
    }

    private static void selectAndPossiblyCenter(JTextArea jTextArea, int n, int n2) {
        Serializable serializable;
        Object object;
        boolean bl = false;
        if (jTextArea instanceof RSyntaxTextArea && ((FoldManager)(object = ((RSyntaxTextArea)(serializable = (RSyntaxTextArea)jTextArea)).getFoldManager())).isCodeFoldingSupportedAndEnabled()) {
            bl = ((FoldManager)object).ensureOffsetNotInClosedFold(n);
            bl |= ((FoldManager)object).ensureOffsetNotInClosedFold(n2);
        }
        jTextArea.setSelectionStart(n);
        jTextArea.setSelectionEnd(n2);
        serializable = null;
        try {
            serializable = jTextArea.modelToView(n);
            if (serializable == null) {
                return;
            }
            if (n2 != n) {
                serializable = ((Rectangle)serializable).union(jTextArea.modelToView(n2));
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            jTextArea.setSelectionStart(n);
            jTextArea.setSelectionEnd(n2);
            return;
        }
        object = jTextArea.getVisibleRect();
        if (!bl && ((Rectangle)object).contains((Rectangle)serializable)) {
            jTextArea.setSelectionStart(n);
            jTextArea.setSelectionEnd(n2);
            return;
        }
        ((Rectangle)object).x = ((Rectangle)serializable).x - (((Rectangle)object).width - ((Rectangle)serializable).width) / 2;
        ((Rectangle)object).y = ((Rectangle)serializable).y - (((Rectangle)object).height - ((Rectangle)serializable).height) / 2;
        Rectangle rectangle = jTextArea.getBounds();
        Insets insets = jTextArea.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        if (((Rectangle)object).x < rectangle.x) {
            ((Rectangle)object).x = rectangle.x;
        }
        if (((Rectangle)object).x + ((Rectangle)object).width > rectangle.x + rectangle.width) {
            ((Rectangle)object).x = rectangle.x + rectangle.width - ((Rectangle)object).width;
        }
        if (((Rectangle)object).y < rectangle.y) {
            ((Rectangle)object).y = rectangle.y;
        }
        if (((Rectangle)object).y + ((Rectangle)object).height > rectangle.y + rectangle.height) {
            ((Rectangle)object).y = rectangle.y + rectangle.height - ((Rectangle)object).height;
        }
        jTextArea.scrollRectToVisible((Rectangle)object);
    }
}

