/**********************************************************************
 *
 * wincgiutils.h
 * Copyright (C) 1996
 * 
 * A component of the fnord webserver written by bmorin@wpi.edu.
 *
 * Altered for use with the Greenstone digital library software by the
 * New Zealand Digital Library Project at the University of Waikato,
 * New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#define http_ok 0
#define http_error_url_invalid 11

int parse_url(const text_t &url, text_t &protocol, text_t &machine, 
	      int *port, text_t &name);

struct param_vals {char *name, *value; int vsize; char *dfault; };


int Send_String(char *str, RequestInfoT *RInfo);
int Send_String_N(char *str, int n,  RequestInfoT *RInfo);
void send_retrieve_error(int error_num, char *msg1, char *msg2, RequestInfoT *RequestInfo);
int send_header(char *content, RequestInfoT *RequestInfo);
void decode(char *st);
void decode_template(int ntemp, param_vals tmplate[]);
void parse_query_string(char *qstring, int ntemp, param_vals tmplate[]);
int mg_sender(char *UDoc, int ULen, int DocNum, float Weight, void *RInfo);

#define OUT_CONST_A(t) \
{if (Send_String_N(t, sizeof(t), RInfo) < 0) return;}

#define OUT_CONST_B(t) \
{if (Send_String_N(t, sizeof(t), (RequestInfoT *)RInfo) < 0) return -1;}

#define OUT_STRING_A(t) \
{if (Send_String(t, RInfo) < 0) return;}

#define OUT_STRING_B(t) \
{if (Send_String(t, (RequestInfoT *)RInfo) < 0) return -1;}

#define OUT_STRING_N_A(t,n) \
{if (Send_String_N(t, n, RInfo) < 0) return;}

#define OUT_STRING_N_B(t,n) \
{if (Send_String_N(t, n, (RequestInfoT *)RInfo) < 0) return -1;}
