/**********************************************************************
 *
 * fieldedqueryfilter.cpp -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#include "fieldedqueryfilter.h"

fieldedqueryfilterclass::fieldedqueryfilterclass () 
  : queryfilterclass() {

  FilterOption_t filtopt;
  
  // -- onePerTerm  Level          enumerated
  // likely to be Doc, Sec, Para, but we dont assume anything now
  filtopt.clear();
  filtopt.name = "Level";
  filtopt.type = FilterOption_t::enumeratedt;
  filtopt.repeatable = FilterOption_t::onePerTerm;
  filtopt.defaultValue = "";
  filterOptions["Level"] = filtopt;

  // --  IndexField, enumerated, used to list available fields
  filtopt.clear();
  filtopt.name = "IndexField";
  filtopt.type = FilterOption_t::enumeratedt;
  filtopt.repeatable = FilterOption_t::onePerTerm;
  filtopt.defaultValue = "";
  filterOptions["IndexField"] = filtopt;

}

void fieldedqueryfilterclass::configure (const text_t &key, const text_tarray &cfgline) {
  queryfilterclass::configure(key, cfgline);

  if (key == "indexfieldmap") {
    indexfieldmap.importmap (cfgline);
    text_tarray options;
    indexfieldmap.gettoarray (options);
    filterOptions["IndexField"].validValues = options;
    
  } else if (key == "levelmap") {
    levelmap.importmap (cfgline);
  } else if (key == "indexlevels") {
    filterOptions["Level"].validValues.erase(filterOptions["Level"].validValues.begin(), filterOptions["Level"].validValues.end());
    text_tarray::const_iterator here = cfgline.begin();
    text_tarray::const_iterator end = cfgline.end();
    while (here != end) {
      if (!(*here).empty()) {
	filterOptions["Level"].validValues.push_back(*here);
      }
      ++here;
    }
  } else if (key == "defaultindex") { // used for fields 
    indexfieldmap.from2to (cfgline[0], filterOptions["IndexField"].defaultValue);
  } else if (key == "defaultlevel") { 
    levelmap.from2to (cfgline[0], filterOptions["Level"].defaultValue);
  }
  
}

fieldedqueryfilterclass::~fieldedqueryfilterclass () {
}

bool fieldedqueryfilterclass::init (ostream &logout) {

  if (!queryfilterclass::init(logout)) {
    return false;
  }
  
  if (filterOptions["IndexField"].defaultValue.empty()) {
    // use first index in map as default if no default is set explicitly
    text_tarray fromarray;
    indexfieldmap.getfromarray(fromarray);
    if (fromarray.size()) {
      filterOptions["IndexField"].defaultValue = fromarray[0];
    }
  }
  if (filterOptions["Levels"].defaultValue.empty()) {
    // use first level as default if no default is set explicitly
    if (!filterOptions["Level"].validValues[0].empty())
      filterOptions["Levels"].defaultValue = filterOptions["Level"].validValues[0];
  }

  return true;
}

//whether a query is a full text browse
bool fieldedqueryfilterclass::full_text_browse (int filterRequestOptions) {
  return (filterRequestOptions & FRfullTextBrowse);
}
