/**********************************************************************
 *
 * dynamicclassifieraction.h -- 
 * Copyright (C) 2008  DL Consulting Ltd
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef DYNAMICCLASSIFIERACTION_H
#define DYNAMICCLASSIFIERACTION_H


#include "action.h"
#include "receptionist.h"


class dynamicclassifieraction : public action
{
protected:
  receptionist *recpt;

public:
  dynamicclassifieraction ();
  virtual ~dynamicclassifieraction ();

  void set_receptionist (receptionist *recpt_arg) { recpt = recpt_arg; }

  text_t get_action_name () { return "dc"; }

  bool check_cgiargs (cgiargsinfoclass &argsinfo, cgiargsclass &args, 
		      recptprotolistclass *protos, ostream &logout);

  void get_cgihead_info (cgiargsclass &args, recptprotolistclass *protos,
			 response_t &response,text_t &response_data, 
			 ostream &logout);

  void define_external_macros (displayclass &disp, cgiargsclass &args, 
			       recptprotolistclass *protos, ostream &logout);

  virtual void define_internal_macros (displayclass &disp, cgiargsclass &args, 
				       recptprotolistclass *protos, ostream &logout);

  bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
		  ostream &logout);

  text_tmap parse_classifier_options (text_t classifier_specification, cgiargsclass &args);

  text_t output_hlist_classifier_nodes (text_t parent_classifier_node_OID,
					text_t metadata_value_filter,
					text_t metadata_value_grouping_expression,
					text_tmap classifier_options, cgiargsclass &args,
					recptproto *collectproto, browsermapclass *browsers,
					displayclass &disp, outconvertclass &outconvert,
					ostream &textout, ostream &logout);

  void output_upper_classifier_nodes (text_t root_classifier_node_OID,
				      text_tlist parent_classifier_node_labels,
				      int& classifier_node_indent,
				      text_tmap classifier_options, cgiargsclass &args,
				      recptproto *collectproto, browsermapclass *browsers,
				      displayclass &disp, outconvertclass &outconvert,
				      ostream &textout, ostream &logout);

  void output_child_classifier_nodes (text_t classifier_node_OID,
				      text_t classifier_node_metadata_value,
				      text_t metadata_value_filter,
				      int& classifier_node_indent,
				      text_tmap classifier_options, cgiargsclass &args,
				      recptproto *collectproto, browsermapclass *browsers,
				      displayclass &disp, outconvertclass &outconvert,
				      ostream &textout, ostream &logout);

  text_t split_metadata_value (text_t metadata_value, text_tmap classifier_options);

  void display_classifier_nodes (FilterResponse_t classifier_nodes_response,
				 text_t classifier_nodes_type,
				 int classifier_nodes_indent,
				 cgiargsclass &args, recptproto *collectproto,
				 browsermapclass *browsers, displayclass &disp,
				 outconvertclass &outconvert, ostream &textout,
				 ostream &logout);

  void display_document_nodes (FilterResponse_t documents_response,
			       int document_nodes_indent,
			       cgiargsclass &args, recptproto *collectproto,
			       browsermapclass *browsers, displayclass &disp,
			       outconvertclass &outconvert, ostream &textout,
			       ostream &logout);
};


#endif
