/**********************************************************************
 *
 * basequeryaction.h -- 
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/


#ifndef BASEQUERYACTION_H
#define BASEQUERYACTION_H

#include "gsdlconf.h"
#include "action.h"
#include "receptionist.h"

struct colinfo_t {
  void clear();
  colinfo_t () {clear();}

  format_t *formatlistptr;
  browserclass *browserptr;
};

struct QueryResult_t {
  void clear ();
  QueryResult_t () {clear();}

  ResultDocInfo_t doc;
  text_t collection;
};

struct gteqQueryResult_t 
{
  bool operator()(const QueryResult_t &t1, const QueryResult_t &t2) const
  { return t1.doc.ranking >= t2.doc.ranking; }
};

typedef set<QueryResult_t, gteqQueryResult_t> QueryResult_tset;


class basequeryaction : public action {

protected:

  receptionist *recpt;

  virtual text_t query_filter_name ()=0;

  virtual void get_formatted_query_string (text_t &formattedstring, 
					   bool segment, 
					   cgiargsclass &args, 
					   displayclass &disp, ostream &logout)=0;

  virtual void define_single_query_macros (cgiargsclass &args, 
					   displayclass &disp, 
					   const FilterResponse_t &response); 

  virtual void define_query_macros (cgiargsclass &args, displayclass &disp, 
				    int numDocs, isapprox isApprox); 

  virtual void define_history_macros (displayclass &disp, cgiargsclass &args, 
				      recptprotolistclass *protos, 
				      ostream &logout);
  
  virtual void set_queryfilter_options (FilterRequest_t &request, 
					const text_t &querystring,
					cgiargsclass &args)=0;


  virtual void define_form_macros (displayclass &disp, cgiargsclass &args, 
				   recptprotolistclass *protos, 
				   ostream &logout) = 0;


  virtual void set_option_macro (const text_t &macroname, text_t current_value,
				 bool display_single, bool add_js_update,
				 const FilterOption_t &option, 
				 displayclass &disp);

  void set_option_macro (const text_t &macroname, 
			 text_t current_value, 
			 bool display_single, 
			 bool add_js_update,
			 const FilterOption_t &option_domain, 
			 const FilterOption_t &option_range, 
			 displayclass &disp);

  bool search_single_collection (cgiargsclass& args, const text_t& collection,
				 recptprotolistclass* protos, 
				 browsermapclass* browsers, 
				 displayclass& disp, 
				 outconvertclass &outconvert, 
				 ostream &textout, ostream &logout);

  virtual bool save_search_history(cgiargsclass &args, int numdocs, 
				   isapprox isApprox)=0;

public:
  basequeryaction ();
  virtual ~basequeryaction () {}

  void set_receptionist (receptionist *therecpt) {recpt=therecpt;}
  
  void configure (const text_t &key, const text_tarray &cfgline);
  bool init (ostream &logout);
  
  virtual text_t get_action_name ()=0;

  virtual bool check_cgiargs (cgiargsinfoclass &argsinfo, cgiargsclass &args, 
			      recptprotolistclass *protos, ostream &logout);

  void get_cgihead_info (cgiargsclass &args, recptprotolistclass *protos,
			 response_t &response, text_t &response_data, 
			 ostream &logout);
  
  virtual void define_internal_macros (displayclass &disp, cgiargsclass &args, 
				       recptprotolistclass *protos, ostream &logout);

  virtual void define_external_macros (displayclass &disp, cgiargsclass &args, 
				       recptprotolistclass *protos, ostream &logout)=0;
  
  virtual bool do_action (cgiargsclass &args, recptprotolistclass *protos, 
		  browsermapclass *browsers, displayclass &disp, 
		  outconvertclass &outconvert, ostream &textout, 
			  ostream &logout)=0;

};

#endif
