/* ------------------------------------------------------------------- */
/* norMARC   : Convert a metatag struct to NORMARC                     */
/*                                                                     */
/* 1998-09-30: Ole Husby                                               */
/* ------------------------------------------------------------------- */

#include <stdio.h>
#include <string.h>
#include "d2m.h" 



int norMARC(struct metatag *mt, struct marcrec *mr)
{
  char pre[64], creator_tag[4], title_tag[4];

  *pre = 0;

  if (strcasecmp(mt->name, "title") == 0)
  {
    if ( (!*mt->type)
         | (strcasecmp(mt->type, "main") == 0)
         | (strcasecmp(mt->type, "long") == 0) )
    {
      if (mr->ntitles)
        strcpy(title_tag, "246");
      else
        strcpy(title_tag, "245");

      mr->ntitles++;

      sprintf(pre, "%s  $a", title_tag);
    }
    else if (strcasecmp(mt->type, "subtitle") == 0)
    {
      if (mr->ntitles < 2)
        strcpy(mr->subtitle, mt->value);
    }
  }

  else if (strcasecmp(mt->name, "creator") == 0)
  {
    if ( (!*mt->type) || (strcasecmp(mt->type, "name") == 0) 
      || (strcasecmp(mt->type, "personalname") == 0) )
    {
      if (mr->ncreators)
        strcpy(creator_tag, "700");
      else
        strcpy(creator_tag, "100");

      mr->ncreators++;

      sprintf(pre, "%s  $a", creator_tag);
    }

    else if (strcasecmp(mt->type, "corporatename") == 0) 
    {
      if (mr->ncreators)
        strcpy(creator_tag, "710");
      else
        strcpy(creator_tag, "110");

      mr->ncreators++;

      sprintf(pre, "%s  $a", creator_tag);
    }
  }

  else if (strcasecmp(mt->name, "publisher") == 0)
  {
    if (!*mt->type)
      strcpy(pre, "260  $b");
    else if (strcasecmp(mt->type, "name") == 0)
      strcpy(pre, "260  $b");
  }

  else if (strcasecmp(mt->name, "contributor") == 0)
  {
    if ( (!*mt->type)|| (strcasecmp(mt->type, "name") == 0)
      || (strcasecmp(mt->type, "personalname") == 0) )
      strcpy(pre, "700  $a");
    else if (strcasecmp(mt->type, "corporatename") == 0)
      strcpy(pre, "710  $a");
  }

  else if (strcasecmp(mt->name, "coverage") == 0)
  {
    if (!*mt->scheme)
      strcpy(pre, "500  $a");
    else if (strcasecmp(mt->scheme, "freetext") == 0)
      strcpy(pre, "500  $a");
  }

  else if (strcasecmp(mt->name, "source") == 0)
  {
    if (!*mt->scheme)
      strcpy(pre, "500  $a Kilde:");
    else if (strcasecmp(mt->scheme, "freetext") == 0)
      strcpy(pre, "500  $a Kilde:");
    else if (strcasecmp(mt->scheme, "url") == 0)
      strcpy(pre, "500  $a Kilde: URL:");
    else if (strcasecmp(mt->scheme, "urn") == 0)
      strcpy(pre, "500  $a Kilde: URN:");
    else if (strcasecmp(mt->scheme, "isbn") == 0)
      strcpy(pre, "500  $a Kilde: ISBN:");
    else if (strcasecmp(mt->scheme, "issn") == 0)
      strcpy(pre, "500  $a Kilde: ISSN:");
  }

  else if (strcasecmp(mt->name, "rights") == 0)
  {
    if (!*mt->scheme)
      strcpy(pre, "500  $a Copyright:");
    else if (strcasecmp(mt->scheme, "freetext") == 0)
      strcpy(pre, "500  $a Copyright:");
  }

  else if (strcasecmp(mt->name, "identifier") == 0)
  {
    if (!*mt->scheme)
      strcpy(mr->url, mt->value);
    else if (strcasecmp(mt->scheme, "url") == 0)
      strcpy(mr->url, mt->value);
    else if (strcasecmp(mt->scheme, "urn") == 0)
      strcpy(pre, "856  $u urn:");
    else if (strcasecmp(mt->scheme, "isbn") == 0)
      strcpy(pre, "020  $a");
    else if (strcasecmp(mt->scheme, "issn") == 0)
      strcpy(pre, "022  $a");
  }

  else if (strcasecmp(mt->name, "language") == 0)
  {
    if (strcasecmp(mt->scheme, "z39.53") == 0)
    {
      if (strlen(mt->value) == 3)
        put008(mr->s008, mt->value, F008_LANGUAGE);
    }
  }

  else if (strcasecmp(mt->name, "format") == 0)
  {
    if (!*mt->scheme)
      strcpy(mr->fmat, mt->value);
    else if (strcasecmp(mt->scheme, "imt") == 0)
      strcpy(mr->fmat, mt->value);
    else if (strcasecmp(mt->scheme, "mime") == 0)
      strcpy(mr->fmat, mt->value);
  }

  else if (strcasecmp(mt->name, "subject") == 0)
  {
    if (!*mt->scheme)
      strcpy(pre, "691  $a");
    else if (strcasecmp(mt->scheme, "internal") == 0)
      strcpy(pre, "691  $a");
    else if (strcasecmp(mt->scheme, "udc") == 0)
      strcpy(pre, "080  $a");
    else if (strcasecmp(mt->scheme, "lcsh") == 0)
      strcpy(pre, "650  $a");
    else if (strcasecmp(mt->scheme, "ddc") == 0)
      strcpy(pre, "082  $a");
    else if (strcasecmp(mt->scheme, "mesh") == 0)
      strcpy(pre, "660  $a");
    else if (strcasecmp(mt->scheme, "humord") == 0)
      strcpy(pre, "698  $a");
    else if (strcasecmp(mt->scheme, "ntub") == 0)
      strcpy(pre, "699  $a");
  }

  else if (strcasecmp(mt->name, "date") == 0)
  {
    if ( (strncasecmp(mt->scheme, "ans", 3) == 0) ||
         (strncasecmp(mt->scheme, "iso", 3) == 0) )
    {
      if ( (!*mt->type) || ( strcasecmp(mt->type, "current") == 0) )
      {
        if (find_year(mt->value))
        {
          strcpy(mr->year, mt->value);
          put008(mr->s008, mt->value, F008_DATE1);
        }
      }
    }
  }

  if (*pre)
  {
    strcat(mr->marcline, pre);
    strcat(mr->marcline, " ");
    strcat(mr->marcline, mt->value);
    strcat(mr->marcline, "\n");
  }
}
